<?php

extract(shortcode_atts(array(
    'style' => 'h_small',
    'title' => 'Investment Deal Team',
    'add_icon' => 'no',
    'icon_bg' => 'yes',
    'add_link' => '',
    'title_link' => '#',
    'type' => 'perch',
    'icon_perch' => 'perch perch-value',
    'icon_pixden' => 'pe-7s-album',
    'icon_linecons' => '',
    'icon_entypo' => '',
    'icon_typicons' => '',
    'icon_openiconic' => '',    
    'icon_fontawesome' => '',    
    'desc' => '',
), $args));

if(function_exists('vc_icon_element_fonts_enqueue') && $type != 'perch'){
	vc_icon_element_fonts_enqueue( $type );
	wp_enqueue_style( 'vc_'.$type );
}
$link_start = $link_end = '';
if( $add_link == 'yes' ){
	$link_start = '<a href="'.esc_url($title_link).'">';
	$link_end = '</a>';
}

$icon_bg  = (($icon_bg == 'yes') && ($add_icon == 'yes'))?  $icon_bg : 'no';
$icon = 'icon_'.$type;
$icon_value = (!isset($args[$icon]))? 'perch perch-value' : $args[$icon];
?>

<div class="list-item list-icon-<?php echo esc_attr($add_icon) ?> icon-bg-<?php echo esc_attr($icon_bg) ?>">
	<?php if($add_icon != 'yes'): ?>
		<span class="square-primary"></span>
	<?php else: ?>
		<?php if( $icon_bg == 'yes' ): ?>
			<div class="expertise-icon">
				<i class="<?php echo esc_attr( $icon_value ) ?>"></i>
			</div>
		<?php else: ?>	
			<i class="<?php echo esc_attr( $icon_value ) ?>"></i>
		<?php endif; ?>
	<?php endif; ?>

	<?php if( ($style == 'h_small') || ($style == 'normal') ): ?>
		<p class="<?php echo esc_attr($style) ?>"><?php echo $link_start.investment_parse_text($title).$link_end ?></p>
	<?php else: ?>	
		<<?php echo esc_attr($style) ?> class="heading-title"><?php echo $link_start.investment_parse_text($title).$link_end ?></<?php echo esc_attr($style) ?>>
	<?php endif; ?>

	<?php if($desc != ''): ?>
		<p class="small"><?php echo force_balance_tags(nl2br($desc)) ?></p>
	<?php endif; ?>
</div>