<?php

extract(shortcode_atts(array(
	'style' => 'vertical',
	'language' => 'en',
    'post_url'  => '//themeperch.us9.list-manage.com/subscribe/post?u=d33802e92fdc29def2e7af643&id=0085e5e2b5',
    'title'  => 'Try Premium Account',
    'fields'  => [],
    'button_text' => 'Get started'
), $args));

wp_enqueue_script( 'investment-mc-scripts');
?>

<?php if( $style == 'vertical' ): ?>
	<form class="mailchimp" role="form" data-posturl="<?php echo esc_url($post_url) ?>" novalidate="true" data-language="<?php echo esc_attr($language); ?>">
		<div class="vertical-registration-form text-dark mc-form-wrap">
			<?php echo ($title != '')? '<h3>'.esc_attr($title).'</h3>' : ''; ?>
			<?php  
				if( !empty($fields) ):
					$optionsArr = array();
					foreach ($fields as $key => $value) {
						switch ($value['type']) {
							case 'select':
								if( $value['options'] != '' ){
									$optionsArr = explode('|', $value['options']);
								}
					        	echo '<select class="form-select" name="'.esc_attr($value['name']).'">';
					        	echo ($value['placeholder'] != '')? '<option value="">'.esc_attr($value['placeholder']).'</option>' : '';
					        	if( !empty($optionsArr) ){
					        		foreach ($optionsArr as $option) {
					        			$optionArr = explode(',', $option);
					        			echo '<option value="'.(isset($optionArr[0])? $optionArr[0] : '').'">'.(isset($optionArr[1])? $optionArr[1] : $optionArr[0]).'</option>';
					        		}
					        	}
					        	echo '</select>';
					        break;
					        case 'radio':
					        	echo '<div class="form-field text-left">';
					        	if( $value['options'] != '' ){
									$optionsArr = explode('|', $value['options']);
								}
								if( !empty($optionsArr) ){
									echo ($value['placeholder'] != '')? '<label>'.esc_attr($value['placeholder']).'</label><br>' : '';
					        		foreach ($optionsArr as $option) {
					        			$optionArr = explode(',', $option);
					        			echo '<input class="form-check-input" name="'.esc_attr($value['name']).'" type="radio" value="'.(isset($optionArr[0])? $optionArr[0] : '').'"> '.(isset($optionArr[1])? $optionArr[1] : $optionArr[0]).' ';
					        		}
					        	}
					        	echo '</div>';
					        break;
					        case 'checkbox':
					        	echo '<p class="form-field text-left">';
					        	if( $value['options'] != '' ){
									$optionsArr = explode('|', $value['options']);
								}
								if( !empty($optionsArr) ){
									echo ($value['placeholder'] != '')? '<label>'.esc_attr($value['placeholder']).'</label><br>' : '';
					        		foreach ($optionsArr as $option) {
					        			$optionArr = explode(',', $option);
					        			echo '<input class="form-check-input" name="'.esc_attr($value['name']).'" type="checkbox" value="'.(isset($optionArr[0])? $optionArr[0] : '').'"> '.(isset($optionArr[1])? $optionArr[1] : $optionArr[0]).' ';
					        		}
					        	}
					        	echo '</p>';
					        break;
					        case 'email':
					        	echo '<div><input name="'.esc_attr($value['name']).'" class="form-control input-box" placeholder="'.esc_attr($value['placeholder']).'" type="email"></div>';
					        break;
					        case 'date':
					        	echo '<div><input name="'.esc_attr($value['name']).'" class="form-control input-box datefield" placeholder="'.esc_attr($value['placeholder']).'" type="text" data-format="'.esc_attr($value['format']).'"></div>';
					        	wp_enqueue_style('jquery-ui-datepicker-style');
								wp_enqueue_script('jquery-ui');
					        break;
					        default:
					        	echo '<div><input name="'.esc_attr($value['name']).'" class="form-control input-box" placeholder="'.esc_attr($value['placeholder']).'" type="text"></div>';
						}
					}
				endif;
			?>	
			<h6 class="subscription-success"></h6>
			<h6 class="subscription-error"></h6>
		  <div class="read-more-wrap">
		  <input value="<?php echo esc_attr($button_text); ?>" class="btn btn-secondary" type="submit">
		  </div>
		</div>
	</form>
<?php else: ?>
	<div class="sf-container vc-horizontal-mc mc-form-wrap">
		<form class="subscription-form mailchimp form-inline" role="form" data-posturl="<?php echo esc_url($post_url) ?>" novalidate="true" data-language="<?php echo esc_attr($language); ?>">
			
			<?php echo ($title != '')? '<h3>'.esc_attr($title).'</h3>' : ''; ?>
			<h6 class="subscription-success"></h6>
			<h6 class="subscription-error"></h6>
			<?php  
				if( !empty($fields) ):
					$optionsArr = array();
					foreach ($fields as $key => $value) {
						switch ($value['type']) {
							case 'select':
								if( $value['options'] != '' ){
									$optionsArr = explode('|', $value['options']);
								}

								echo '<div class="input-group">';
								echo '<span class="input-group-text">'.esc_attr($value['placeholder']).'</span>';
					        	echo '<select class="form-select" name="'.esc_attr($value['name']).'">';
					        	echo ($value['placeholder'] != '')? '<option value="">'.esc_attr($value['placeholder']).'</option>' : '';
					        	if( !empty($optionsArr) ){
					        		foreach ($optionsArr as $option) {
					        			$optionArr = explode(',', $option);
					        			echo '<option value="'.(isset($optionArr[0])? $optionArr[0] : '').'">'.(isset($optionArr[1])? $optionArr[1] : $optionArr[0]).'</option>';
					        		}
					        	}
					        	echo '</select>';
								echo '</div>';
					        break;
					        case 'radio':
					        	echo '<p class="form-field text-left">';
					        	if( $value['options'] != '' ){
									$optionsArr = explode('|', $value['options']);
								}
								if( !empty($optionsArr) ){
									echo ($value['placeholder'] != '')? '<label>'.esc_attr($value['placeholder']).'</label><br>' : '';
					        		foreach ($optionsArr as $option) {
					        			$optionArr = explode(',', $option);
					        			echo '<input class="form-check-input" name="'.esc_attr($value['name']).'" type="radio" value="'.(isset($optionArr[0])? $optionArr[0] : '').'"> '.(isset($optionArr[1])? $optionArr[1] : $optionArr[0]).' ';
					        		}
					        	}
					        	echo '</p>';
					        break;
					        case 'checkbox':
					        	echo '<p class="form-field text-left">';
					        	if( $value['options'] != '' ){
									$optionsArr = explode('|', $value['options']);
								}
								if( !empty($optionsArr) ){
									echo ($value['placeholder'] != '')? '<label>'.esc_attr($value['placeholder']).'</label><br>' : '';
					        		foreach ($optionsArr as $option) {
					        			$optionArr = explode(',', $option);
					        			echo '<input class="form-check-input" name="'.esc_attr($value['name']).'" type="checkbox" value="'.(isset($optionArr[0])? $optionArr[0] : '').'"> '.(isset($optionArr[1])? $optionArr[1] : $optionArr[0]).' ';
					        		}
					        	}
					        	echo '</p>';
					        break;
					        case 'email':
								echo '<div class="input-group">';
								echo '<span class="input-group-text">Email</span>';
					        	echo '<input name="'.esc_attr($value['name']).'" class="form-control input-box" placeholder="'.esc_attr($value['placeholder']).'" type="email">';
								echo '</div>';
					        break;
							case 'date':
					        	echo '<div class="input-group">
								<span class="input-group-text">Date</span>
								<input name="'.esc_attr($value['name']).'" class="form-control input-box datefield" placeholder="'.esc_attr($value['placeholder']).'" type="text" data-format="'.esc_attr($value['format']).'">
								</div>';
					        	wp_enqueue_style('jquery-ui-datepicker-style');
					        break;
					        default:
								echo '<div class="input-group">';
								echo '<span class="input-group-text">'.esc_attr($value['placeholder']).'</span>';
					        	echo '<input name="'.esc_attr($value['name']).'" class="form-control input-box" placeholder="'.esc_attr($value['placeholder']).'" type="text">';
								echo '</div>';
						}
					}
				endif;
			?>				
		  <input value="<?php echo esc_attr($button_text); ?>" class="btn btn-secondary btn_normal" type="submit">		
	</form>
	</div>
<?php endif; ?>