<?php

extract(shortcode_atts(array(
    'nav_logo'  => INVESTMENT_ASSETS.'/images/logo.png',
    'socaial_links' => [],
), $args));

?>

<!-- ONLY LOGO ON HEADER -->
<div class="navigation-header">
	<div class="navbar non-sticky d-flex flex-row justify-content-between align-items-center gap-20">	
			<?php if($nav_logo != ''): ?>
			<div class="navbar-header">
				<a class="navbar-brand" href="<?php the_permalink(); ?>"><img src="<?php echo esc_url($nav_logo) ?>" alt="<?php bloginfo( 'name' ); ?>"></a>	
			</div>
			<?php endif; ?>

			<?php 
			if( !empty($socaial_links) ): 
				wp_enqueue_style('vc_font_awesome_5');
			?>
			<ul class="nav navbar-right social-navigation hidden-xs d-flex gap-5">
				<?php 
				foreach ($socaial_links as $key => $value) {
					$class = preg_replace('/\s+/', '', esc_attr($value['icon']));
					$class = substr($class, 5);
					echo '<li><a class="'.$class.' rounded-circle" href="'.esc_url($value['link']).'" target="_blank" title="'.esc_attr($value['title']).'"><i class="'.esc_attr($value['icon']).'"></i></a></li>';
				}
				?>					
			</ul>
			<?php endif; ?>			
	</div><!-- /END ONLY LOGO ON HEADER -->
</div>