<?php

extract(shortcode_atts(array(
	'navbar_visible' => 'no',
	'sticky_disable' => 'no', 
    'nav_logo'  => INVESTMENT_ASSETS.'/images/logo.png',
    'header_logo' => INVESTMENT_ASSETS.'/images/logo-white.png',
    'nav_menu' => '',
    'buttons' => ''
), $args));
wp_enqueue_script('onepage-nav');

$navbar_class = ($navbar_visible == 'yes')? 'navbar-on' : 'navbar-off';
?>

<!-- HEADER	 -->
<div id="header" <?php investment_header_class($navbar_class) ?>>
    	
	<?php 
	
	$classArr = array('navbar', 'navbar-expand-lg', 'hover-menu', 'dropdown-fade-up', 'py-0');

	if( in_array('transparent-header', investment_get_header_class()) ){
		$classArr[] = 'navbar-dark';
		$classArr[] = 'border-bottom';       
	}else{
        $classArr[] = 'navbar-light';
    }

    $logo_dim = ot_get_option('logo_dimension', array(
        'width' => '250',
        'height' => '70',
    ));

    $logo_width = isset($logo_dim['width']) ? $logo_dim['width'] : '250';
    $logo_height = isset($logo_dim['height']) ? $logo_dim['height'] : '70';

	?>
	
	<div class="container">
        <nav class="<?php echo implode(' ', $classArr) ?>">
        	
            <?php 
            // $logo = ot_get_option('logo', INVESTMENT_URI.'/images/logo.png'); 
            // $logo_light = ot_get_option('logo_light', INVESTMENT_URI.'/images/logo-white.png');

            $logo = $nav_logo; 
            $logo_light = $header_logo;

            ?>
            <a class="site-logo navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                <img class="logo-dark" src="<?php echo esc_url($logo); ?>" width="<?php echo $logo_width ?>" height="<?php echo $logo_height ?>" alt="<?php bloginfo( 'name' ); ?>">
                <img class="logo-light" src="<?php echo esc_url($logo_light); ?>" width="<?php echo $logo_width ?>" height="<?php echo $logo_height ?>" alt="<?php bloginfo( 'name' ); ?>">
            </a>
			<button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
			    <span class="navbar-toggler-icon"></span>
			</button>
			<div class="collapse navbar-collapse gap-20" id="navbarSupportedContent">
                <?php
                   $button = '';
				   if(!empty($buttons)){
					   foreach ($buttons as $key => $value) {
						   $button .= '<li class="topbar-button external my-auto ms-4"><a target="_blank" href="'.$value['button_url'].'" class="caps_normal btn btn-primary">'.esc_attr($value['button_text']).'</a></li>';
					   }
				   }

                    
                    wp_nav_menu( array(
						'menu' => $nav_menu,
                        'theme_location' => 'primary',
                        'container' => false,
                        'menu_class'     => 'navbar-nav menu ms-auto mb-0 navbar-nav-scroll',
                        'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s'.$button.'</ul>',
                        'walker' => new WP_Bootstrap_Navwalker(),
                        'fallback_cb'       => 'WP_Bootstrap_Navwalker::fallback',
                    ));
                ?>
			</div>
	    </nav>
    </div><!-- .container -->	
    <div class="offcanvas offcanvas-search offcanvas-top top-0 px-4" tabindex="-1" id="offcanvassearch" aria-labelledby="offcanvasSearchLabel">

		<button type="button" class="btn-close position-absolute top-50 end-0 pe-100" data-bs-dismiss="offcanvas" aria-label="Close"></button>

		<div class="offcanvas-body container overflow-hidden">
			<form role="search" method="get" id="searchform" class="search-form searchform" action="<?php echo esc_url( home_url( '/' ) ); ?>">
				<input type="search" class="form-control border-0 fs-3"  name="s" id="s" placeholder="<?php echo __( 'Search and enter...', 'bookpress' ); ?>" value="<?php echo get_search_query(); ?>">   
			</form>
		</div>
	</div>
</div><!-- /HEADER	 --> 