
<?php
extract(wp_parse_args( $args, array(
    'title'=> 'Our clients know',
    'subtitle'=> '{Investment Expert} is one of the largest and most experienced global private equity investors',
    'clients'=> array(),
    'content' => ''
)));

  
  $column_class = apply_filters( 'investment/our_clients/column_class', 'col-lg-6' );
?>
  
<div class="our-clients">          
    <div class="row d-flex">
      <div class="<?php echo esc_attr($column_class) ?>">
        <div class="block-content">
          <span class="caps_large underline-primary"><?php echo esc_attr($title) ?></span>
          <h2><?php echo investment_parse_text(esc_attr($subtitle))?></h2>
          <div class="normal"><?php echo do_shortcode($content) ?></div>
        </div>
      </div>
      <?php if(!empty($clients)): ?>
      <div class="<?php echo esc_attr($column_class) ?>">
        <div class="clients clients-carousel">
          <?php foreach ($clients as $key => $value): ?>
              <div class="client-logos">
                <?php if($value['image'] != ''): ?>
                  <img src="<?php echo esc_url($value['image']) ?>" alt="<?php echo esc_attr($value['title']) ?>">
                <?php endif; ?>
                 <?php if($value['image2'] != ''): ?>
                  <img src="<?php echo esc_url($value['image2']) ?>" alt="<?php echo esc_attr($value['title2']) ?>">
                <?php endif; ?>
              </div>
          <?php endforeach; ?>
        </div>
      </div>
      <?php endif; ?>
    </div>         
</div>