<?php

extract(shortcode_atts(array(
	'featured' => false,
    'title' => 'Standard plan',
    'unit' => '$', 
    'price' => '{48}/mo',
    'link_title' => 'Get started now',
    'link' => '#',
	'content' => ''
), $args));
$btnclass = ($featured)? 'btn-primary' : 'btn-secondary';
$titleclass = ($featured)? 'primary-bg' : 'bg-dark';
?>
<div class="pricing-table-wrap">
	<div class="pricing-table">
		<div class="pricing-header text-center">
			<span class="unit"><?php echo esc_attr($unit) ?></span>
			<span class="price"><?php echo investment_parse_text(esc_attr($price), 'strong') ?></span>
			<h3 class="pricing-title lh-1"><span class="<?php echo esc_attr($titleclass) ?>"><?php echo esc_attr($title) ?></span></h3>
		</div>
		<div class="pricing-content">
			<?php echo investment_remove_empty_p(wp_kses_post($content, true)) ?>
		</div>
		<?php if( $link_title != '' ): ?>
		<div class="pricing-footer text-center">
			<a class="btn <?php echo esc_attr($btnclass) ?>" href="<?php echo esc_url($link); ?>" target="_blank"><?php echo esc_attr($link_title) ?></a>
		</div>
		<?php endif; ?>
	</div>
</div>