<?php

extract(shortcode_atts(array(
	'style' => 'style1',
    'type' => 'perch',
    'icon_perch' => 'perch perch-integrity',
    'icon_pixden' => '',
    'icon_linecons' => '',
    'icon_entypo' => '',
    'icon_typicons' => '',
    'icon_openiconic' => '',
    'icon_fontawesome' => '',
    'title' => 'Culture Of Integrity',
    'link_title' => 'Know more',
    'link' => '#',
    'enable_title_link' => '',
    'hide_button' => '',
	'hide_button_icon' => ''
), $args));
$icon = 'icon_'.$type;
$icon_value = (!isset($args[$icon]))? 'perch perch-value' : $args[$icon];
// if($type != 'perch'){
// 	vc_icon_element_fonts_enqueue( $type );
// 	//wp_enqueue_style( 'vc_'.$type );
// }
if(function_exists('vc_icon_element_fonts_enqueue') && $type != 'perch'){
	vc_icon_element_fonts_enqueue( $type );
	wp_enqueue_style( 'vc_'.$type );
}
$figure_block_class = ($style == 'style1')? 'd-grid gap-10' : 'd-flex gap-20 flex-wrap';
$figure_icon_class = ($style == 'style1')? 'd-block' : 'flex-shrink-0';
?>
<div class="square-menu-wrap service-<?php echo esc_attr($style) ?>">
	<div class="square-menu text-white">
		<div class="figure-wrap">
			<figure>
				<div class="figure-block align-items-center <?php echo esc_attr($figure_block_class) ?>">
					<span class="<?php echo esc_attr($figure_icon_class) ?>"><i class="<?php echo esc_attr($icon_value) ?>"></i></span>
					<?php if( $enable_title_link != '' ): ?>
						<h5 class="small"><a href="<?php echo esc_url( $link ) ?>"><?php echo force_balance_tags($title); ?></a></h5>
					<?php else: ?>	
						<h5 class="small"><?php echo force_balance_tags($title); ?></h5>
					<?php endif; ?>
					</div>
				<figcaption>
					<?php if( ($hide_button == '') && ($link_title != '')  ): ?>
					<a href="<?php echo esc_url( $link ) ?>" class="btn btn-sm btn-outline-secondary">
						<?php echo esc_attr($link_title) ?> 
						<?php if( ($hide_button_icon == '')): ?>
						<i class="icon-arrows-slim-right"></i>
						<?php endif; ?>
					</a>
					<?php endif; ?>
				</figcaption>
			</figure>
		</div><!-- .figure-wrap -->
	</div><!-- .square-menu -->
</div>