<?php

extract(shortcode_atts(array(
	'style' => 'style1',
	'bg_class' => 'tra-bg',
   'testimonials' => []
  ), $args));

$dark_calsses_arr = array('primary-bg', 'secondary-bg-dark', 'secondary-light-bg', 'secondary-dark-bg');
$bg_class .= in_array($bg_class, $dark_calsses_arr)? ' has-darkbg-class' : '';
?>
<?php
if( !empty($testimonials) ): 
	if( count($testimonials) > 1 ) echo '<div class="portfolio-testimonial-carousel testimonial-carousel testimonial-carousel-'.esc_attr($style).'">';
	foreach($testimonials as $value): ?>
		<?php if( $style == 'style2' ): ?>
			<div class="testimonial-item testimonial-style2 <?php echo esc_attr($bg_class) ?>">
				<div class="testimonial-content clearfix">
					<?php echo investment_get_svg_icon('quote', 'testimonial-icon'); ?>
					<p class="smaller-italic"><?php echo force_balance_tags(nl2br($value['desc'])) ?></p>
				</div>
				<div class="testimonial clearfix">
					<?php $image = is_array($value['image']) ? $value['image']['url'] : $value['image']; ?>
					<img src="<?php echo esc_url($image) ?>" alt="">
					<div class="content">
						<span class="h_small"><?php echo esc_attr($value['title']) ?></span>
						<p class="smaller-italic"><?php echo esc_attr($value['subtitle']) ?></p>
					</div>
				</div>
			</div>
		<?php else: ?>	
			<div class="d-md-flex gap-4 testimonials testimonial-style1 <?php echo esc_attr($bg_class) ?>">               
	            <div class="testimonials-image-holder flex-shrink-0">
				  <?php $image = is_array($value['image']) ? $value['image']['url'] : $value['image']; ?>
	              <a href="<?php echo esc_url($image) ?>" title="<?php echo esc_attr($value['title']) ?>" class="full-size"><img class="rounded-circle img-fluid" src="<?php echo esc_url($image) ?>" alt=""></a>
	            </div>
	            <div class="content-block">
	              <h4><?php echo esc_attr($value['title']) ?></h4>
	              <p class="caps_small"><?php echo esc_attr($value['subtitle']) ?></p>
	              <p class="small"><?php echo force_balance_tags(nl2br($value['desc'])) ?></p>
	              <?php if(isset($value['signature'])): ?>
					  <?php $signature = is_array($value['signature']) ? $value['signature']['url'] : $value['signature']; ?>
		              <img src="<?php echo esc_url($signature) ?>" alt="">
		          <?php endif; ?>
	            </div>              
	         </div>	
		<?php endif; ?>
	<?php endforeach; ?>
	<?php if( count($testimonials) > 1 ) echo '</div>'; ?>
<?php endif; ?>