<?php

extract(shortcode_atts(array(
    'history' => []
), $args));

if( !empty($history) ):
	$columns1_class = apply_filters( 'investment_timeline/first_column_class', 'col-lg-3 col-sm-3 col-xs-6' );
	$columns2_class = apply_filters( 'investment_timeline/second_column_class', 'col-lg-9 col-sm-9 col-xs-12' );
	?>
	<div class="year_list clearfix">
		<?php foreach ($history as $key => $value): ?>
			<div class="data row"> 
				<div class="<?php echo esc_attr($columns1_class); ?>"> 
				<label class="fw-bold lh-1"><?php echo esc_attr($value['year']) ?></label> <span></span>
				</div>
				<div class="<?php echo esc_attr($columns2_class); ?>">
					<h4><?php echo esc_attr($value['title']) ?></h4> 
					<p><?php echo esc_attr($value['description']) ?></p>
				</div>
			</div>
		<?php endforeach; ?>
	</div>
	<?php 
endif; 
?>