<?php
$footer_copyright_bar = ot_get_option( 'footer_copyright_bar', 'on' );
if( $footer_copyright_bar == 'on' ):
    $copyright_text = ot_get_option( 'copyright_text', '&copy; ' . date( 'Y' ) . ' Investment Expert. All Rights Reserved' );

    $bg_style = ot_get_option( 'copyrightbar_background_style', 'theme-color' );
    $bg_color = ($bg_style == 'custom') ? '' : 'bg-'.ot_get_option( 'copyrightbar_background_color', 'dark' );
    $extra_classes = ot_get_option( 'copyrightbar_extra_class', '' );

    $background = ot_get_option( 'footer_copyright_background');
    $style = ( $bg_style == 'custom' && isset($background['background-image']) && $background['background-image'] != '' )? ' style="background-image: url('.esc_url($background['background-image']).')"' : '';

    $wrapper_classes = [
        'copyright-bar',
        'py-30',
        is_color_dark(ot_get_option( 'copyrightbar_background_color', 'dark' )) ? 'text-white' : 'text-dark',
        $bg_color,
        esc_attr($extra_classes)
    ];
?>
<div class="<?php echo implode(' ', $wrapper_classes) ?>" <?php echo balanceTags($style) ?>>
    <div class="container">
        <div class="row d-md-flex align-items-center gy-15">
            <div class="col-lg-6 col-12 text-center text-lg-start">
                <?php echo wpautop($copyright_text); ?>
            </div>
            <div class="col-lg-6 col-12">
            <?php
                wp_nav_menu( array(
                    'theme_location' => 'footer',
                    'container' => false,
                    'depth' => 1,
                    'menu_class'     => 'copyright-menu list-inline mb-0 d-flex gap-20 align-items-center justify-content-lg-end  justify-content-center',	
                    'fallback_cb'       => 'Investment_Walker_Menu::fallback',
                    'fallback_title' => 'Footer menu settings'
                    ) );
            ?>
            </div>	
        </div>					
    </div>		
</div><!-- .copyright -->
<?php endif; ?>