<?php
$lets_work_area = ot_get_option( 'lets_work_area', 'on' );
if( $lets_work_area == 'on' ):
	$lets_work_bg = ot_get_option( 'lets_work_bg', '' );
	$style = ( $lets_work_bg != '' )? ' style="background-image: url('.esc_url($lets_work_bg).')"' : '';
	$lets_work_title = ot_get_option( 'lets_work_title', 'Make A Difference With {Expert Team}' );
	$lets_work_title = sprintf(_x('%s', 'lets work title in Footer options', 'investment'), $lets_work_title);
	$lets_work_title_font_size = ot_get_option( 'lets_work_title_font_size', 'display-5' );
	$lets_work_title_font_weight = ot_get_option( 'lets_work_title_font_weight', '' );
	$lets_work_button_title = ot_get_option( 'lets_work_button_title', 'Let’s Work Together' );
	$lets_work_button_title = sprintf(_x('%s', 'lets work button title in Footer options', 'investment'), $lets_work_button_title);
	$lets_work_button_link = ot_get_option( 'lets_work_button_link', '#' );

	$title_classes = [
		'mb-0',
		$lets_work_title_font_size,
		$lets_work_title_font_weight
	];
?>
<section class="lets-work bg-dark py-75 text-white"<?php echo balanceTags($style) ?>>
	<div class="container">
		<div class="row d-flex align-items-center gy-3 text-center text-lg-start">
			<div class="col-lg-8">
				<h1 class="<?php echo implode(' ', $title_classes) ?>"><?php echo investment_parse_text($lets_work_title); ?></h1>
			</div>
			<div class="col-lg-4 text-lg-end">							
				<a href="<?php echo esc_url($lets_work_button_link) ?>" class="btn btn-lg btn-primary"><?php echo esc_attr($lets_work_button_title); ?> <i class="icon-arrows-slim-right"></i></a>
			</div>
		</div>
	</div>
</section>
<?php endif; ?>