<?php 
extract(wp_parse_args( $args, array(
    'title_display' => 'on',
    'title' => '',
    'subtitle' => '',
    'breadcrumbs' => '',
    'shortcode' => '',
    'post_id' => NULL,
    'extra_class' => '',
    'classes' => [],
)));

if( $title_display != 'off' ):
    $classes = [
        'banner-section',
        'page-title',
        'bg-dark',
        'text-white',
        $extra_class
    ];
 ?>
<!-- PAGE TITLE	 -->
<div class="<?php echo join(' ', array_filter($classes)) ?>">
	<div class="container">
        <?php if( $title != '' ): ?>
		<h2 class="underline_bold fw-bold fs-1"><?php echo esc_attr($title); ?></h2>
        <?php endif; ?>

        <?php echo ($subtitle != '')? wp_kses_post( $subtitle ) : ''; ?>

        <?php if(function_exists('bcn_display_list') && !is_front_page()): ?>
		<div class="breadcrumbs caps_small" typeof="BreadcrumbList" vocab="http://schema.org/">
			<ul>
				<?php bcn_display_list(); ?>
			</ul>
           <?php endif; ?> 
		</div><!-- .breadcrumbs -->
	</div><!-- .container -->
</div><!-- /PAGE TITLE -->
<?php elseif($title_display == 'off' && $shortcode != ''): ?>
    <?php
    $classes = [
        'slider-wrap',
        'bg-dark',
        'text-white',
        $extra_class
    ];
    ?>
    <div class="<?php echo join(' ', array_filter($classes)) ?>">
    <?php echo do_shortcode($shortcode); ?>
    </div>
<?php endif; ?>
