<!-- HEADER	 -->
<header id="header" <?php investment_header_class() ?>>
	<?php get_template_part( 'template-parts/header/topbar', '' ); ?>
    	
	<?php 
	$classArr = array('navbar', 'navbar-expand-xl', 'hover-menu', 'dropdown-fade-up', 'py-0');
	if( in_array('transparent-header', investment_get_header_class()) ){
		$classArr[] = 'navbar-dark';
		$classArr[] = 'border-bottom';       
	}
    elseif(in_array('secondary-bg-dark', investment_get_header_class())){
        $classArr[] = 'navbar-dark';
    }
    else{
        $classArr[] = 'navbar-light';
    }

    $logo_dim = ot_get_option('logo_dimension', array());

    $logo = ot_get_option('logo', INVESTMENT_URI.'/images/logo.png'); 
    $logo_light = ot_get_option('logo_light', INVESTMENT_URI.'/images/logo-white.png');

    $logo_width = isset($logo_dim['width']) ? $logo_dim['width'] : '';
    $logo_height = isset($logo_dim['height']) ? $logo_dim['height'] : '';

    $logo_dimension = [
        !empty($logo_width)? 'width="'.intval($logo_width).'"' : '',
        !empty($logo_height)? 'height="'.intval($logo_height).'"' : '',
    ];

    $args = array(
        'logo' => $logo,
        'navbar_classes' => $classArr
    );

    $menu_atts = investment_menu_atts($args);

	?>
	
	<div class="container">
        <nav class="<?php echo implode(' ', $classArr) ?>">
            <a class="site-logo navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                <img class="logo-dark" src="<?php echo esc_url($logo); ?>" alt="<?php bloginfo( 'name' ); ?>" <?php echo implode(' ', array_filter($logo_dimension)) ?> />
                <img class="logo-light" src="<?php echo esc_url($logo_light); ?>" alt="<?php bloginfo( 'name' ); ?>"  <?php echo implode(' ', array_filter($logo_dimension)) ?> />
            </a>
			<button class="navbar-toggler" type="button" data-bs-toggle="<?php echo $menu_atts['toggle'] ?>" data-bs-target="#<?php echo $menu_atts['target'] ?>" aria-controls="<?php echo $menu_atts['target'] ?>">
			    <span class="navbar-toggler-icon"></span>
			</button>

                <?php
                    $navbar_text = investment_get_navbar_text();
                    
                    wp_nav_menu( array(
                        'theme_location' => 'primary',
                        'container' => 'div',
                        'container_id'     => $menu_atts['target'],
                        'container_class'     => $menu_atts['container_class'],
                        'menu_class'     => 'navbar-nav menu ms-auto mb-0 navbar-nav-scroll',
                        'items_wrap' => $menu_atts['items_wrap_before'].'<ul id="%1$s" class="%2$s">%3$s</ul>'.$navbar_text. $menu_atts['items_wrap_after'],
                        'walker' => new WP_Bootstrap_Navwalker(),
                        'fallback_cb'       => 'WP_Bootstrap_Navwalker::fallback',
                    ));
                ?>

	    </nav>
    </div><!-- .container -->

    <div class="offcanvas offcanvas-search offcanvas-top top-0 px-4" tabindex="-1" id="offcanvassearch" aria-labelledby="offcanvasSearchLabel">

		<button type="button" class="btn-close position-absolute top-50 end-0 pe-100" data-bs-dismiss="offcanvas" aria-label="Close"></button>

		<div class="offcanvas-body container overflow-hidden">
			<form role="search" method="get" id="searchform" class="search-form searchform" action="<?php echo esc_url( home_url( '/' ) ); ?>">
				<input type="search" class="form-control border-0 fs-3"  name="s" id="s" placeholder="<?php echo __( 'Search and enter...', 'bookpress' ); ?>" value="<?php echo get_search_query(); ?>">   
			</form>
		</div>
	</div>

</header><!-- /HEADER	 --> 
   