<?php  
$terms = get_terms( 'portfolio_category', array(
    'hide_empty' => false,
) );
if( !empty($terms) ):
?>
<div id="category-filter" class="options clearfix">
	<h4 class="pull-left"><?php printf(_x('%s', 'Portfolio title text', 'investment'), ot_get_option('portfolio_title_text', 'Our Sector Knowledge')); ?></h4>
	<ul class="filters">
		<li>
			<a data-filter="all" class="active"><?php printf(_x('%s', 'All text', 'investment'), ot_get_option('portfolio_all_text', 'All')); ?></a>
		</li>
		<?php 
		foreach ($terms as $key => $value) {
			echo '<li>
			<a data-filter="'.esc_attr($value->slug).'">'.esc_attr($value->name).'</a>
		</li>';
		} 
		?>
	</ul><!-- .filters -->		
</div><!-- .options -->
<?php endif; ?>