<div class="d-grid d-md-flex gap-30 pt-30 p-15 bg-light clearfix">
	<?php if(has_post_thumbnail()): ?>
		<div class="flex-shrink-0">
			<img src="<?php the_post_thumbnail_url( 'full' ); ?>" alt="<?php the_title(); ?>">
		</div><!-- .avatar -->
	<?php endif; ?>
	
	<div class="content">
		<h4 class="small-h4 mb-5"><?php the_title(); ?></h4>
		<div class="d-md-flex flex-wrap justify-content-between align-items-center border-bottom pb-10 mb-10">
			<?php 
			$company_subtitle = get_post_meta( get_the_ID(), 'company_subtitle', true ); 
			echo ($company_subtitle != '')? '<p class="caps_normal mb-0"><span>'.esc_attr($company_subtitle).'</span></p>' : '';
			?>
			
			<?php
			$company_social_links_display = get_post_meta( get_the_ID(), 'company_social_links_display', true );
			$company_social_links_display = $company_social_links_display? $company_social_links_display : 'on';
			$company_links = get_post_meta( get_the_ID(), 'company_links', true );
			if( !empty($company_links) && ($company_social_links_display == 'on') ):
				?>
				<ul class="social list-inline d-flex gap-5 ms-auto me-15 mb-0 list-group-horizontal">
					<?php
						foreach ($company_links as $key => $value) {
							echo '<li class="list-inline-item"><a class="text-primary" target="_blank" href="'.esc_url($value['icon_link']['input']).'" title="'.esc_attr($value['title']).'"><i class="fa '.esc_attr($value['icon_link']['icon']).'" aria-hidden="true"></i></a></li>';
						}
					?>
				</ul>
			<?php endif; ?>

			<?php 
			$company_location = get_post_meta( get_the_ID(), 'company_location', true ); 
			$icon_link = get_post_meta( get_the_ID(), 'map_icon_link', true ); 
			echo ($company_location != '')? '<a class="caps_normal ps-20 ps-md-0" target="_blank" href="'.esc_url($icon_link['input']).'"><i class="fa '.esc_attr($icon_link['icon']).'" aria-hidden="true"></i>'.esc_attr($company_location).'</a>' : '';
			?>
		</div>
		
		
		<div class="small"><?php the_content(); ?></div>
	</div><!-- .content -->
</div>