<div class="col item all<?php echo investment_get_the_term_list( get_the_ID(), 'portfolio_category', ' ', ' ', '', false ) ?>">
	<div class="item-inner bg-secondary-light position-relative">
		<?php if(has_post_thumbnail()): ?>
		<img class="background-item" src="<?php the_post_thumbnail_url( 'investment-360x227-crop' ); ?>" alt="<?php the_title(); ?>">
		<?php endif; ?>
		<div class="item-content-wrap position-absolute w-100 px-20 bottom-0">
			<div class="item-content d-grid gap-20">
				<?php
				$corporation_logo = get_post_meta( get_the_ID(), 'company_logo', true ); 
				$corporation_name = get_post_meta( get_the_ID(), 'company_name', true ); 
				

				$link = get_the_permalink();
				$custom_link = get_post_meta( get_the_ID(), 'custom_link', true );
				$link = ( $custom_link != '' )? $custom_link : $link;
				$button_text = sprintf(_x('%s', 'Portfolio read more text', 'investment'), ot_get_option('portfolio_read_more_text', 'Find out more'));
				
				?>
				<div class="d-flex align-items-center">
					<?php if($corporation_logo != ''): ?>
					<img class="logo-item flex-shrink" src="<?php echo esc_url($corporation_logo) ?>" alt="<?php echo esc_attr($corporation_name) ?>">				
					<?php endif; ?>
					<div class="project-title">
						<h3 class="m-0"><a class="link-more" href="<?php echo esc_url($link) ?>"><?php the_title(); ?></a></h3>
						<p class="caps_small mb-0"> <?php echo investment_get_the_term_list( get_the_ID(), 'portfolio_category', '', ', ', '' ) ?></p>		
					</div>	
				</div>	
				<a class="btn-link-more btn btn-sm btn-primary" href="<?php echo esc_attr($link); ?>"><?php echo esc_attr($button_text) ?> <i class="icon-arrows-slim-right"></i></a>
				
			</div>
		</div><!-- .item-content-wrap -->
	</div><!-- .item-inner -->
</div>