<div class="coper-instrumen-quantity bg-light">
	<?php 
	$partner_id = get_post_meta( get_the_ID(), 'related_partner', true ); 
	if( $partner_id != '' ):
		$corporation_name = get_the_title($partner_id);   
		$corporation_subtitle = get_post_meta( $partner_id, 'company_subtitle', true );  
		$corporation_logo = (has_post_thumbnail($partner_id))? get_the_post_thumbnail( $partner_id, 'full' ) : '';

		echo ($corporation_logo != '')? '<div class="corporation-logo mb-30">'.$corporation_logo.'</div>' : '';
		echo ($corporation_name != '')? '<h4>'.esc_attr($corporation_name).'</h4>' : '';
		echo ($corporation_subtitle != '')? '<span class="caps_small">'.wp_kses_post($corporation_subtitle).'</span>' : '';
		?>

		<?php
		$corporation_links = get_post_meta( $partner_id, 'company_links', true );
		$map_icon_link = get_post_meta( $partner_id, 'map_icon_link', true );
		$corporation_links[] = array(
	                            'title' => get_post_meta( $partner_id, 'company_location', true ),
	                            'icon_link' => $map_icon_link
	                        );
		$company_social_links_display = get_post_meta( $partner_id, 'company_social_links_display', true );
		$company_social_links_display = $company_social_links_display? $company_social_links_display : 'on';
		if( !empty($corporation_links) && ($company_social_links_display == 'on') ): ?>
			<ul class="list-inline">
				<?php 
				foreach ($corporation_links as $key => $value) {
					echo '<li class="list-inline-item"><a target="_blank" href="'.esc_attr($value['icon_link']['input']).'" title="'.esc_attr($value['title']).'"><i class="fa '.esc_attr($value['icon_link']['icon']).'"></i></a></li>';
				} 
				?>
			</ul>
		<?php endif; ?>	
	<?php endif; ?>

	<?php
	$portfolio_info = get_post_meta( get_the_ID(), 'portfolio_info', true );
	if( !empty($portfolio_info) ): ?>
		<ul class="quantity list-unstyled d-grid">
			<?php 
			foreach ($portfolio_info as $key => $value) {
				echo '<li class="d-flex justify-content-between"><span class="text-dark">'.esc_attr($value['title']).'</span><span class="text-muted">'.esc_attr($value['desc']).'</span></li>';
			} 
			?>
		</ul>
	<?php endif; ?>			
</div>