<?php
extract($args);
$info = extract($info);
$portfolio = new WP_Query( $query_args );
$css_classes = [
	'portfolio-wrapper',
	'bg-secondary',
	'text-white'
];

$css_classes[] = !empty($disable_more_button) && ($disable_more_button == 'yes')? 'disable-more-link-btn' : '';
$css_classes[] = !empty($disable_more_link) && ($disable_more_link == 'yes')? 'disable-more-link' : '';
?>
<div class="<?php echo implode(' ', array_filter($css_classes)) ?>">
<?php if ( $portfolio->have_posts() ):   ?>
	
	<?php 	
	$args = array(
	    'hide_empty' => false,
	);
	if($portfolio_tax_term != '') $args['include'] = $portfolio_tax_term;

	$terms = get_terms( 'portfolio_category', $args );
	if( !empty($terms) ):
		
	?>
	<div class="options bg-secondary-light d-lg-flex align-items-center clearfix" data-active="<?php echo esc_attr($active) ?>">
			<?php if( $title_display == 'yes' ): ?>
				<h2 class="text-white mb-0"><?php echo esc_attr($title) ?></h2>
			<?php endif; ?>	
			<div class="ms-lg-auto me-lg-0 ms-auto me-auto">
				<ul id="category-filter" class="filters mb-0">
					<li>
						<a data-filter="all" class="<?php echo ($active != '')? '' : 'active' ?>"><?php printf(_x('%s', 'All text', 'investment'), ot_get_option('portfolio_all_text', 'All')); ?></a>
					</li>
					<?php 
					foreach ($terms as $key => $value) {
						echo '<li>
						<a data-filter="'.esc_attr($value->slug).'" class="'.(($value->slug == $active)? 'active' : '').'">'.esc_attr($value->name).'</a>
					</li>';
					} 
					?>
			</ul><!-- .filters -->		
		</div>
	</div><!-- .options -->
	<?php endif; ?>
	<!--   PORTFOLIO  -->
	<div class="portfolio portfolio-template">
	

			
		<div class="portfolio-isotope row row-cols-1 row-cols-md-2 row-cols-lg-3 g-1">
			<?php
			if( !empty($terms) ):
				foreach ($terms as $key => $value) :
					$link = get_term_link($value, 'portfolio_category');
					$customlink = get_term_meta( $value->term_id, 'custom-link', true );
					$link = ( $customlink != '' )? $customlink : $link;
				?>
				<div class="col item secondary-bg-dark info-block <?php echo esc_attr($value->slug) ?>" data-items="<?php echo esc_attr($value->slug) ?>">		
					<div class="info-block-inner h-100">
						<h4 class="underline-primary pt-0"><?php echo esc_attr($value->name) ?></h4>
						<p class="small desc"><?php echo wp_trim_words($value->description, 40, '') ?></p>
						<a class="btn-link-more btn btn-sm btn-outline-primary" href="<?php echo esc_url($link); ?>"><?php echo esc_attr($read_more) ?> <i class="icon-arrows-slim-right"></i></a>
					</div>
				</div>
				<?php 
				endforeach;
			endif; 
			?>

			<?php
			while ( $portfolio->have_posts() ) :
				$portfolio->the_post();
				get_template_part( 'template-parts/portfolio/content', '' );
			endwhile; ?>			
		</div>
	</div>

	<!--   /PORTFOLIO  -->
		<?php
	
	// Posts not found
	else :
		echo '<div class="container my-3"><div class="alert alert-warning"  role="alert">' . __( 'Portfolio not found', 'investment' ) . '</div></div>';
	endif;

	wp_reset_postdata();
?>
</div>