<?php
$portfolio_testimonials = get_post_meta( get_the_ID(), 'portfolio_testimonials', true );
if( !empty($portfolio_testimonials) ): 
	if( count($portfolio_testimonials) > 1 ) echo '<div class="portfolio-testimonial-carousel">';
	foreach($portfolio_testimonials as $value): ?>
		<div class="testimonial-item">
			<div class="testimonial-content clearfix">
				<?php echo investment_get_svg_icon('quote', 'testimonial-icon'); ?>
				<p class="smaller-italic"><?php echo force_balance_tags(nl2br($value['desc'])) ?></p>
			</div>
			<div class="testimonial clearfix">
				<img src="<?php echo esc_url($value['image']) ?>" alt="">
				<div class="content">
					<span class="h_small"><?php echo esc_attr($value['title']) ?></span>
					<p class="smaller-italic"><?php echo esc_attr($value['subtitle']) ?></p>
				</div>
			</div>
		</div>
	<?php endforeach; ?>
	<?php if( count($portfolio_testimonials) > 1 ) echo '</div>'; ?>
<?php endif; ?>