<?php 
$surname = get_post_meta( get_the_ID(), 'surname', true );
$surname = ( $surname != '' )? '<br>'.$surname : '';
?>
<div class="col">
	<div class="single-team-member bg-light">
		<?php if( has_post_thumbnail() ): ?>
		<div class="team-member-photo">
			<img src="<?php the_post_thumbnail_url( 'investment-600x600-crop' ); ?>" alt="<?php the_title(); ?>">	
			<?php
			$button_text = sprintf(_x('%s', 'Team read more text', 'investment'), ot_get_option('team_read_more_text', 'Know more'));
			?>
			<a class="view-full-size" href="<?php the_permalink(); ?>"><span><?php echo esc_attr($button_text) ?></span></a>
		</div>
		<?php endif; ?>
		<div class="team-member-details">
			<a href="<?php the_permalink(); ?>"><h4><?php the_title(); ?><?php echo $surname; ?></h4></a>

			<?php 
			$designation = get_post_meta( get_the_ID(), 'designation', true ); 
			if($designation != ''): ?>
			<a href="<?php the_permalink(); ?>"><span class="caps_small"><?php echo esc_attr($designation) ?></span></a>
			<?php endif; ?>
			<p><?php echo get_the_excerpt(); ?></p>
		</div>
	</div><!-- .single-team-member -->		
</div>