
<?php if ( $posts->have_posts() ):  
	$info = $posts->info;  extract($info);
	$team_link_text = !empty($info['team_link_text'])? $info['team_link_text'] : esc_attr__( 'Know more', 'investment' );  
	$posts_wrap_column = ( $title_display == 'yes' )? 'col-lg-8' : 'col-lg-12';
	if(isset($info['link_type']) && $info['link_type'] == 'custom_link'){
		$button_link = $info['button_link'];
	}else{
		$button_link = get_post_type_archive_link( 'team' );
	}

	$css_classes = [
		'experienced-team'
	];
	
	$css_classes[] = !empty($disable_more_button) && ($disable_more_button == 'yes')? 'disable-more-link-btn' : '';
	$css_classes[] = !empty($disable_more_link) && ($disable_more_link == 'yes')? 'disable-more-link' : '';
	?>
	<div class="<?php echo implode(' ', array_filter($css_classes)) ?>">
	<div class="row"> 

		<?php if( $title_display == 'yes' ): ?>  
		<div class="col-lg-4">
			<div class="block-content">
				<h2 class="underline-primary"><?php echo investment_parse_text(esc_attr($info['title'])) ?></h2>
				<p class="normal"><?php echo esc_attr($info['desc']) ?></p>
				<?php if($info['button_link_text'] != ''): ?>
				<a class="btn btn-outline-primary" href="<?php echo esc_url($button_link) ?>"><?php echo esc_attr($info['button_link_text']) ?> <i class="icon-arrows-slim-right"></i></a>
				<?php endif; ?>
			</div>
		</div>
		<?php endif; ?>

		<div class="<?php echo esc_attr($posts_wrap_column) ?>">
			<div class="team-carousel owl-carousel" data-column="<?php echo intval($info['column']) ?>" data-margin="30">			               
			<?php 
				// Posts are found
				$count = 1;
				while ( $posts->have_posts() ) :
					$posts->the_post();
					global $post;
					$surname = get_post_meta( get_the_ID(), 'surname', true );
					$surname = ( $surname != '' )? '<br>'.$surname : '';
					?>					
						<div class="single-team-member bg_gray">
							<div class="team-member-photo">
								<img src="<?php the_post_thumbnail_url( 'investment-600x600-crop' ); ?>" alt="<?php the_title(); ?>">	
								<?php
								$button_text = sprintf(_x('%s', 'Team read more text', 'investment'), ot_get_option('team_read_more_text', 'Know more'));
								?>
								<a class="view-full-size btn-link-more" href="<?php the_permalink(); ?>"><span><?php echo esc_attr($button_text) ?></span></a>
							</div>
							<div class="team-member-details">
								<a class="link-more" href="<?php the_permalink(); ?>"><h4><?php the_title(); ?><?php echo $surname; ?></h4></a>

								<?php 
								$designation = get_post_meta( get_the_ID(), 'designation', true ); 
								if($designation != ''): ?>
								<a href="<?php the_permalink(); ?>" class="link-more"><span class="caps_small"><?php echo esc_attr($designation) ?></span></a>
								<?php endif; ?>
							</div>
						</div><!-- .single-team-member -->					
					<?php	
							
				endwhile;
				?>
			</div>		
		</div>
	</div> 
	</div>
		<?php
	
	// Posts not found
	else :
		echo '<div class="container my-3"><div class="alert alert-warning"  role="alert">' . __( 'Team member not found', 'investment' ) . '</div></div>';
	endif;
?>

