<div class="team-single-item bg-light">
  <div class="row">
      <?php if( has_post_thumbnail() ): ?> 
        <div class="col-lg-6">
          <img class="team-single-item-photo" src="<?php the_post_thumbnail_url( 'investment-900x700-crop' ); ?>" alt="<?php the_title() ?>">
        </div><!-- .col-lg-7 -->
      <?php endif; ?>

      <div class="col-lg-6">
        <div class="team-member-contact-info">

          
          <?php the_title(investment_team_title_before(), investment_team_title_after()); ?>

          <?php
          $designation = get_post_meta( get_the_ID(), 'designation', true );
          echo ( $designation != '' )? '<span class="caps_small">'.esc_attr($designation).'</span>' : '';
          ?>
          
          <?php
          $member_info = get_post_meta( get_the_ID(), 'member_info', true );
          if( !empty($member_info) ):
            ?>
            <ul class="contact-info">
              <?php 
              foreach ($member_info as $key => $value) {
                $linkable = isset($value['linkable'])? $value['linkable'] : 'on';
                $link = isset($value['link'])? esc_attr($value['link']) : '#';
                if( $linkable == 'on' ){
                  echo '<li><a href="'.$link.'" target="_blank" title="'.esc_attr($value['title']).'"><i class="fa '.esc_attr($value['icon_desc']['icon']).'"></i><span>'.esc_attr($value['icon_desc']['input']).'</span></a></li>';
                }else{
                    echo '<li><i class="fa '.esc_attr($value['icon_desc']['icon']).'"></i><span>'.esc_attr($value['icon_desc']['input']).'</span></li>';
                }
              
              }
              ?>
              </li>
            </ul>
          <?php endif; ?>
          <?php
          $social_links = get_post_meta( get_the_ID(), 'social_links', true );
          $social_links_display = get_post_meta( get_the_ID(), 'member_social_links_display', true );
          if( !empty($social_links) && ($social_links_display != 'off') ):
            ?>
            <ul class="list-group list-group-horizontal list-inline social-link">
              <?php 
              foreach ($social_links as $key => $value) {
                echo '<li class"list-group-item"><a target="_blank" href="'.esc_url($value['icon_link']['input']).'" title="'.esc_attr($value['title']).'"><i class="fa '.esc_attr($value['icon_link']['icon']).'"></i></a></li>';
              }
              ?>
            </ul>
          <?php endif; ?>
        </div><!-- .team-member-contact-info -->
      </div><!-- .col-lg-5 -->
  </div> 
</div> 