<?php 
$member_help_display = get_post_meta( get_the_ID(), 'member_help_display', true );
if( $member_help_display == 'on' ):
	$member_help_title = get_post_meta( get_the_ID(), 'member_help_title', true );
	$member_help_subtitle = get_post_meta( get_the_ID(), 'member_help_subtitle', true );
?>
	<div class="help-center">
		<h4><?php echo esc_attr($member_help_title) ?></h4>
		<p class="normal"><?php echo esc_attr($member_help_subtitle) ?></p>
	</div>
<?php endif; ?>

<?php 
$member_contact_form = get_post_meta( get_the_ID(), 'member_contact_form', true );
if( $member_contact_form != '' ):
	$contact_form_title = get_post_meta( get_the_ID(), 'contact_form_title', true );
	$contact_form_subtitle = get_post_meta( get_the_ID(), 'contact_form_subtitle', true );
	$member_contact_form = get_post_meta( get_the_ID(), 'member_contact_form', true );
?>
	<div class="team-contact-form bg-light">
		<h4><?php echo esc_attr(str_replace('{member_name}', get_the_title(), $contact_form_title)) ?></h4>
		<p class="small"><?php echo esc_attr($contact_form_subtitle) ?></p>	
		<?php echo do_shortcode('[contact-form-7 id="'.intval($member_contact_form).'"]'); ?>							
	</div>
<?php endif; ?>