<?php 
$ids = get_post_meta( get_the_ID(), 'ids', true );
if( !empty($ids) ):
	$query = new WP_Query( array( 'ignore_sticky_posts' => 'true', 'post__in' => $ids ) );
	if ( $query->have_posts() ) :
		$display_posts = get_post_meta( get_the_ID(), 'display_posts', true );
		$member_posts_title = get_post_meta( get_the_ID(), 'member_posts_title', true );
		?>
		<div class="insides">
			<div class="row">
				<div class="col-lg-12">
					<h4><?php echo esc_attr($member_posts_title); ?></h4>
				</div>
				<?php while ( $query->have_posts() ) : $query->the_post(); ?>
					<div class="col-lg-4">
						<p class="normal"><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></p>
						<span class="caps_small"><i class="primary-color perch-Keyboard"></i><?php echo get_the_date(); ?></span>
					</div><!-- .col-lg-4 -->
				<?php endwhile; ?>
				<?php wp_reset_postdata(); ?>
			</div><!-- .row -->
		</div>
	<?php endif; ?>	
<?php endif; ?>