<div class="news">
<?php if ( $posts->have_posts() ):  
	$info = $posts->info;  //print_r($info);
	$title_display = $info['title_display'];
	$posts_wrap_column = ( $title_display == 'yes' )? 'col-lg-8' : 'col-lg-12';
	?>
	<div class="row"> 

		<?php if( $title_display == 'yes' ): ?>  
		<div class="col-lg-4">
			<div class="content-block">
				<h2 class="underline-primary"><?php echo investment_parse_text(esc_attr($info['title'])) ?></h2>
				<p class="normal"><?php echo esc_attr($info['desc']) ?></p>
				<?php if($info['button_link_text'] != ''): ?>
				<a class="btn btn-outline-primary" href="<?php echo get_permalink( get_option( 'page_for_posts' ) ) ?>"><?php echo esc_attr($info['button_link_text']) ?> <i class="icon-arrows-slim-right"></i></a>
				<?php endif; ?>
			</div>
		</div>
		<?php endif; ?>

		<div class="<?php echo esc_attr($posts_wrap_column) ?>">
			<div class="blog-carousel owl-carousel" data-column="<?php echo intval($info['column']) ?>">			               
			<?php 
				// Posts are found
				$count = 1;
				while ( $posts->have_posts() ) :
					$posts->the_post();
					global $post;					
					?>
					
						<div class="post clearfix">
							<?php if(has_post_thumbnail()): ?>
								<div class="post-image-holder">
									<?php if( isset($info['image_link_type']) && ($info['image_link_type'] == 'popup') ): ?>
										<a href="<?php the_post_thumbnail_url( 'full' ); ?>" title="<?php the_title(); ?>" class="full-size"><img src="<?php the_post_thumbnail_url( 'investment-500x340-crop' ); ?>" alt="<?php the_title(); ?>"></a>
									<?php else: ?>
										<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><img src="<?php the_post_thumbnail_url( 'investment-500x340-crop' ); ?>" alt="<?php the_title(); ?>"></a>
									<?php endif; ?>
								</div>								
							<?php endif; ?>
							 
							<p class="caps_normal"><?php the_time('F d, Y') ?></p>
							<h4><?php the_title(); ?></h4>
							<a class="btn btn-xs btn-secondary" href="<?php the_permalink(); ?>"><?php echo esc_attr( $info['read_more'] ) ?></a>
						</div>
					
					<?php	
					
					$count++;			
				endwhile;
				?>
			</div>		
		</div>
	</div> 
		<?php
	
	// Posts not found
	else :
		echo '<h4>' . __( 'Posts not found', 'investment' ) . '</h4>';
	endif;
?>
</div>
