<div class="news">
<?php if ( $posts->have_posts() ):  
	$info = $posts->info;  //print_r($info);
	$title_display = $info['title_display'];
	$posts_wrap_column = ( $title_display == 'yes' )? 'col-lg-8' : 'col-lg-12';
	?>
	<div class="row"> 

		<?php if( $title_display == 'yes' ): ?>  
		<div class="col-lg-4">
			<div class="content-block">
				<h2 class="underline-primary"><?php echo investment_parse_text(esc_attr($info['title'])) ?></h2>
				<p class="normal"><?php echo esc_attr($info['desc']) ?></p>
				<?php if($info['button_link_text'] != ''): ?>
				<a class="btn btn-outline-primary" href="<?php echo get_permalink( get_option( 'page_for_posts' ) ) ?>"><?php echo esc_attr($info['button_link_text']) ?> <i class="icon-arrows-slim-right"></i></a>
				<?php endif; ?>
			</div>
		</div>
		<?php endif; ?>

		<div class="<?php echo esc_attr($posts_wrap_column) ?>">
			<div class="portfolio portfolio-template darkBG">
				<?php 
				extract($info);
				$read_more = ot_get_option( 'read_more_text', 'Read More' );
				$args = array(
				    'hide_empty' => true,
				);
				if($tax_term != '') $args['include'] = $tax_term;

				$terms = get_terms( 'category', $args );
				if( !empty($terms) ):
					$active = '';
					
				?>
				<div class="options clearfix" data-active="<?php echo esc_attr($active) ?>">
						<?php if( $title_display == 'yes' ): ?>
							<h2 class="pull-left"><?php echo esc_attr($title) ?></h2>
						<?php endif; ?>	
						<ul id="category-filter" class="filters">
						<li>
							<a data-filter="all" class="<?php echo ($active != '')? '' : 'active' ?>"><?php printf(_x('%s', 'All text', 'investment'), ot_get_option('portfolio_all_text', 'All')); ?></a>
						</li>
						<?php 
						foreach ($terms as $key => $value) {
							echo '<li>
								<a data-filter="'.esc_attr($value->slug).'" class="'.(($value->slug == $active)? 'active' : '').'">'.esc_attr($value->name).'</a>
							</li>';
						} 
						?>
					</ul><!-- .filters -->		
				</div><!-- .options -->
				<?php endif; ?>

						
				<div class="isotope">
					<?php
					if( !empty($terms) ):
						foreach ($terms as $key => $value) :
							$link = get_term_link($value, 'category');							
						?>
						<div class="item info-block <?php echo esc_attr($value->slug) ?>">		
							<div class="secondary-bg-dark info-block-inner h-100">
								<h4 class="underline-primary"><?php echo esc_attr($value->name) ?></h4>
								<p class="smaller"><?php echo wp_trim_words($value->description, 40, '') ?></p>
								<a class="btn btn-outline-primary" href="<?php echo esc_url($link); ?>"><?php echo esc_attr($read_more) ?> <i class="icon-arrows-slim-right"></i></a>
							</div>
						</div>
						<?php 
						endforeach;
					endif; 
					?>

					<?php
					while ( $posts->have_posts() ) :
						$posts->the_post();
						get_template_part( 'templates/content', '' );
					endwhile; ?>			
				</div><!-- .isotope -->
			</div><!--   /PORTFOLIO  -->	
		</div>
	</div> 
		<?php
	
	// Posts not found
	else :
		echo '<h4>' . __( 'Posts not found', 'investment' ) . '</h4>';
	endif;
?>
</div>
