<?php
if ( ! function_exists('investment_portfolio_post_type') ) {

// Register Custom Post Type
function investment_portfolio_post_type() {
	if(get_post_status(get_option('portfolio_archive_id')) == 'publish'){
		$mypost = get_post(get_option('portfolio_archive_id')); 
		$title = $mypost->post_title;
	}else{
		$title = _x( 'Portfolios', 'Post Type General Name', 'investment' );
	}
	$labels = array(
		'name'                  => esc_attr($title),
		'singular_name'         => _x( 'Portfolio', 'Post Type Singular Name', 'investment' ),
		'menu_name'             => __( 'Portfolio', 'investment' ),
		'name_admin_bar'        => __( 'Portfolio', 'investment' ),
		'archives'              => __( 'Portfolio Archives', 'investment' ),
		'parent_item_colon'     => __( 'Parent Portfolio:', 'investment' ),
		'all_items'             => __( 'All Portfolio Items', 'investment' ),
		'add_new_item'          => __( 'Add New Portfolio', 'investment' ),
		'add_new'               => __( 'Add New', 'investment' ),
		'new_item'              => __( 'New Portfolio', 'investment' ),
		'edit_item'             => __( 'Edit Portfolio', 'investment' ),
		'update_item'           => __( 'Update Portfolio', 'investment' ),
		'view_item'             => __( 'View Portfolio', 'investment' ),
		'search_items'          => __( 'Search Portfolio', 'investment' ),
		'not_found'             => __( 'Not found', 'investment' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'investment' ),
		'featured_image'        => __( 'Featured Image', 'investment' ),
		'set_featured_image'    => __( 'Set featured image', 'investment' ),
		'remove_featured_image' => __( 'Remove featured image', 'investment' ),
		'use_featured_image'    => __( 'Use as featured image', 'investment' ),
		'insert_into_item'      => __( 'Insert into Portfolio', 'investment' ),
		'uploaded_to_this_item' => __( 'Uploaded to this Portfolio', 'investment' ),
		'items_list'            => __( 'Portfolio list', 'investment' ),
		'items_list_navigation' => __( 'Portfolio list navigation', 'investment' ),
		'filter_items_list'     => __( 'Filter Portfolio list', 'investment' ),
	);
	$args = array(
		'label'                 => __( 'Portfolio', 'investment' ),
		'description'           => __( 'Post Type Description', 'investment' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'thumbnail' ),
		'taxonomies'            => array( 'portfolio_category', 'tag' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,		
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',		
	);

	if(get_post_status(get_option('portfolio_archive_id')) == 'publish'){
		$mypost = get_post(get_option('portfolio_archive_id')); 
		$slug = $mypost->post_name;
		$args['rewrite'] = array('slug' => $slug,'with_front' => false);
	}

	if( !in_array('portfolio', investment_disable_post_type_arr()) ){
		register_post_type( 'portfolio', $args );
	}
	

}
add_action( 'init', 'investment_portfolio_post_type', 0 );

}



if ( ! function_exists( 'investment_portfolio_category_taxonomy' ) ) {

// Register Custom Taxonomy
function investment_portfolio_category_taxonomy() {

	$labels = array(
		'name'                       => _x( 'Portfolio Categories', 'Taxonomy General Name', 'investment' ),
		'singular_name'              => _x( 'Category', 'Taxonomy Singular Name', 'investment' ),
		'menu_name'                  => __( 'Portfolio Category', 'investment' ),
		'all_items'                  => __( 'All Categories', 'investment' ),
		'parent_item'                => __( 'Parent Category', 'investment' ),
		'parent_item_colon'          => __( 'Parent Category:', 'investment' ),
		'new_item_name'              => __( 'New Category Name', 'investment' ),
		'add_new_item'               => __( 'Add New Category', 'investment' ),
		'edit_item'                  => __( 'Edit Category', 'investment' ),
		'update_item'                => __( 'Update Category', 'investment' ),
		'view_item'                  => __( 'View Category', 'investment' ),
		'separate_items_with_commas' => __( 'Separate Categories with commas', 'investment' ),
		'add_or_remove_items'        => __( 'Add or remove Categories', 'investment' ),
		'choose_from_most_used'      => __( 'Choose from the most used', 'investment' ),
		'popular_items'              => __( 'Popular Categories', 'investment' ),
		'search_items'               => __( 'Search Items', 'investment' ),
		'not_found'                  => __( 'Not Found', 'investment' ),
		'no_terms'                   => __( 'No Categories', 'investment' ),
		'items_list'                 => __( 'Categories list', 'investment' ),
		'items_list_navigation'      => __( 'Categories list navigation', 'investment' ),
	);
	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => true,
		'public'                     => true,
		'show_ui'                    => true,
		'show_admin_column'          => true,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => false,
		'rewrite'           => array( 'slug' => apply_filters('investment_portfolio_category_slug', 'portfolio_category') ),
	);
	register_taxonomy( 'portfolio_category', array( 'portfolio' ), $args );

}
add_action( 'init', 'investment_portfolio_category_taxonomy', 0 );

}



if ( ! function_exists( 'investment_portfolio_skill_taxonomy' ) ) {

// Register Custom Taxonomy
function investment_portfolio_skill_taxonomy() {


	$labels = array(
		'name'                       => _x( 'Portfolio Tags', 'Taxonomy General Name', 'investment' ),
		'singular_name'              => _x( 'Portfolio Tag', 'Taxonomy Singular Name', 'investment' ),
		'menu_name'                  => __( 'Tag', 'investment' ),
		'all_items'                  => __( 'All Tags', 'investment' ),
		'parent_item'                => __( 'Parent Tag', 'investment' ),
		'parent_item_colon'          => __( 'Parent Tag:', 'investment' ),
		'new_item_name'              => __( 'New Tag Name', 'investment' ),
		'add_new_item'               => __( 'Add New Tag', 'investment' ),
		'edit_item'                  => __( 'Edit Tag', 'investment' ),
		'update_item'                => __( 'Update Tag', 'investment' ),
		'view_item'                  => __( 'View Tag', 'investment' ),
		'separate_items_with_commas' => __( 'Separate Tags with commas', 'investment' ),
		'add_or_remove_items'        => __( 'Add or remove Tags', 'investment' ),
		'choose_from_most_used'      => __( 'Choose from the most used', 'investment' ),
		'popular_items'              => __( 'Popular Tags', 'investment' ),
		'search_items'               => __( 'Search Tags', 'investment' ),
		'not_found'                  => __( 'Not Found', 'investment' ),
		'no_terms'                   => __( 'No Tags', 'investment' ),
		'items_list'                 => __( 'Tags list', 'investment' ),
		'items_list_navigation'      => __( 'Tags list navigation', 'investment' ),
	);
	$args = array(
		'hierarchical' => false,
	    'labels' => $labels,
	    'show_ui' => true,
	    'update_count_callback' => '_update_post_term_count',
	    'query_var' => true,
	    'rewrite' => array( 'slug' => apply_filters( 'investment_portfolio_tag_slug', 'ptag') ),
	);
	
	register_taxonomy( 'portfolio_tag', array( 'portfolio' ), $args );

}
add_action( 'init', 'investment_portfolio_skill_taxonomy', 0 );

}

if ( ! function_exists('investment_partner_post_type') ) {

// Register Custom Post Type
function investment_partner_post_type() {

	if(get_post_status(get_option('partner_archive_id')) == 'publish'){
		$mypost = get_post(get_option('partner_archive_id')); 
		$title = $mypost->post_title;
	}else{
		$title = _x( 'Partners', 'Post Type General Name', 'investment' );
	}
	
	$labels = array(
		'name'                  => esc_attr($title),
		'singular_name'         => _x( 'Partner', 'Post Type Singular Name', 'investment' ),
		'menu_name'             => __( 'Partner', 'investment' ),
		'name_admin_bar'        => __( 'Partner', 'investment' ),
		'archives'              => __( 'Partner Archives', 'investment' ),
		'parent_item_colon'     => __( 'Parent Partner:', 'investment' ),
		'all_items'             => __( 'All Partners', 'investment' ),
		'add_new_item'          => __( 'Add New Partner', 'investment' ),
		'add_new'               => __( 'Add New', 'investment' ),
		'new_item'              => __( 'New Partner', 'investment' ),
		'edit_item'             => __( 'Edit Partner', 'investment' ),
		'update_item'           => __( 'Update Partner', 'investment' ),
		'view_item'             => __( 'View Partner', 'investment' ),
		'search_items'          => __( 'Search Partner', 'investment' ),
		'not_found'             => __( 'Not found', 'investment' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'investment' ),
		'featured_image'        => __( 'Featured Image', 'investment' ),
		'set_featured_image'    => __( 'Set featured image', 'investment' ),
		'remove_featured_image' => __( 'Remove featured image', 'investment' ),
		'use_featured_image'    => __( 'Use as featured image', 'investment' ),
		'insert_into_item'      => __( 'Insert into Partner', 'investment' ),
		'uploaded_to_this_item' => __( 'Uploaded to this Partner', 'investment' ),
		'items_list'            => __( 'Partner list', 'investment' ),
		'items_list_navigation' => __( 'Partner list navigation', 'investment' ),
		'filter_items_list'     => __( 'Filter Partner list', 'investment' ),
	);
	$args = array(
		'label'                 => __( 'Partner', 'investment' ),
		'description'           => __( 'Post Type Description', 'investment' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'thumbnail', 'page-attributes' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => 'edit.php?post_type=portfolio',
		'menu_position'         => 5,
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,		
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
	);

	if(get_post_status(get_option('partner_archive_id')) == 'publish'){
		$mypost = get_post(get_option('partner_archive_id')); 
		$slug = $mypost->post_name;
		$args['rewrite'] = array('slug' => $slug,'with_front' => false);
	}

	if( !in_array('partner', investment_disable_post_type_arr()) ){
		register_post_type( 'partner', $args );
	}

}
add_action( 'init', 'investment_partner_post_type', 0 );

}

if ( ! function_exists('investment_team_post_type') ) {

// Register Custom Post Type
function investment_team_post_type() {

	if(get_post_status(get_option('team_archive_id')) == 'publish'){
		$mypost = get_post(get_option('team_archive_id')); 
		$title = $mypost->post_title;
	}else{
		$title = _x( 'Teams', 'Post Type General Name', 'investment' );
	}

	$labels = array(
		'name'                  => esc_attr($title),
		'singular_name'         => _x( 'Team', 'Post Type Singular Name', 'investment' ),
		'menu_name'             => __( 'Team', 'investment' ),
		'name_admin_bar'        => __( 'Team', 'investment' ),
		'archives'              => __( 'Team Archives', 'investment' ),
		'parent_item_colon'     => __( 'Parent Team:', 'investment' ),
		'all_items'             => __( 'All Team', 'investment' ),
		'add_new_item'          => __( 'Add New Team', 'investment' ),
		'add_new'               => __( 'Add New', 'investment' ),
		'new_item'              => __( 'New Team', 'investment' ),
		'edit_item'             => __( 'Edit Team', 'investment' ),
		'update_item'           => __( 'Update Team', 'investment' ),
		'view_item'             => __( 'View Team', 'investment' ),
		'search_items'          => __( 'Search Team', 'investment' ),
		'not_found'             => __( 'Not found', 'investment' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'investment' ),
		'featured_image'        => __( 'Featured Image', 'investment' ),
		'set_featured_image'    => __( 'Set featured image', 'investment' ),
		'remove_featured_image' => __( 'Remove featured image', 'investment' ),
		'use_featured_image'    => __( 'Use as featured image', 'investment' ),
		'insert_into_item'      => __( 'Insert into Team', 'investment' ),
		'uploaded_to_this_item' => __( 'Uploaded to this Team', 'investment' ),
		'items_list'            => __( 'Team list', 'investment' ),
		'items_list_navigation' => __( 'Team list navigation', 'investment' ),
		'filter_items_list'     => __( 'Filter Team list', 'investment' ),
	);
	$args = array(
		'label'                 => __( 'Team', 'investment' ),
		'description'           => __( 'Post Type Description', 'investment' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'thumbnail', 'page-attributes', 'excerpt' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 6,
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,		
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
	);

	if(get_post_status(get_option('team_archive_id')) == 'publish'){
		$mypost = get_post(get_option('team_archive_id')); 
		$slug = $mypost->post_name;
		$args['rewrite'] = array('slug' => $slug,'with_front' => false);
	}

	if( !in_array('team', investment_disable_post_type_arr()) ){
		register_post_type( 'team', $args );
	}

}
add_action( 'init', 'investment_team_post_type', 0 );

}

if ( ! function_exists('investment_service_post_type') ) {

// Register Custom Post Type
function investment_service_post_type() {

	if(get_post_status(get_option('service_archive_id')) == 'publish'){
		$mypost = get_post(get_option('service_archive_id')); 
		$title = $mypost->post_title;
	}else{
		$title = _x( 'Services', 'Post Type General Name', 'investment' );
	}

	$labels = array(
		'name'                  => esc_attr($title),
		'singular_name'         => _x( 'Service', 'Post Type Singular Name', 'investment' ),
		'menu_name'             => __( 'Services', 'investment' ),
		'name_admin_bar'        => __( 'Service', 'investment' ),
		'archives'              => __( 'Service Archives', 'investment' ),
		'parent_item_colon'     => __( 'Parent Service:', 'investment' ),
		'all_items'             => __( 'All Services', 'investment' ),
		'add_new_item'          => __( 'Add New Service', 'investment' ),
		'add_new'               => __( 'Add New', 'investment' ),
		'new_item'              => __( 'New Service', 'investment' ),
		'edit_item'             => __( 'Edit Service', 'investment' ),
		'update_item'           => __( 'Update Service', 'investment' ),
		'view_item'             => __( 'View Service', 'investment' ),
		'search_items'          => __( 'Search Service', 'investment' ),
		'not_found'             => __( 'Not found', 'investment' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'investment' ),
		'featured_image'        => __( 'Featured Image', 'investment' ),
		'set_featured_image'    => __( 'Set featured image', 'investment' ),
		'remove_featured_image' => __( 'Remove featured image', 'investment' ),
		'use_featured_image'    => __( 'Use as featured image', 'investment' ),
		'insert_into_item'      => __( 'Insert into Service', 'investment' ),
		'uploaded_to_this_item' => __( 'Uploaded to this Service', 'investment' ),
		'items_list'            => __( 'Service list', 'investment' ),
		'items_list_navigation' => __( 'Service list navigation', 'investment' ),
		'filter_items_list'     => __( 'Filter Service list', 'investment' ),
	);
	$args = array(
		'label'                 => __( 'Services', 'investment' ),
		'description'           => __( 'Post Type Description', 'investment' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'thumbnail', 'page-attributes', 'excerpt' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,		
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
	);

	if(get_post_status(get_option('service_archive_id')) == 'publish'){
		$mypost = get_post(get_option('service_archive_id')); 
		$slug = $mypost->post_name;
		$args['rewrite'] = array('slug' => $slug,'with_front' => false);
	}

	if( !in_array('service', investment_disable_post_type_arr()) ){
		register_post_type( 'service', $args );
	}

}
add_action( 'init', 'investment_service_post_type', 0 );

}

if ( ! function_exists('investment_job_post_type') ) {

// Register Custom Post Type
function investment_job_post_type() {

	if(get_post_status(get_option('job_archive_id')) == 'publish'){
		$mypost = get_post(get_option('job_archive_id')); 
		$title = $mypost->post_title;
	}else{
		$title = _x( 'Career', 'Post Type General Name', 'investment' );
	}

	$labels = array(
		'name'                  => esc_attr($title),
		'singular_name'         => _x( 'Job', 'Post Type Singular Name', 'investment' ),
		'menu_name'             => __( 'Career', 'investment' ),
		'name_admin_bar'        => __( 'Career', 'investment' ),
		'archives'              => __( 'Job Archives', 'investment' ),
		'parent_item_colon'     => __( 'Parent Job:', 'investment' ),
		'all_items'             => __( 'All Job', 'investment' ),
		'add_new_item'          => __( 'Add New Job', 'investment' ),
		'add_new'               => __( 'Add New', 'investment' ),
		'new_item'              => __( 'New Job', 'investment' ),
		'edit_item'             => __( 'Edit Job', 'investment' ),
		'update_item'           => __( 'Update Job', 'investment' ),
		'view_item'             => __( 'View Job', 'investment' ),
		'search_items'          => __( 'Search Job', 'investment' ),
		'not_found'             => __( 'Not found', 'investment' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'investment' ),
		'featured_image'        => __( 'Featured Image', 'investment' ),
		'set_featured_image'    => __( 'Set featured image', 'investment' ),
		'remove_featured_image' => __( 'Remove featured image', 'investment' ),
		'use_featured_image'    => __( 'Use as featured image', 'investment' ),
		'insert_into_item'      => __( 'Insert into Job', 'investment' ),
		'uploaded_to_this_item' => __( 'Uploaded to this Job', 'investment' ),
		'items_list'            => __( 'Job list', 'investment' ),
		'items_list_navigation' => __( 'Job list navigation', 'investment' ),
		'filter_items_list'     => __( 'Filter Job list', 'investment' ),
	);
	$args = array(
		'label'                 => __( 'Career', 'investment' ),
		'description'           => __( 'Post Type Description', 'investment' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'page-attributes', 'excerpt' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 6,
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,		
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
	);

	if(get_post_status(get_option('job_archive_id')) == 'publish'){
		$mypost = get_post(get_option('job_archive_id')); 
		$slug = $mypost->post_name;
		$args['rewrite'] = array('slug' => $slug,'with_front' => false);
	}
	
	if( !in_array('job', investment_disable_post_type_arr()) ){
		register_post_type( 'job', $args );
	}

}
add_action( 'init', 'investment_job_post_type', 0 );

}
