<?php
if(!function_exists('investment_parse_text')):
function investment_parse_text( $text, $tag = 'span' ) {
  preg_match_all( "/\{([^\}]*)\}/", $text, $matches );
  if ( !empty( $matches ) ) {
    foreach ( $matches[1] as $value ) {
      $find    = "{{$value}}";
      if( $tag != 'span' ){
        $replace = "<{$tag}>{$value}</{$tag}>";
      }else{
        $replace = "<{$tag} class='primary-color'>{$value}</{$tag}>";
      }
      
      $text    = str_replace( $find, $replace, $text );
    } //$matches[1] as $value
  } //!empty( $matches )
  
  $text = str_replace( " / ", "<span class='separator'>/</span>", $text );
  
  return $text;
}
endif;
if(!function_exists('investment_posts_template')):
  function investment_posts_template( $atts, $content = null, $type = "posts" ) {
    // Prepare error var
    $error = null;
    // Parse attributes
    $atts  = shortcode_atts( array(
       'template' => 'templates/default-loop.php',
      'id' => false,
      'posts_per_page' => get_option( 'posts_per_page' ),
      'post_type' => 'post',
      'taxonomy' => 'category',
      'tax_term' => false,
      'tax_operator' => 'IN',
      'author' => '',
      'tag' => '',
      'meta_key' => '',
      'offset' => 0,
      'order' => 'DESC',
      'orderby' => 'date',
      'post_parent' => false,
      'post_status' => 'publish',
      'ignore_sticky_posts' => 'no',
      'autoplay' => 'no',
      'control' => 'yes',
      'column' => 4 ,
      'active' => '',
      'readmore_link' =>'no',
      'info' => '',
      'pagination' => 'yes',
      'all_posts_link_text' => 'See All posts'
    ), $atts, $type );
    
    $original_atts = $atts;
    
    $author              = sanitize_text_field( $atts['author'] );
    $id                  = $atts['id']; // Sanitized later as an array of integers
    $ignore_sticky_posts = ( bool ) ( $atts['ignore_sticky_posts'] === 'yes' ) ? true : false;
    $meta_key            = sanitize_text_field( $atts['meta_key'] );
    $offset              = intval( $atts['offset'] );
    $order               = sanitize_key( $atts['order'] );
    $orderby             = sanitize_key( $atts['orderby'] );
    $post_parent         = $atts['post_parent'];
    $post_status         = $atts['post_status'];
    $post_type           = sanitize_text_field( $atts['post_type'] );
    $posts_per_page      = intval( $atts['posts_per_page'] );
    $tag                 = sanitize_text_field( $atts['tag'] );
    $tax_operator        = $atts['tax_operator'];
    $tax_term            = sanitize_text_field( $atts['tax_term'] );
    $taxonomy            = sanitize_key( $atts['taxonomy'] );
    // Set up initial query for post
    $args                = array(
       'category_name' => '',
      'order' => $order,
      'orderby' => $orderby,
      'post_type' => explode( ',', $post_type ),
      'posts_per_page' => $posts_per_page,
      'tag' => $tag 
    );
    // Ignore Sticky Posts
    if ( $ignore_sticky_posts )
      $args['ignore_sticky_posts'] = true;
    // Meta key (for ordering)
    if ( !empty( $meta_key ) )
      $args['meta_key'] = $meta_key;
    // If Post IDs
    if ( $id ) {
      $posts_in         = array_map( 'intval', explode( ',', $id ) );
      $args['post__in'] = $posts_in;
    } //$id
    // Post Author
    if ( !empty( $author ) )
      $args['author'] = $author;
    // Offset
    if ( !empty( $offset ) )
      $args['offset'] = $offset;
    // Post Status
    $post_status = explode( ', ', $post_status );
    $validated   = array();
    $available   = array(
       'publish',
      'pending',
      'draft',
      'auto-draft',
      'future',
      'private',
      'inherit',
      'trash',
      'any' 
    );
    foreach ( $post_status as $unvalidated ) {
      if ( in_array( $unvalidated, $available ) )
        $validated[] = $unvalidated;
    } //$post_status as $unvalidated
    if ( !empty( $validated ) )
      $args['post_status'] = $validated;
    // If taxonomy attributes, create a taxonomy query
    if ( !empty( $taxonomy ) && !empty( $tax_term ) ) {
      // Term string to array
      $tax_term = explode( ',', $tax_term );
      // Validate operator
      if ( !in_array( $tax_operator, array(
         'IN',
        'NOT IN',
        'AND' 
      ) ) )
        $tax_operator = 'IN';
      $tax_args         = array(
         'tax_query' => array(
           array(
             'taxonomy' => $taxonomy,
            'field' => ( is_numeric( $tax_term[0] ) ) ? 'id' : 'slug',
            'terms' => $tax_term,
            'operator' => $tax_operator 
          ) 
        ) 
      );
      // Check for multiple taxonomy queries
      $count            = 2;
      $more_tax_queries = false;
      while ( isset( $original_atts['taxonomy_' . $count] ) && !empty( $original_atts['taxonomy_' . $count] ) && isset( $original_atts['tax_' . $count . '_term'] ) && !empty( $original_atts['tax_' . $count . '_term'] ) ) {
        // Sanitize values
        $more_tax_queries        = true;
        $taxonomy                = sanitize_key( $original_atts['taxonomy_' . $count] );
        $terms                   = explode( ', ', sanitize_text_field( $original_atts['tax_' . $count . '_term'] ) );
        $tax_operator            = isset( $original_atts['tax_' . $count . '_operator'] ) ? $original_atts['tax_' . $count . '_operator'] : 'IN';
        $tax_operator            = in_array( $tax_operator, array(
           'IN',
          'NOT IN',
          'AND' 
        ) ) ? $tax_operator : 'IN';
        $tax_args['tax_query'][] = array(
           'taxonomy' => $taxonomy,
          'field' => 'slug',
          'terms' => $terms,
          'operator' => $tax_operator 
        );
        $count++;
      } //isset( $original_atts['taxonomy_' . $count] ) && !empty( $original_atts['taxonomy_' . $count] ) && isset( $original_atts['tax_' . $count . '_term'] ) && !empty( $original_atts['tax_' . $count . '_term'] )
      if ( $more_tax_queries ):
        $tax_relation = 'AND';
        if ( isset( $original_atts['tax_relation'] ) && in_array( $original_atts['tax_relation'], array(
           'AND',
          'OR' 
        ) ) )
          $tax_relation = $original_atts['tax_relation'];
        $args['tax_query']['relation'] = $tax_relation;
      endif;
      $args = array_merge( $args, $tax_args );
    } //!empty( $taxonomy ) && !empty( $tax_term )
    
    // Fix for pagination
    if ( is_front_page() ) {
      $paged = ( get_query_var( 'page' ) ) ? get_query_var( 'page' ) : 1;
    } //is_front_page()
    else {
      $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
    }
    $args['paged'] = $paged;
    
    // If post parent attribute, set up parent
    if ( $post_parent ) {
      if ( 'current' == $post_parent ) {
        global $post;
        $post_parent = $post->ID;
      } //'current' == $post_parent
      $args['post_parent'] = intval( $post_parent );
    } //$post_parent
    // Save original posts
    global $posts;
    $original_posts = $posts;
    
    
    // Query posts
    $posts = new WP_Query( $args );
    
    $posts->autoplay = $atts['autoplay'];
    $posts->column   = $atts['column'];
    $posts->control  = $atts['control'];
    $posts->readmore_link  = $atts['readmore_link'];
    $posts->info = $atts['info'];
    $posts->all_posts_link_text = $atts['all_posts_link_text'];
    
    // Buffer output
    ob_start();
    // Search for template in stylesheet directory
    if ( file_exists( get_stylesheet_directory() . '/' . $atts['template'] ) )
      load_template( get_stylesheet_directory() . '/' . $atts['template'], false );
    // Search for template in theme directory
    elseif ( file_exists( get_template_directory() . '/template-parts/' . $atts['template'] ) )
      load_template( get_template_directory() . '/template-parts/' . $atts['template'], false );
    elseif ( file_exists( get_template_directory() . '/' . $atts['template'] ) )
      load_template( get_template_directory() . '/' . $atts['template'], false );  
    
    // Template not found
    else
      echo __( 'template not found', 'investment' );
    $output = ob_get_contents();
    ob_end_clean();
    // Return original posts
    $posts = $original_posts;
    // Reset the query
    wp_reset_postdata();
    
    return $output;
  }
endif;

add_shortcode( 'perch_single_team_info', 'perch_single_team_info_callback' );
function perch_single_team_info_callback( $atts, $content = '' ){
	$atts = shortcode_atts( array(
	      'template' => 'team/header-info.php',
	  ), $atts );

	// Buffer output
  ob_start();
  // Search for template in stylesheet directory
  if ( file_exists( get_stylesheet_directory() . '/' . $atts['template'] ) )
    load_template( get_stylesheet_directory() . '/' . $atts['template'], false );
  // Search for template in theme directory
  elseif ( file_exists( get_template_directory() . '/template-parts/' . $atts['template'] ) )
    load_template( get_template_directory() . '/template-parts/' . $atts['template'], false );
  elseif ( file_exists( get_template_directory() . '/' . $atts['template'] ) )
    load_template( get_template_directory() . '/' . $atts['template'], false );  
  
  // Template not found
  else
    echo __( 'template not found', 'investment' );
  $output = ob_get_contents();
  ob_end_clean();
  
  return $output;	
}

//add_shortcode( 'investment_testimonial', 'investment_testimonial_callback' );
function investment_testimonial_callback( $atts, $content = '' ) {
  $atts = shortcode_atts( array(
    'image' => INVESTMENT_ASSETS.'/images/foto-1.png', 
    'title' => 'Jane Smith', 
    'subtitle' => 'Senior Director', 
    'desc' => '"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad', 
    'signature' => INVESTMENT_ASSETS.'/images/painting-1.png',
  ), $atts );
  extract( $atts );
  
  $output = '';
  
  $output .= '<div class="testimonials">               
                <div class="testimonials-image-holder">
                  <a href="'.esc_url($image).'" class="full-size"><img class="img-circle" src="'.esc_url($image).'" alt="image"></a>
                </div>
                <div class="content-block">
                  <h4>'.esc_attr($title).'</h4>
                  <p class="caps_small">'.esc_attr($subtitle).'</p>
                  <p class="smaller">'.esc_attr($desc).' </p>
                  <img src="'.esc_url($signature).'" alt="">
                </div>              
              </div>';
      
  
  return $output;
}

add_shortcode( 'investment_posts', 'investment_posts_callback' );
function investment_posts_callback( $atts, $content = '' ) {
    $atts = shortcode_atts( array(
      'title_display' => 'yes',
      'title' => 'News',
      'desc' => 'Advent has one of the world’s largest and most experienced private equity teams, with more than 170 investment professionals across four continents.',
      'button_link_text' => 'View all news',
      'image_link_type' => 'popup',
     'template' => 'templates/default-loop.php',
     'read_more' => 'Read more',
     'posts_per_page' => 3,
     'id' => '',
     'tax_term' => false,
     'tax_operator' => '',
     'order' => 'desc',
     'orderby' => 'id',
     'post_type' => 'post',
    'taxonomy' => 'category',
    'column' => 3,
  ), $atts );

  $atts['info'] = $atts;


  return investment_posts_template( $atts );
}

add_shortcode( 'investment_portfolios', 'investment_portfolios_callback' );
function investment_portfolios_callback( $atts, $content = '' ) {
    $atts = shortcode_atts( array(
      'title_display' => 'yes',
      'title' => 'Our Sector Knowledge',    
      'button_link_text' => 'View all news',
     'template' => 'portfolio/isotope.php',
     'read_more' => 'Know more',
     'posts_per_page' => -1,
     'active' => '',
     'id' => '',
     'tax_term' => false,
     'tax_operator' => '',
     'order' => 'desc',
     'orderby' => 'id',
     'post_type' => 'portfolio',
    'taxonomy' => 'portfolio_category',
    'column' => 3,
  ), $atts );

  $atts['info'] = $atts;

  
  return investment_posts_template( $atts );
}

add_shortcode( 'investment_service_templates', 'investment_service_templates_callback' );
function investment_service_templates_callback( $atts, $content = '' ) {
    $atts = shortcode_atts( array(
     'template' => 'service/isotope.php',     
     'posts_per_page' => -1,
     'id' => '',
     'tax_term' => false,
     'tax_operator' => '',
     'order' => 'desc',
     'orderby' => 'id',
     'post_type' => 'service',
    'taxonomy' => '',
    'column' => 3,
  ), $atts );

  $atts['info'] = $atts;


  return investment_posts_template( $atts );
}

// Realstate Shortcode
add_shortcode( 'investment_teams', 'investment_teams_callback' );
function investment_teams_callback( $atts = null, $content = null ) {
    $atts = shortcode_atts( array(   
      'title_display' => 'yes',
      'title' => '{Experienced} Team',
      'desc' => 'Advent has one of the world’s largest and most experienced private equity teams, with more than 170 investment professionals across four continents.',
      'button_link_text' => 'Meet our team',       
        'template' => 'team/default-loop.php',
        'display' => 'all',
        'teams' => '',
        'posts_per_page' => 3,
        'column' => 3,        
      ), $atts, 'teams' );
    do_action( 'perch/shortcode/teams', $atts );

    $teams_arr = (function_exists('vc_param_group_parse_atts'))? vc_param_group_parse_atts($atts['teams']) : array();
    $arr = array();
    if(!empty($teams_arr)){
      foreach ($teams_arr as $key => $value) {
        $arr[] = $value['team'];
      }
    }
    
    $atts['posts_per_page'] = ($atts['display'] == 'all')? $atts['posts_per_page']: '';
    $atts['id'] = ($atts['display'] == 'specific')? implode(',', $arr): false;
    $atts['post_type'] = 'team';

    $atts['info'] = $atts;

    $output = investment_posts_template($atts, '', 'team');

    return $output;

}
add_shortcode( 'investment_add_value', 'investment_add_value_callback' );
function investment_add_value_callback( $atts, $content = '' ) {
  $atts = shortcode_atts( array(
    'add_values' => ''
  ), $atts );
  
  $output = '';
  $output = '';
  $paramGroup = (function_exists('vc_param_group_parse_atts'))? vc_param_group_parse_atts($atts['add_values']) : array();
  if(!empty($paramGroup)){
    $output .= '<div id="main" class="post-text">
                  <ul>';
    foreach ($paramGroup as $key => $value) {
        $output .= '<li>
                      <p class="h_small">'.esc_attr($value['title']).'</p>
                      <p class="smaller">'.esc_attr($value['desc']).'</p>
                      <div class="h30"></div>
                    </li>';
    }
    $output .= '</div></ul>';
  }
  
  return $output;
}

add_shortcode( 'investment_accordions', 'investment_accordions_callback' );
function investment_accordions_callback( $atts, $content = '' ) {
  return '<div class="investment-accordions">'.do_shortcode('[vc_tta_accordion shape="square" spacing="3" c_position="right" active_section="1" no_fill="true"]'.$content.'[/vc_tta_accordion]').'</div>';
}

add_shortcode( 'investment_tabs', 'investment_tabs_callback' );
function investment_tabs_callback( $atts, $content = '' ) {
  return '<div class="investment-tabs">'.do_shortcode('[vc_tta_tabs shape="square" spacing="" active_section="1"]'.$content.'[/vc_tta_tabs]').'</div>';
}


/**
 * The VC Functions
 */
add_action( 'vc_before_init', 'investment_risk_reward_profile_shortcode_vc');
function investment_risk_reward_profile_shortcode_vc() {  
  
  vc_map( 
    array(
      'icon' => 'investment-icon',
      'name' => __('Risk-Reward Profile', 'investment'),
      'base' => 'investment_risk_reward_profile',
      'class' => 'investment-vc',
      'category' => 'Investment',
      'description' => '',
      'params' => array(
        array(
                  'type' => 'textfield',
                  'value' => 'Risk & Reward Profile',
                  'heading' => 'Title',
                  'param_name' => 'title',
                  'admin_label' => true,
              ),          
        // params group
              array(
                  'type' => 'param_group',
                  'save_always' => true,
                  'heading' => __( 'Risk & Reward group', 'investment' ),
                  'param_name' => 'params',
                  'value' => urlencode( json_encode( array(
                            array(                              
                                'title' => '1',         
                                'active' => '',         
                            ),
                            array(                              
                                'title' => '2',         
                                'active' => '',         
                            ),
                            array(                              
                                'title' => '3',         
                                'active' => '',         
                            ),
                            array(                              
                                'title' => '4',         
                                'active' => 'yes',         
                            ),
                            array(                              
                                'title' => '5',         
                                'active' => '',         
                            ),
                            ) ) ),
                  'params' => array(
                    array(
              'type' => 'textfield',
              'heading' => __('Title', 'investment'),
              'param_name' => 'title',
              'description' => '',
              'value' => '',
              'admin_label' => true,
              'edit_field_class' => 'vc_col-sm-8', 
            ),
            array(
              'type' => 'checkbox',
              'heading' => __( 'Checked to make active', 'investment' ),
              'param_name' => 'active',             
              'value' => array( __( 'Yes', 'investment' ) => 'yes' )  ,
              'std' => '',
              'admin_label' => true,
              'edit_field_class' => 'vc_col-sm-4',    
            ),
                  )
              ),
              array(
                  'type' => 'textarea_html',
                  'value' => '',
                  'heading' => '',
                  'param_name' => 'content',
                  'admin_label' => true,
              ),
      )
    ) 
  );
  
}

add_shortcode( 'investment_risk_reward_profile', 'investment_risk_reward_profile_callback' );
function investment_risk_reward_profile_callback( $atts, $content = NULL ){
  extract(shortcode_atts(array(
    'title' => 'Risk & Reward Profile',
      'params' => ''    
  ), $atts));

  $output = '<div class="investment-risk-reward-profile">'; 
  $output .= ($title != '')? '<p class="lead primary-color">'.do_shortcode($title).'</p>' : '';
  

  $paramsarr = (function_exists('vc_param_group_parse_atts'))? vc_param_group_parse_atts($params) : array();
  if( !empty($paramsarr) ):
    $count = 0;
    $output .= '<ul>';
    foreach ($paramsarr as $key => $value):
      $title = $active = '';
      extract($value);
      $class = ( $active == 'yes' )? 'reward-item reward-active' : 'reward-item';
      $title_html = ($title != '')? '<span>'.esc_attr($title).'</span>' : '';       

      $output .= '<li class="'.esc_attr($class).'">
              '.$title_html.'
            </li>'; 
      $count ++;        
    endforeach;
    $output .= '</ul>';
    
  endif; 
  $output .= ($content != '')? '<div class="risk-reward-content">'. do_shortcode($content).'</div>' : '';

  $output .= '</div>';
  
  return $output;
}