<div class="front_page_section front_page_section_contacts<?php
	$chrimson_scheme = chrimson_get_theme_option( 'front_page_contacts_scheme' );
	if ( ! empty( $chrimson_scheme ) && ! chrimson_is_inherit( $chrimson_scheme ) ) {
		echo ' scheme_' . esc_attr( $chrimson_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( chrimson_get_theme_option( 'front_page_contacts_paddings' ) );
	if ( chrimson_get_theme_option( 'front_page_contacts_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$chrimson_css      = '';
		$chrimson_bg_image = chrimson_get_theme_option( 'front_page_contacts_bg_image' );
		if ( ! empty( $chrimson_bg_image ) ) {
			$chrimson_css .= 'background-image: url(' . esc_url( chrimson_get_attachment_url( $chrimson_bg_image ) ) . ');';
		}
		if ( ! empty( $chrimson_css ) ) {
			echo ' style="' . esc_attr( $chrimson_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$chrimson_anchor_icon = chrimson_get_theme_option( 'front_page_contacts_anchor_icon' );
	$chrimson_anchor_text = chrimson_get_theme_option( 'front_page_contacts_anchor_text' );
if ( ( ! empty( $chrimson_anchor_icon ) || ! empty( $chrimson_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_contacts"'
									. ( ! empty( $chrimson_anchor_icon ) ? ' icon="' . esc_attr( $chrimson_anchor_icon ) . '"' : '' )
									. ( ! empty( $chrimson_anchor_text ) ? ' title="' . esc_attr( $chrimson_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_contacts_inner
	<?php
	if ( chrimson_get_theme_option( 'front_page_contacts_fullheight' ) ) {
		echo ' chrimson-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$chrimson_css      = '';
			$chrimson_bg_mask  = chrimson_get_theme_option( 'front_page_contacts_bg_mask' );
			$chrimson_bg_color_type = chrimson_get_theme_option( 'front_page_contacts_bg_color_type' );
			if ( 'custom' == $chrimson_bg_color_type ) {
				$chrimson_bg_color = chrimson_get_theme_option( 'front_page_contacts_bg_color' );
			} elseif ( 'scheme_bg_color' == $chrimson_bg_color_type ) {
				$chrimson_bg_color = chrimson_get_scheme_color( 'bg_color', $chrimson_scheme );
			} else {
				$chrimson_bg_color = '';
			}
			if ( ! empty( $chrimson_bg_color ) && $chrimson_bg_mask > 0 ) {
				$chrimson_css .= 'background-color: ' . esc_attr(
					1 == $chrimson_bg_mask ? $chrimson_bg_color : chrimson_hex2rgba( $chrimson_bg_color, $chrimson_bg_mask )
				) . ';';
			}
			if ( ! empty( $chrimson_css ) ) {
				echo ' style="' . esc_attr( $chrimson_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_contacts_content_wrap content_wrap">
			<?php

			// Title and description
			$chrimson_caption     = chrimson_get_theme_option( 'front_page_contacts_caption' );
			$chrimson_description = chrimson_get_theme_option( 'front_page_contacts_description' );
			if ( ! empty( $chrimson_caption ) || ! empty( $chrimson_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				// Caption
				if ( ! empty( $chrimson_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h2 class="front_page_section_caption front_page_section_contacts_caption front_page_block_<?php echo ! empty( $chrimson_caption ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( $chrimson_caption, 'chrimson_kses_content' );
					?>
					</h2>
					<?php
				}

				// Description
				if ( ! empty( $chrimson_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_contacts_description front_page_block_<?php echo ! empty( $chrimson_description ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( wpautop( $chrimson_description ), 'chrimson_kses_content' );
					?>
					</div>
					<?php
				}
			}

			// Content (text)
			$chrimson_content = chrimson_get_theme_option( 'front_page_contacts_content' );
			$chrimson_layout  = chrimson_get_theme_option( 'front_page_contacts_layout' );
			if ( 'columns' == $chrimson_layout && ( ! empty( $chrimson_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				<div class="front_page_section_columns front_page_section_contacts_columns columns_wrap">
					<div class="column-1_3">
				<?php
			}

			if ( ( ! empty( $chrimson_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				<div class="front_page_section_content front_page_section_contacts_content front_page_block_<?php echo ! empty( $chrimson_content ) ? 'filled' : 'empty'; ?>">
					<?php
					echo wp_kses( $chrimson_content, 'chrimson_kses_content' );
					?>
				</div>
				<?php
			}

			if ( 'columns' == $chrimson_layout && ( ! empty( $chrimson_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div><div class="column-2_3">
				<?php
			}

			// Shortcode output
			$chrimson_sc = chrimson_get_theme_option( 'front_page_contacts_shortcode' );
			if ( ! empty( $chrimson_sc ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_output front_page_section_contacts_output front_page_block_<?php echo ! empty( $chrimson_sc ) ? 'filled' : 'empty'; ?>">
					<?php
					chrimson_show_layout( do_shortcode( $chrimson_sc ) );
					?>
				</div>
				<?php
			}

			if ( 'columns' == $chrimson_layout && ( ! empty( $chrimson_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div></div>
				<?php
			}
			?>

		</div>
	</div>
</div>
