<?php
/**
 * The Header: Logo and main menu
 *
 * @package CHRIMSON
 * @since CHRIMSON 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js<?php
	// Class scheme_xxx need in the <html> as context for the <body>!
	echo ' scheme_' . esc_attr( chrimson_get_theme_option( 'color_scheme' ) );
?>">

<head>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}
	do_action( 'chrimson_action_before_body' );
	?>

	<div class="<?php echo esc_attr( apply_filters( 'chrimson_filter_body_wrap_class', 'body_wrap' ) ); ?>" <?php do_action('chrimson_action_body_wrap_attributes'); ?>>

		<?php do_action( 'chrimson_action_before_page_wrap' ); ?>

		<div class="<?php echo esc_attr( apply_filters( 'chrimson_filter_page_wrap_class', 'page_wrap' ) ); ?>" <?php do_action('chrimson_action_page_wrap_attributes'); ?>>

			<?php do_action( 'chrimson_action_page_wrap_start' ); ?>

			<?php
			$chrimson_full_post_loading = ( chrimson_is_singular( 'post' ) || chrimson_is_singular( 'attachment' ) ) && chrimson_get_value_gp( 'action' ) == 'full_post_loading';
			$chrimson_prev_post_loading = ( chrimson_is_singular( 'post' ) || chrimson_is_singular( 'attachment' ) ) && chrimson_get_value_gp( 'action' ) == 'prev_post_loading';

			// Don't display the header elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ! $chrimson_full_post_loading && ! $chrimson_prev_post_loading ) {

				// Short links to fast access to the content, sidebar and footer from the keyboard
				?>
				<a class="chrimson_skip_link skip_to_content_link" href="#content_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'chrimson_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to content", 'chrimson' ); ?></a>
				<?php if ( chrimson_sidebar_present() ) { ?>
				<a class="chrimson_skip_link skip_to_sidebar_link" href="#sidebar_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'chrimson_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to sidebar", 'chrimson' ); ?></a>
				<?php } ?>
				<a class="chrimson_skip_link skip_to_footer_link" href="#footer_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'chrimson_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to footer", 'chrimson' ); ?></a>

				<?php
				do_action( 'chrimson_action_before_header' );

				// Header
				$chrimson_header_type = chrimson_get_theme_option( 'header_type' );
				if ( 'custom' == $chrimson_header_type && ! chrimson_is_layouts_available() ) {
					$chrimson_header_type = 'default';
				}
				get_template_part( apply_filters( 'chrimson_filter_get_template_part', "templates/header-" . sanitize_file_name( $chrimson_header_type ) ) );

				// Side menu
				if ( in_array( chrimson_get_theme_option( 'menu_side', 'none' ), array( 'left', 'right' ) ) ) {
					get_template_part( apply_filters( 'chrimson_filter_get_template_part', 'templates/header-navi-side' ) );
				}

				// Mobile menu
				if ( apply_filters( 'chrimson_filter_use_navi_mobile', true ) ) {
					get_template_part( apply_filters( 'chrimson_filter_get_template_part', 'templates/header-navi-mobile' ) );
				}

				do_action( 'chrimson_action_after_header' );

			}
			?>

			<?php do_action( 'chrimson_action_before_page_content_wrap' ); ?>

			<div class="page_content_wrap<?php
				if ( chrimson_is_off( chrimson_get_theme_option( 'remove_margins' ) ) ) {
					if ( empty( $chrimson_header_type ) ) {
						$chrimson_header_type = chrimson_get_theme_option( 'header_type' );
					}
					if ( 'custom' == $chrimson_header_type && chrimson_is_layouts_available() ) {
						$chrimson_header_id = chrimson_get_custom_header_id();
						if ( $chrimson_header_id > 0 ) {
							$chrimson_header_meta = chrimson_get_custom_layout_meta( $chrimson_header_id );
							if ( ! empty( $chrimson_header_meta['margin'] ) ) {
								?> page_content_wrap_custom_header_margin<?php
							}
						}
					}
					$chrimson_footer_type = chrimson_get_theme_option( 'footer_type' );
					if ( 'custom' == $chrimson_footer_type && chrimson_is_layouts_available() ) {
						$chrimson_footer_id = chrimson_get_custom_footer_id();
						if ( $chrimson_footer_id ) {
							$chrimson_footer_meta = chrimson_get_custom_layout_meta( $chrimson_footer_id );
							if ( ! empty( $chrimson_footer_meta['margin'] ) ) {
								?> page_content_wrap_custom_footer_margin<?php
							}
						}
					}
				}
				do_action( 'chrimson_action_page_content_wrap_class', $chrimson_prev_post_loading );
				?>"<?php
				if ( apply_filters( 'chrimson_filter_is_prev_post_loading', $chrimson_prev_post_loading ) ) {
					?> data-single-style="<?php echo esc_attr( chrimson_get_theme_option( 'single_style' ) ); ?>"<?php
				}
				do_action( 'chrimson_action_page_content_wrap_data', $chrimson_prev_post_loading );
			?>>
				<?php
				do_action( 'chrimson_action_page_content_wrap', $chrimson_full_post_loading || $chrimson_prev_post_loading );

				// Single posts banner
				if ( apply_filters( 'chrimson_filter_single_post_header', chrimson_is_singular( 'post' ) || chrimson_is_singular( 'attachment' ) ) ) {
					if ( $chrimson_prev_post_loading ) {
						if ( chrimson_get_theme_option( 'posts_navigation_scroll_which_block', 'article' ) != 'article' ) {
							do_action( 'chrimson_action_between_posts' );
						}
					}
					// Single post thumbnail and title
					$chrimson_path = apply_filters( 'chrimson_filter_get_template_part', 'templates/single-styles/' . chrimson_get_theme_option( 'single_style' ) );
					if ( chrimson_get_file_dir( $chrimson_path . '.php' ) != '' ) {
						get_template_part( $chrimson_path );
					}
				}

				// Widgets area above page
				$chrimson_body_style   = chrimson_get_theme_option( 'body_style' );
				$chrimson_widgets_name = chrimson_get_theme_option( 'widgets_above_page', 'hide' );
				$chrimson_show_widgets = ! chrimson_is_off( $chrimson_widgets_name ) && is_active_sidebar( $chrimson_widgets_name );
				if ( $chrimson_show_widgets ) {
					if ( 'fullscreen' != $chrimson_body_style ) {
						?>
						<div class="content_wrap">
							<?php
					}
					chrimson_create_widgets_area( 'widgets_above_page' );
					if ( 'fullscreen' != $chrimson_body_style ) {
						?>
						</div>
						<?php
					}
				}

				// Content area
				do_action( 'chrimson_action_before_content_wrap' );
				?>
				<div class="content_wrap<?php echo 'fullscreen' == $chrimson_body_style ? '_fullscreen' : ''; ?>">

					<?php do_action( 'chrimson_action_content_wrap_start' ); ?>

					<div class="content">
						<?php
						do_action( 'chrimson_action_page_content_start' );

						// Skip link anchor to fast access to the content from keyboard
						?>
						<a id="content_skip_link_anchor" class="chrimson_skip_link_anchor" href="#"></a>
						<?php
						// Single posts banner between prev/next posts
						if ( ( chrimson_is_singular( 'post' ) || chrimson_is_singular( 'attachment' ) )
							&& $chrimson_prev_post_loading 
							&& chrimson_get_theme_option( 'posts_navigation_scroll_which_block', 'article' ) == 'article'
						) {
							do_action( 'chrimson_action_between_posts' );
						}

						// Widgets area above content
						chrimson_create_widgets_area( 'widgets_above_content' );

						do_action( 'chrimson_action_page_content_start_text' );
