<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package CHRIMSON
 * @since CHRIMSON 1.0
 */

if ( chrimson_sidebar_present() ) {
	
	$chrimson_sidebar_type = chrimson_get_theme_option( 'sidebar_type' );
	if ( 'custom' == $chrimson_sidebar_type && ! chrimson_is_layouts_available() ) {
		$chrimson_sidebar_type = 'default';
	}
	
	// Catch output to the buffer
	ob_start();
	if ( 'default' == $chrimson_sidebar_type ) {
		// Default sidebar with widgets
		$chrimson_sidebar_name = chrimson_get_theme_option( 'sidebar_widgets' );
		chrimson_storage_set( 'current_sidebar', 'sidebar' );
		if ( is_active_sidebar( $chrimson_sidebar_name ) ) {
			dynamic_sidebar( $chrimson_sidebar_name );
		}
	} else {
		// Custom sidebar from Layouts Builder
		$chrimson_sidebar_id = chrimson_get_custom_sidebar_id();
		do_action( 'chrimson_action_show_layout', $chrimson_sidebar_id );
	}
	$chrimson_out = trim( ob_get_contents() );
	ob_end_clean();
	
	// If any html is present - display it
	if ( ! empty( $chrimson_out ) ) {
		$chrimson_sidebar_position    = chrimson_get_theme_option( 'sidebar_position' );
		$chrimson_sidebar_position_ss = chrimson_get_theme_option( 'sidebar_position_ss', 'below' );
		?>
		<div class="sidebar widget_area
			<?php
			echo ' ' . esc_attr( $chrimson_sidebar_position );
			echo ' sidebar_' . esc_attr( $chrimson_sidebar_position_ss );
			echo ' sidebar_' . esc_attr( $chrimson_sidebar_type );

			$chrimson_sidebar_scheme = apply_filters( 'chrimson_filter_sidebar_scheme', chrimson_get_theme_option( 'sidebar_scheme', 'inherit' ) );
			if ( ! empty( $chrimson_sidebar_scheme ) && ! chrimson_is_inherit( $chrimson_sidebar_scheme ) && 'custom' != $chrimson_sidebar_type ) {
				echo ' scheme_' . esc_attr( $chrimson_sidebar_scheme );
			}
			?>
		" role="complementary">
			<?php

			// Skip link anchor to fast access to the sidebar from keyboard
			?>
			<a id="sidebar_skip_link_anchor" class="chrimson_skip_link_anchor" href="#"></a>
			<?php

			do_action( 'chrimson_action_before_sidebar_wrap', 'sidebar' );

			// Button to show/hide sidebar on mobile
			if ( in_array( $chrimson_sidebar_position_ss, array( 'above', 'float' ) ) ) {
				$chrimson_title = apply_filters( 'chrimson_filter_sidebar_control_title', 'float' == $chrimson_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'chrimson' ) : '' );
				$chrimson_text  = apply_filters( 'chrimson_filter_sidebar_control_text', 'above' == $chrimson_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'chrimson' ) : '' );
				?>
				<a href="#" class="sidebar_control" title="<?php echo esc_attr( $chrimson_title ); ?>"><?php echo esc_html( $chrimson_text ); ?></a>
				<?php
			}
			?>
			<div class="sidebar_inner">
				<?php
				do_action( 'chrimson_action_before_sidebar', 'sidebar' );
				chrimson_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $chrimson_out ) );
				do_action( 'chrimson_action_after_sidebar', 'sidebar' );
				?>
			</div>
			<?php

			do_action( 'chrimson_action_after_sidebar_wrap', 'sidebar' );

			?>
		</div>
		<div class="clearfix"></div>
		<?php
	}
}
