<?php
/**
 * The template to display Admin notices
 *
 * @package CHRIMSON
 * @since CHRIMSON 1.0.1
 */

$chrimson_theme_slug = get_option( 'template' );
$chrimson_theme_obj  = wp_get_theme( $chrimson_theme_slug );
?>
<div class="chrimson_admin_notice chrimson_welcome_notice notice notice-info is-dismissible" data-notice="admin">
	<?php
	// Theme image
	$chrimson_theme_img = chrimson_get_file_url( 'screenshot.jpg' );
	if ( '' != $chrimson_theme_img ) {
		?>
		<div class="chrimson_notice_image"><img src="<?php echo esc_url( $chrimson_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'chrimson' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="chrimson_notice_title">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Welcome to %1$s v.%2$s', 'chrimson' ),
				$chrimson_theme_obj->get( 'Name' ) . ( CHRIMSON_THEME_FREE ? ' ' . __( 'Free', 'chrimson' ) : '' ),
				$chrimson_theme_obj->get( 'Version' )
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="chrimson_notice_text">
		<p class="chrimson_notice_text_description">
			<?php
			echo str_replace( '. ', '.<br>', wp_kses_data( $chrimson_theme_obj->description ) );
			?>
		</p>
		<p class="chrimson_notice_text_info">
			<?php
			echo wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'chrimson' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="chrimson_notice_buttons">
		<?php
		// Link to the page 'About Theme'
		?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=chrimson_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
			<?php
			echo esc_html__( 'Install plugin "ThemeREX Addons"', 'chrimson' );
			?>
		</a>
	</div>
</div>
