<?php
/**
 * The custom template to display the content
 *
 * Used for index/archive/search.
 *
 * @package CHRIMSON
 * @since CHRIMSON 1.0.50
 */

$chrimson_template_args = get_query_var( 'chrimson_template_args' );
if ( is_array( $chrimson_template_args ) ) {
	$chrimson_columns    = empty( $chrimson_template_args['columns'] ) ? 2 : max( 1, $chrimson_template_args['columns'] );
	$chrimson_blog_style = array( $chrimson_template_args['type'], $chrimson_columns );
} else {
	$chrimson_template_args = array();
	$chrimson_blog_style = explode( '_', chrimson_get_theme_option( 'blog_style' ) );
	$chrimson_columns    = empty( $chrimson_blog_style[1] ) ? 2 : max( 1, $chrimson_blog_style[1] );
}
$chrimson_blog_id       = chrimson_get_custom_blog_id( join( '_', $chrimson_blog_style ) );
$chrimson_blog_style[0] = str_replace( 'blog-custom-', '', $chrimson_blog_style[0] );
$chrimson_expanded      = ! chrimson_sidebar_present() && chrimson_get_theme_option( 'expand_content' ) == 'expand';
$chrimson_components    = ! empty( $chrimson_template_args['meta_parts'] )
							? ( is_array( $chrimson_template_args['meta_parts'] )
								? join( ',', $chrimson_template_args['meta_parts'] )
								: $chrimson_template_args['meta_parts']
								)
							: chrimson_array_get_keys_by_value( chrimson_get_theme_option( 'meta_parts' ) );
$chrimson_post_format   = get_post_format();
$chrimson_post_format   = empty( $chrimson_post_format ) ? 'standard' : str_replace( 'post-format-', '', $chrimson_post_format );

$chrimson_blog_meta     = chrimson_get_custom_layout_meta( $chrimson_blog_id );
$chrimson_custom_style  = ! empty( $chrimson_blog_meta['scripts_required'] ) ? $chrimson_blog_meta['scripts_required'] : 'none';

if ( ! empty( $chrimson_template_args['slider'] ) || $chrimson_columns > 1 || ! chrimson_is_off( $chrimson_custom_style ) ) {
	?><div class="
		<?php
		if ( ! empty( $chrimson_template_args['slider'] ) ) {
			echo 'slider-slide swiper-slide';
		} else {
			echo esc_attr( ( chrimson_is_off( $chrimson_custom_style ) ? 'column' : sprintf( '%1$s_item %1$s_item', $chrimson_custom_style ) ) . "-1_{$chrimson_columns}" );
		}
		?>
	">
	<?php
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
			'post_item post_item_container post_format_' . esc_attr( $chrimson_post_format )
					. ' post_layout_custom post_layout_custom_' . esc_attr( $chrimson_columns )
					. ' post_layout_' . esc_attr( $chrimson_blog_style[0] )
					. ' post_layout_' . esc_attr( $chrimson_blog_style[0] ) . '_' . esc_attr( $chrimson_columns )
					. ( ! chrimson_is_off( $chrimson_custom_style )
						? ' post_layout_' . esc_attr( $chrimson_custom_style )
							. ' post_layout_' . esc_attr( $chrimson_custom_style ) . '_' . esc_attr( $chrimson_columns )
						: ''
						)
		);
	chrimson_add_blog_animation( $chrimson_template_args );
	?>
>
	<?php
	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}
	// Custom layout
	do_action( 'chrimson_action_show_layout', $chrimson_blog_id, get_the_ID() );
	?>
</article><?php
if ( ! empty( $chrimson_template_args['slider'] ) || $chrimson_columns > 1 || ! chrimson_is_off( $chrimson_custom_style ) ) {
	?></div><?php
	// Need opening PHP-tag above just after </div>, because <div> is a inline-block element (used as column)!
}
