<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package CHRIMSON
 * @since CHRIMSON 1.0
 */

$chrimson_template_args = get_query_var( 'chrimson_template_args' );
$chrimson_columns = 1;
if ( is_array( $chrimson_template_args ) ) {
	$chrimson_columns    = empty( $chrimson_template_args['columns'] ) ? 1 : max( 1, $chrimson_template_args['columns'] );
	$chrimson_blog_style = array( $chrimson_template_args['type'], $chrimson_columns );
	if ( ! empty( $chrimson_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $chrimson_columns > 1 ) {
	    $chrimson_columns_class = chrimson_get_column_class( 1, $chrimson_columns, ! empty( $chrimson_template_args['columns_tablet']) ? $chrimson_template_args['columns_tablet'] : '', ! empty($chrimson_template_args['columns_mobile']) ? $chrimson_template_args['columns_mobile'] : '' );
		?>
		<div class="<?php echo esc_attr( $chrimson_columns_class ); ?>">
		<?php
	}
} else {
	$chrimson_template_args = array();
}
$chrimson_expanded    = ! chrimson_sidebar_present() && chrimson_get_theme_option( 'expand_content' ) == 'expand';
$chrimson_post_format = get_post_format();
$chrimson_post_format = empty( $chrimson_post_format ) ? 'standard' : str_replace( 'post-format-', '', $chrimson_post_format );
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_excerpt post_format_' . esc_attr( $chrimson_post_format ) );
	chrimson_add_blog_animation( $chrimson_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$chrimson_hover      = ! empty( $chrimson_template_args['hover'] ) && ! chrimson_is_inherit( $chrimson_template_args['hover'] )
							? $chrimson_template_args['hover']
							: chrimson_get_theme_option( 'image_hover' );
	$chrimson_components = ! empty( $chrimson_template_args['meta_parts'] )
							? ( is_array( $chrimson_template_args['meta_parts'] )
								? $chrimson_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $chrimson_template_args['meta_parts'] ) )
								)
							: chrimson_array_get_keys_by_value( chrimson_get_theme_option( 'meta_parts' ) );
	chrimson_show_post_featured( apply_filters( 'chrimson_filter_args_featured',
		array(
			'no_links'   => ! empty( $chrimson_template_args['no_links'] ),
			'hover'      => $chrimson_hover,
			'meta_parts' => $chrimson_components,
			'thumb_size' => ! empty( $chrimson_template_args['thumb_size'] )
							? $chrimson_template_args['thumb_size']
							: chrimson_get_thumb_size( strpos( chrimson_get_theme_option( 'body_style' ), 'full' ) !== false
								? 'full'
								: ( $chrimson_expanded 
									? 'huge' 
									: 'big' 
									)
								),
		),
		'content-excerpt',
		$chrimson_template_args
	) );

	// Title and post meta
	$chrimson_show_title = get_the_title() != '';
	$chrimson_show_meta  = count( $chrimson_components ) > 0 && ! in_array( $chrimson_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $chrimson_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			if ( apply_filters( 'chrimson_filter_show_blog_title', true, 'excerpt' ) ) {
				do_action( 'chrimson_action_before_post_title' );
				if ( empty( $chrimson_template_args['no_links'] ) ) {
					the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
				} else {
					the_title( '<h3 class="post_title entry-title">', '</h3>' );
				}
				do_action( 'chrimson_action_after_post_title' );
			}
			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post content
	if ( apply_filters( 'chrimson_filter_show_blog_excerpt', empty( $chrimson_template_args['hide_excerpt'] ) && chrimson_get_theme_option( 'excerpt_length' ) > 0, 'excerpt' ) ) {
		?>
		<div class="post_content entry-content">
			<?php

			// Post meta
			if ( apply_filters( 'chrimson_filter_show_blog_meta', $chrimson_show_meta, $chrimson_components, 'excerpt' ) ) {
				if ( count( $chrimson_components ) > 0 ) {
					do_action( 'chrimson_action_before_post_meta' );
					chrimson_show_post_meta(
						apply_filters(
							'chrimson_filter_post_meta_args', array(
								'components' => join( ',', $chrimson_components ),
								'seo'        => false,
								'echo'       => true,
							), 'excerpt', 1
						)
					);
					do_action( 'chrimson_action_after_post_meta' );
				}
			}

			if ( chrimson_get_theme_option( 'blog_content' ) == 'fullpost' ) {
				// Post content area
				?>
				<div class="post_content_inner">
					<?php
					do_action( 'chrimson_action_before_full_post_content' );
					the_content( '' );
					do_action( 'chrimson_action_after_full_post_content' );
					?>
				</div>
				<?php
				// Inner pages
				wp_link_pages(
					array(
						'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'chrimson' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'chrimson' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					)
				);
			} else {
				// Post content area
				chrimson_show_post_content( $chrimson_template_args, '<div class="post_content_inner">', '</div>' );
			}

			// More button
			if ( apply_filters( 'chrimson_filter_show_blog_readmore',  ! isset( $chrimson_template_args['more_button'] ) || ! empty( $chrimson_template_args['more_button'] ), 'excerpt' ) ) {
				if ( empty( $chrimson_template_args['no_links'] ) ) {
					do_action( 'chrimson_action_before_post_readmore' );
					if ( chrimson_get_theme_option( 'blog_content' ) != 'fullpost' ) {
						chrimson_show_post_more_link( $chrimson_template_args, '<p>', '</p>' );
					} else {
						chrimson_show_post_comments_link( $chrimson_template_args, '<p>', '</p>' );
					}
					do_action( 'chrimson_action_after_post_readmore' );
				}
			}

			?>
		</div><!-- .entry-content -->
		<?php
	}
	?>
</article>
<?php

if ( is_array( $chrimson_template_args ) ) {
	if ( ! empty( $chrimson_template_args['slider'] ) || $chrimson_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
