<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package CHRIMSON
 * @since CHRIMSON 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap
<?php
$chrimson_copyright_scheme = chrimson_get_theme_option( 'copyright_scheme' );
if ( ! empty( $chrimson_copyright_scheme ) && ! chrimson_is_inherit( $chrimson_copyright_scheme  ) ) {
	echo ' scheme_' . esc_attr( $chrimson_copyright_scheme );
}
?>
				">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
			<?php
				$chrimson_copyright = chrimson_get_theme_option( 'copyright' );
			if ( ! empty( $chrimson_copyright ) ) {
				// Replace {{Y}} or {Y} with the current year
				$chrimson_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $chrimson_copyright );
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$chrimson_copyright = chrimson_prepare_macros( $chrimson_copyright );
				// Display copyright
				echo wp_kses( nl2br( $chrimson_copyright ), 'chrimson_kses_content' );
			}
			?>
			</div>
		</div>
	</div>
</div>
