<?php
/**
 * The template to display default site footer
 *
 * @package CHRIMSON
 * @since CHRIMSON 1.0.10
 */

$chrimson_footer_id = chrimson_get_custom_footer_id();
$chrimson_footer_meta = get_post_meta( $chrimson_footer_id, 'trx_addons_options', true );
if ( ! empty( $chrimson_footer_meta['margin'] ) ) {
	chrimson_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( chrimson_prepare_css_value( $chrimson_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $chrimson_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $chrimson_footer_id ) ) ); ?>
						<?php
						$chrimson_footer_scheme = chrimson_get_theme_option( 'footer_scheme' );
						if ( ! empty( $chrimson_footer_scheme ) && ! chrimson_is_inherit( $chrimson_footer_scheme  ) ) {
							echo ' scheme_' . esc_attr( $chrimson_footer_scheme );
						}
						?>
						">
	<?php
	// Custom footer's layout
	do_action( 'chrimson_action_show_layout', $chrimson_footer_id );
	?>
</footer><!-- /.footer_wrap -->
