<?php
/**
 * The template to display the site logo in the footer
 *
 * @package CHRIMSON
 * @since CHRIMSON 1.0.10
 */

// Logo
if ( chrimson_is_on( chrimson_get_theme_option( 'logo_in_footer' ) ) ) {
	$chrimson_logo_image = chrimson_get_logo_image( 'footer' );
	$chrimson_logo_text  = get_bloginfo( 'name' );
	if ( ! empty( $chrimson_logo_image['logo'] ) || ! empty( $chrimson_logo_text ) ) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if ( ! empty( $chrimson_logo_image['logo'] ) ) {
					$chrimson_attr = chrimson_getimagesize( $chrimson_logo_image['logo'] );
					echo '<a href="' . esc_url( home_url( '/' ) ) . '">'
							. '<img src="' . esc_url( $chrimson_logo_image['logo'] ) . '"'
								. ( ! empty( $chrimson_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $chrimson_logo_image['logo_retina'] ) . ' 2x"' : '' )
								. ' class="logo_footer_image"'
								. ' alt="' . esc_attr__( 'Site logo', 'chrimson' ) . '"'
								. ( ! empty( $chrimson_attr[3] ) ? ' ' . wp_kses_data( $chrimson_attr[3] ) : '' )
							. '>'
						. '</a>';
				} elseif ( ! empty( $chrimson_logo_text ) ) {
					echo '<h1 class="logo_footer_text">'
							. '<a href="' . esc_url( home_url( '/' ) ) . '">'
								. esc_html( $chrimson_logo_text )
							. '</a>'
						. '</h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
