<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package CHRIMSON
 * @since CHRIMSON 1.0.06
 */

$chrimson_header_css   = '';
$chrimson_header_image = get_header_image();
$chrimson_header_video = chrimson_get_header_video();
if ( ! empty( $chrimson_header_image ) && chrimson_trx_addons_featured_image_override( is_singular() || chrimson_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$chrimson_header_image = chrimson_get_current_mode_image( $chrimson_header_image );
}

$chrimson_header_id = chrimson_get_custom_header_id();
$chrimson_header_meta = get_post_meta( $chrimson_header_id, 'trx_addons_options', true );
if ( ! empty( $chrimson_header_meta['margin'] ) ) {
	chrimson_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( chrimson_prepare_css_value( $chrimson_header_meta['margin'] ) ) ) );
}

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr( $chrimson_header_id ); ?> top_panel_custom_<?php echo esc_attr( sanitize_title( get_the_title( $chrimson_header_id ) ) ); ?>
				<?php
				echo ! empty( $chrimson_header_image ) || ! empty( $chrimson_header_video )
					? ' with_bg_image'
					: ' without_bg_image';
				if ( '' != $chrimson_header_video ) {
					echo ' with_bg_video';
				}
				if ( '' != $chrimson_header_image ) {
					echo ' ' . esc_attr( chrimson_add_inline_css_class( 'background-image: url(' . esc_url( $chrimson_header_image ) . ');' ) );
				}
				if ( is_single() && has_post_thumbnail() ) {
					echo ' with_featured_image';
				}
				if ( chrimson_is_on( chrimson_get_theme_option( 'header_fullheight' ) ) ) {
					echo ' header_fullheight chrimson-full-height';
				}
				$chrimson_header_scheme = chrimson_get_theme_option( 'header_scheme' );
				if ( ! empty( $chrimson_header_scheme ) && ! chrimson_is_inherit( $chrimson_header_scheme  ) ) {
					echo ' scheme_' . esc_attr( $chrimson_header_scheme );
				}
				?>
">
	<?php

	// Background video
	if ( ! empty( $chrimson_header_video ) ) {
		get_template_part( apply_filters( 'chrimson_filter_get_template_part', 'templates/header-video' ) );
	}

	// Custom header's layout
	do_action( 'chrimson_action_show_layout', $chrimson_header_id );

	// Header widgets area
	get_template_part( apply_filters( 'chrimson_filter_get_template_part', 'templates/header-widgets' ) );

	?>
</header>
