<?php
/**
 * The template to display the widgets area in the header
 *
 * @package CHRIMSON
 * @since CHRIMSON 1.0
 */

// Header sidebar
$chrimson_header_name    = chrimson_get_theme_option( 'header_widgets' );
$chrimson_header_present = ! chrimson_is_off( $chrimson_header_name ) && is_active_sidebar( $chrimson_header_name );
if ( $chrimson_header_present ) {
	chrimson_storage_set( 'current_sidebar', 'header' );
	$chrimson_header_wide = chrimson_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $chrimson_header_name ) ) {
		dynamic_sidebar( $chrimson_header_name );
	}
	$chrimson_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $chrimson_widgets_output ) ) {
		$chrimson_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $chrimson_widgets_output );
		$chrimson_need_columns   = strpos( $chrimson_widgets_output, 'columns_wrap' ) === false;
		if ( $chrimson_need_columns ) {
			$chrimson_columns = max( 0, (int) chrimson_get_theme_option( 'header_columns' ) );
			if ( 0 == $chrimson_columns ) {
				$chrimson_columns = min( 6, max( 1, chrimson_tags_count( $chrimson_widgets_output, 'aside' ) ) );
			}
			if ( $chrimson_columns > 1 ) {
				$chrimson_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $chrimson_columns ) . ' widget', $chrimson_widgets_output );
			} else {
				$chrimson_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $chrimson_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<?php do_action( 'chrimson_action_before_sidebar_wrap', 'header' ); ?>
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $chrimson_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $chrimson_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'chrimson_action_before_sidebar', 'header' );
				chrimson_show_layout( $chrimson_widgets_output );
				do_action( 'chrimson_action_after_sidebar', 'header' );
				if ( $chrimson_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $chrimson_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
			<?php do_action( 'chrimson_action_after_sidebar_wrap', 'header' ); ?>
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
