<?php defined( 'ABSPATH' ) || exit;
	$sticky_class 	 = is_sticky() ?'sticky' : ''; 
	$blog_show_media = get_theme_mod( 'blog_show_media', '1' );
?>

<?php if ( has_post_format('link') ): ?>
	<article id="post-<?php the_ID(); ?>" <?php post_class( 'post-wrap '. $sticky_class ); ?>>
		<?php
	        $link = get_post_meta( $post->ID, 'format_link_url', true );
	        $link_description = get_post_meta( $post->ID, 'format_link_description', true );
	        
	        if ( is_single() ) {
                printf( '<h1 class="entry-title"><a href="%1$s" target="blank">%2$s</a></h1>',
                    $link,
                    get_the_title()
                );
	        } else {
                printf( '<h2 class="entry-title"><a href="%1$s" target="blank">%2$s</a></h2>',
                    $link,
                    get_the_title()
                );
	        }
		
	        printf( '<a href="%1$s" target="blank">%2$s</a>',
                $link,
                $link_description
	        );
		?>
	</article>

<?php elseif ( has_post_format( 'aside' ) ): ?>
	<article id="post-<?php the_ID(); ?>" <?php post_class('post-wrap '. $sticky_class); ?>  >
		<div class="post-body">
           <?php the_content(''); /* Display content  */ ?>
	    </div>
	</article>
<?php else: ?>
	<article id="post-<?php the_ID(); ?>" <?php post_class('post-wrap '. $sticky_class); ?>  >
		<div class="wrap-article">
			<?php if ( $blog_show_media ): ?>
				<?php if ( has_post_format( 'audio' ) ): ?>
					<div class="post-media">
			        	<?php egovt_postformat_audio(); /* Display video of post */ ?>
			        </div>
				<?php elseif ( has_post_format( 'gallery' ) ): ?>
					<?php egovt_content_gallery(); /* Display gallery of post */ ?>
				<?php elseif ( has_post_format( 'video' ) ): ?>
					<div class="post-media">
					 	<?php egovt_postformat_video(); /* Display video of post */ ?>	
			        </div>
				<?php elseif ( has_post_thumbnail() ): ?>
			        <div class="post-media">
			        	<a href="<?php echo esc_url(get_the_permalink()); ?> " title="<?php esc_attr_e('Post Media', 'egovt'); ?>">
			        		<?php egovt_content_thumbnail('egovt_portfolio_thumb'); /* Display thumbnail of post */ ?>
			        	</a>
			        </div>
		        <?php endif;
		    endif; ?>
			<div class="evgovt-content">
			    <div class="post-meta-grid">
			        <?php egovt_content_meta_blog_grid(); /* Display Category, Comment */ ?>
			    </div>
		        <div class="post-title">
			        <?php egovt_content_title(); /* Display title of post */ ?>
			    </div>	        
			    <?php if ( !is_single() ) {
			    	egovt_content_readmore(); /* Display read more button in category page */
			    } ?> 
			</div>
		</div>
	</article>
<?php endif; ?>