<?php if ( !defined( 'ABSPATH' ) ) exit();

/**
 * Class ova_list_give_widget
 */
class ova_list_give_widget extends WP_Widget {

    /**
     * Constructor
     */
    public function __construct() {
        parent::__construct( 'give_recent', esc_html__( 'List Give', 'egovt' ), [
            'classname'                   => 'widget_list_give',
            'description'                 => esc_html__( 'Get list give', 'egovt' ),
            'customize_selective_refresh' => true
        ]);
    }

    /**
     * View widget
     */
    public function widget( $args, $instance ) {
        // Get title
        $title = apply_filters( 'widget_title', egovt_get_meta_data( 'title', $instance ) );
        $title = $title ? $title : esc_html__( 'Urgent Causes', 'egovt' );

        // Hierarchical
        $hierarchical = !empty( $instance['hierarchical'] ) ? '1' : '0';

        echo $args['before_widget'];
        if ( $title ) {
            echo $args['before_title'] . $title . $args['after_title'];
        }

        // Get donation forms
        $donation_forms = get_posts([
            'post_type'         => 'give_forms',
            'post_status'       => 'publish',
            'posts_per_page'    => 3,
            'orderby'           => 'ID',
            'order'             => 'DESC'
        ]);

        if ( egovt_array_exists( $donation_forms ) ): ?>
            <div class="list-give">
                <?php foreach ( $donation_forms as $form ):
                    // Get form id
                    $id = $form->ID;

                    // Get title
                    $title = get_the_title( $id );

                    // Get link
                    $link = get_the_permalink( $id );

                    // Get thumbnail
                    $thumbnail = get_the_post_thumbnail_url( $id, 'post-thumbnail' );
                    if ( !$thumbnail ) $thumbnail = egovt_get_campaign_image_url( $id );
                    
                    // Show goal
                    $show_goal = give_get_meta( $id, '_give_goal_option', true );

                    // Progress stats
                    $progress_stats = apply_filters( 'ova_progress_stats', $id );

                    // Get progress
                    $progress = egovt_get_meta_data( 'progress', $progress_stats );

                    // Get actual
                    $actual = egovt_get_meta_data( 'actual', $progress_stats );

                    // Get goal
                    $goal = egovt_get_meta_data( 'goal', $progress_stats );          
                ?>
                    <div class="item-event">
                        <div class="ova-thumb-nail">
                           <a href="<?php echo esc_url( $link ); ?>" style="background-image:url(<?php echo $thumbnail; ?>)" title="<?php echo esc_attr( $title ); ?>"></a>
                       </div>
                       <div class="ova-content">
                            <h3 class="title">
                                <a class="second_font" href="<?php echo esc_url( $link ); ?>">
                                    <?php echo esc_html( $title ); ?>
                                </a>
                            </h3>
                            <div class="raised">
                                <div class="income">
                                    <span class="rain">
                                        <?php esc_html_e( 'Raised', 'egovt' ); ?>
                                    </span>
                                    <span>
                                        <?php echo esc_html( $actual ); ?>
                                    </span>
                                </div>
                                <span class="ingo"><?php esc_html_e( '/', 'egovt' ); ?></span>
                                <?php if ( 'disabled' != $show_goal ): ?>
                                    <div class="goal">
                                        <span>
                                            <?php echo esc_html( $goal ); ?>
                                        </span>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="donate_remaining">
                                <a href="<?php echo esc_url( $id ); ?>" class="donate second_font">
                                    <?php esc_html_e( 'Donate Now', 'egovt' ); ?>
                                </a>
                            </div>
                       </div>
                    </div>
                <?php endforeach; ?>
            </div>
            <div class="button-all-event">
                <a class="second_font" href="<?php echo esc_url( get_post_type_archive_link( 'give_forms' ) ); ?>">
                    <?php esc_html_e( 'View All Give', 'egovt' ); ?>
                    <i data-feather="chevron-right"></i>
                </a>
            </div>
        <?php endif;

        echo $args['after_widget'];
    }

    /**
     * Form
     */
    public function form( $instance ) {
        // Defaults.
        $instance = wp_parse_args( (array)$instance, [ 'title' => '' ] );

        ?>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>">
                <?php esc_html_e( 'Title:', 'egovt' ); ?>
            </label>
            <input
                type="text"
                id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"
                class="widefat"
                name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>"
                value="<?php echo esc_attr( egovt_get_meta_data( 'title', $instance ) ); ?>"
            />
        </p>
        <?php 
    }

    /**
     * Update
     */
    public function update( $new_instance, $old_instance ) {
        $instance           = $old_instance;
        $instance['title']  = sanitize_text_field( $new_instance['title'] );

        return $instance;
    }

} 

/**
 * Register list give widget
 */
add_action( 'widgets_init', function() {
    register_widget( 'ova_list_give_widget' );
});