<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

// Get css class
$css_class = vc_shortcode_custom_css_class( $css );
$el_class  = $this->getExtraClass( $el_class ) . ' ' . $css_class . ' insight-title';

if ( $animation !== '' ) {
	$el_class .= ' tm-animation ' . $animation;
}

if ( $style_type ) {
	$el_class .= ' style-type-' . $style_type;
}

if ( $style ) {
	$el_class .= ' style-' . $style;
}

$uid                  = uniqid( 'insight-title-', false );
$sepatator_icon_class = '#' . $uid . ' .separator--icon i';

if ( $style == 'color' ) {
	$style_color = 'color: ' . $color . '; border-color: ' . $color;
	Insight_Helper::apply_style( $style_color, '#' . $uid );
}

if ( $style == 'color' ) {
	$style_color = 'color: ' . $separator_icon_color;
	Insight_Helper::apply_style( $style_color, $sepatator_icon_class );
}
?>
<div class="<?php echo Insight_Helper::nice_class( $el_class ); ?>" id="<?php echo esc_attr( $uid ); ?>">
	<div class="insight-title--title"><?php echo esc_attr( $title ) ?></div>
	<?php if ( $sub_title_enable == 'yes' ): ?>
		<div class="insight-title--subtitle">
			<?php if ( $leaf_enable == 'yes' ): ?>
				<div class="insight-title--subtitle-inner">
			<?php endif; ?>
			<?php echo esc_attr( $sub_title ) ?>
			<?php if ( $leaf_enable == 'yes' ): ?>
				<div class="insight-leaf">
			        <span class="leaf-1">
				        <svg width="51px" height="26px" viewBox="0 0 51 26" version="1.1"
				             xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
						    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" fill-opacity="0.186680507">
						        <g transform="translate(-703.000000, -877.000000)" fill="#5E5A54">
						            <g transform="translate(698.000000, 811.000000)">
						                <g transform="translate(0.000000, 52.000000)">
						                    <path
							                    d="M41.4261185,49.8025535 C40.5586711,49.0708899 39.7976974,48.2366469 38.8519606,47.56046 C37.7058027,46.7408712 36.1775922,45.9359366 36.4646536,44.038217 C37.1776097,43.0940675 37.6369079,42.0619927 37.5805395,40.8467404 C39.0429869,38.5355628 38.4761711,35.6727591 39.6265044,33.2778432 C40.2194167,32.3881236 39.5795308,31.3037123 40.0774518,30.3972451 C40.0868465,30.1020675 40.0972851,29.8047965 40.1066799,29.5085722 C40.4052237,28.2388899 40.7904079,26.9629273 39.8258816,25.7884974 C38.9386009,24.7480488 37.6943202,24.8767965 36.521022,24.7710768 C35.6493992,24.9291329 35.2370746,25.6524226 34.7214079,26.2480114 C33.3842237,27.8693946 32.4624957,29.6666282 32.3622851,31.8155628 C32.2756448,32.154703 32.1900483,32.4917497 32.1034079,32.8298432 C31.6096623,34.3737684 32.0376448,35.9574694 31.8925483,37.5150021 C31.8497501,37.9891703 32.3309693,38.8851703 31.1712413,38.7313011 C30.7933641,38.1943292 30.4154869,37.6563105 30.0386536,37.1193385 C28.7421799,33.251675 26.4227237,29.7378058 26.0657237,25.546703 C25.3579869,23.2522731 26.168022,21.0687965 26.5521623,18.8539179 L26.532329,18.8895067 C27.3100044,17.4659553 26.3955834,15.8581796 27.0177237,14.4178806 C27.008329,13.8212451 26.9999781,13.2235628 26.9905834,12.6269273 C26.6774255,12.0596002 26.8517501,11.3938806 26.6147939,10.8118993 C26.5782588,10.7867778 26.5427676,10.7658432 26.5083202,10.7480488 C26.5083202,10.7449086 26.5083202,10.739675 26.5104079,10.735488 C26.896636,10.0551142 26.8162588,9.37055346 26.4843115,8.68075907 C25.5333553,7.05204879 25.7389957,4.90939458 24.2128729,3.53399271 C23.1951097,2.67462823 22.1178465,3.03051608 21.0405834,3.37384318 C21.0593729,3.52352543 21.1282676,3.64703944 21.2462237,3.74229178 C19.4925395,4.47500206 19.3359606,6.12255346 19.0040132,7.67066561 C18.1532676,10.6172077 19.0760395,13.4433759 19.5979693,16.2967591 C19.4831448,19.0768712 21.3359957,20.9944787 22.6021974,23.1685348 C22.917443,24.9762357 23.1585746,26.8038245 24.0761272,28.4409086 C24.3725834,29.0113759 24.2066097,29.6865161 24.3391799,30.2936189 C24.0583816,30.0643852 23.7848904,29.8215441 23.4195395,29.7398993 C23.2681799,29.740946 23.1178641,29.7273385 22.9675483,29.7001236 C21.2629255,27.2989273 20.2305483,24.2613198 16.9726623,23.3307778 C15.8766097,22.4253572 15.1761799,23.4438245 14.3525746,23.8719366 C13.8755308,24.7846843 13.8776185,25.6921983 14.3891097,26.593432 C15.6396536,30.559488 17.4413553,34.1686095 20.894443,36.7111142 C22.7566886,38.9165722 25.394522,38.8506282 27.9175308,39.1238245 C29.3016886,39.7790768 29.8559781,41.1796002 30.5960746,42.3393759 C32.9865132,46.0845722 36.5314606,48.6406843 39.7235834,51.5610581 C40.500215,52.2696936 41.3760132,52.3105161 42.0628729,51.5160488 C42.7664343,50.7027404 41.9156886,50.2149647 41.4261185,49.8025535"
							                    transform="translate(28.165272, 27.551109) rotate(-48.000000) translate(-28.165272, -27.551109) "></path>
						                </g>
						            </g>
						        </g>
						    </g>
						</svg>
			        </span>
					<span class="leaf-2">
						<svg width="49px" height="28px" viewBox="0 0 49 28" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
						    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" fill-opacity="0.186680507">
						        <g transform="translate(-1166.000000, -875.000000)" fill="#5E5A54">
						            <g transform="translate(698.000000, 811.000000)">
						                <g transform="translate(0.000000, 52.000000)">
						                    <path d="M508.722476,23.7332051 C506.78716,21.8637472 505.090888,22.9198967 503.715081,24.3874107 C502.345537,25.8496911 501.282888,27.6008687 500.086625,29.225392 L500.086625,29.2274855 L500.086625,29.225392 C499.984327,29.3813547 499.882028,29.5352238 499.77973,29.6901397 C499.489537,29.8429621 499.267195,30.0931304 499.029195,30.3202705 C499.146107,29.7131677 498.963432,29.0443079 499.246318,28.4727939 C499.126274,26.4662145 500.127335,24.6647939 500.296441,22.7105509 C502.1138,20.9227378 502.416519,18.3980276 503.439502,16.2250182 C503.918634,14.9951117 503.969783,13.6364575 504.088783,12.3877098 C504.230748,10.8636724 504.829923,9.11354157 503.622177,7.65754157 C503.033441,6.81492475 503.147221,5.62270045 502.264116,4.92976587 C502.060563,4.47339204 501.857011,4.01806494 501.65137,3.5616911 C500.64509,2.64266307 499.557388,3.05612101 498.476993,3.37118643 C496.652327,4.73088737 496.450862,6.72176587 496.396581,8.76707428 C495.757739,10.0336163 496.523932,11.4550743 495.961291,12.7289434 C495.966511,13.3266257 495.972774,13.9243079 495.977993,14.5209434 C496.633537,15.947635 495.757739,17.5752986 496.565686,18.9800089 L496.545853,18.9454668 C496.982186,21.149878 497.84337,23.3145135 497.189914,25.6246444 C495.853774,29.3541397 494.51659,33.083635 493.179405,36.8120836 L493.178362,36.8120836 C492.917397,37.5165322 492.656432,38.2220276 492.394423,38.9254294 C491.23887,39.1075603 491.699212,38.2000462 491.643888,37.7269247 C491.464344,36.173579 491.854748,34.5794107 491.323423,33.0480462 C491.134484,32.8805696 490.945546,32.7120462 490.755563,32.5424762 C490.606291,30.3684201 489.390195,28.6004948 488.525879,26.7006818 C488.121905,25.9418033 487.629204,25.2813173 486.720002,25.0960462 C485.579063,25.5126444 484.052941,24.6135042 483.234555,26.1270743 C482.729327,27.3915229 482.818055,28.653878 483.244993,29.9162332 C483.261695,30.2124575 483.277353,30.5086818 483.296142,30.8038593 C483.814941,31.6967191 483.201151,32.7968313 483.813897,33.6729434 C484.214739,36.4561958 484.367142,39.3085322 486.037318,41.7400836 C486.040449,42.8715976 486.009134,44.0188126 487.309783,44.5610182 L487.310827,44.5620649 L487.309783,44.5620649 C486.184502,46.9957098 483.880704,48.2821397 482.068563,50.0532051 C481.604046,50.5064388 480.465195,51.0130556 481.294019,51.9561584 C481.963134,52.7192238 482.85459,52.6532799 483.637484,51.9488313 C484.942309,50.7733547 486.207467,49.5497285 487.562397,48.439149 C490.690844,45.8746631 492.347449,42.1085322 495.118897,39.2572425 L495.117853,39.2572425 L495.118897,39.2572425 C497.859028,39.1536163 500.390388,38.4544014 502.540739,36.6592612 C503.339291,36.1306631 504.047028,35.5298406 504.270414,34.5302145 C504.7913,34.3355229 504.701528,33.8498406 504.787125,33.4458033 C504.946835,33.2563453 505.104458,33.0679341 505.264169,32.8805696 C507.121195,31.0718219 507.700537,28.5795603 508.75066,26.3395603 C509.443783,25.4624014 509.431256,24.5946631 508.722476,23.7332051" id="Fill-18" transform="translate(495.131196, 27.751578) rotate(-315.000000) translate(-495.131196, -27.751578) "></path>
						                </g>
						            </g>
						        </g>
						    </g>
						</svg>
					</span>
				</div>
			<?php endif; ?>
			<?php if ( $leaf_enable == 'yes' ): ?>
				</div>
			<?php endif; ?>
		</div>
	<?php endif; ?>
	<?php if ( $separator_enable == 'yes' ): ?>
		<div class="insight-separator">
			<div
				class="separator vc_separator wpb_content_element vc_separator_align_center vc_sep_pos_align_center vc_separator-has-text">
				<span class="vc_sep_holder vc_sep_holder_l"><span class="vc_sep_line"></span></span>
				<div class="separator--icon vc_icon_element vc_icon_element-outer">
					<i class="organik-flower"></i>
				</div>
				<span class="vc_sep_holder vc_sep_holder_r"><span class="vc_sep_line"></span></span>
			</div>
		</div>
	<?php endif; ?>
</div>
