jQuery(document).ready(function ($) {
    // Handle form submission
    $('#jlt_adminify_replace_media_form').on('submit', function (e) {
        e.preventDefault();

        var formData = new FormData(this);

        $.ajax({
            url: jlt_adminify_ajax.ajax_url,
            type: 'POST',
            data: formData,
            contentType: false,
            processData: false,
            success: function (response) {
                $('#jlt_adminify_replace_result').html(response.data);
            },
            error: function (response) {
                $('#jlt_adminify_replace_result').html(response.responseText);
            }
        });
    });

    // Add Replace Media button to media popup
    $(document).on('click', '.jltadminify-replace-media', function () {
        var media_id = $(this).data('id');
        var file_frame = wp.media({
            title: jlt_adminify_ajax.replace_title,
            button: {
                text: jlt_adminify_ajax.replace_button_text
            },
            multiple: false
        });

        file_frame.on('select', function () {
            var attachment = file_frame.state().get('selection').first().toJSON();
            var formData = new FormData();
            formData.append('jlt_adminify_media_id', media_id);
            formData.append('jlt_adminify_new_media', attachment.url);

            $.ajax({
                url: jlt_adminify_ajax.ajax_url,
                type: 'POST',
                data: formData,
                contentType: false,
                processData: false,
                success: function (response) {
                    alert(response.data);
                },
                error: function (response) {
                    alert(response.responseText);
                }
            });
        });

        file_frame.open();
    });
});



// (function ($) {
//     'use strict';

//     $(document).ready(function () {
//         // Replace Media section after side metaboxes
//         $('#media-replace-div').appendTo('#postbox-container-1');
//     });

// })(jQuery);


function replaceMedia(oldMimeType) {
    var file_frame;

    // Create the media frame
    file_frame = wp.media.frames.file_frame = wp.media({
        title: 'Select New Media File',
        button: {
            text: 'Replace Media'
        },
        multiple: false,
        library: {
            type: oldMimeType // Ensure the new media file matches the old mime type
        }
    });

    // When a file is selected, run a callback
    file_frame.on('select', function () {
        var attachment = file_frame.state().get('selection').first().toJSON();

        // Make sure the selected file is of the same mime type
        if (attachment.mime !== oldMimeType) {
            alert('Please select a file of the same type.');
            return;
        }

        // Update hidden field with new attachment ID
        document.getElementById('new-attachment-id').value = attachment.id;

        // Perform AJAX request to replace media
        var data = new FormData();
        data.append('action', 'jltwp_adminify_replace_media');
        data.append('attachment_id', document.getElementById('attachment_id').value); // Assuming you have an element with the current attachment ID
        data.append('new-attachment-id', attachment.id);

        fetch(ajaxurl, {
            method: 'POST',
            body: data,
        })
            .then(response => response.json())
            .then(response => {
                if (response.success) {
                    alert('Media file replaced successfully.');
                    // Optionally refresh the page or update the UI to reflect changes
                } else {
                    alert('Error replacing media: ' + response.data);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Error replacing media.');
            });
    });

    // Open the media frame
    file_frame.open();
}
