<?php

namespace ACPT\Constants;

class HTMLTag
{
	/**
	 * @see https://www.w3schools.com/tags/
	 */
	const ALLOWED_FORMATS = [
		'a' => [
			'xlink' => [],
			'target' => [],
			'class' => [],
			'id' => [],
			'rel' => [],
			'href' => [],
			'title' => [],
			'style' => [],
			'data-block-list-id' => [],
			'data-min-blocks' => [],
			'data-max-blocks' => [],
			'data-parent-id' => [],
			'data-layout' => [],
			'data-index' => [],
			'data-id-strategy' => [],
			'data-group-id' => [],
			'data-target-id' => [],
			'data-media-type' => [],
			'data-parent-index' => [],
			'data-parent-name' => [],
			'data-element' => [],
			'data-elements' => [],
			'data-block-id' => [],
			'data-row-id' => [],
			'data-col-id' => [],
		],
		'abbr' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'acronym' => [],
		'address' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'applet' => [],
		'area' => [],
		'article' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'aside' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'audio' => [
			'controls' => [],
			'src' => [],
			'style' => [],
            'data-id' => [],
			'data-artist' => [],
			'data-album' => [],
			'data-title' => [],
			'class' => [],
			'id' => [],
		],
		'b' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'base' => [],
		'basefont' => [],
		'pecifies' => [],
		'bdi' => [],
		'bdo' => [],
		'big' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'blockquote' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'body' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'br' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'button' => [
			'disabled' => [],
			'value' => [],
			'rel' => [],
			'data-wp-editor-id' => [],
			'data-editor' => [],
			'data-id' => [],
			'data-layout' => [],
            'data-index' => [],
			'data-multiple' => [],
			'data-accepts' => [],
			'data-max-size' => [],
			'data-min-size' => [],
			'data-media-type' => [],
			'data-parent-index' => [],
			'data-target-id' => [],
			'data-entity-id' => [],
			'data-entity-value' => [],
			'data-entity-type' => [],
			'data-field-id' => [],
			'data-min-blocks' => [],
			'data-max-blocks' => [],
			'data-hide-label' => [],
			'data-label-name' => [],
			'readonly' => [],
			'style' => [],
			'multiple' => [],
			'type' => [],
			'name' => [],
			'class' => [],
			'id' => [],
		],
		'canvas' => [],
		'caption' => [],
		'center' => [],
		'circle' => [
			'cx' => [],
			'cy' => [],
			'stroke' => [],
			'stroke-dasharray' => [],
			'stroke-dashoffset' => [],
			'stroke-linecap' => [],
			'stroke-linejoin' => [],
			'stroke-miterlimit' => [],
			'stroke-opacity' => [],
			'stroke-width' => [],
			'r' => [],
			'fill' => [],
		],
		'cite' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'code' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'col' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'colgroup' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'data' => [],
		'datalist' => [
			'class' => [],
			'id' => [],
		],
		'dd' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'del' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'details' => [],
		'dfn' => [],
		'dialog' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'dir' => [],
		'efines' => [],
		'div' => [
			'data-tabs' => [],
            'data-default-values' => [],
            'data-field-type' => [],
            'data-post-type' => [],
            'data-post-status' => [],
            'data-post-taxonomy' => [],
            'data-term-taxonomy' => [],
            'data-user-role' => [],
            'data-to-type' => [],
            'data-to-value' => [],
            'data-default-percent' => [],
            'data-lat' => [],
            'data-lng' => [],
            'data-prefix' => [],
            'data-value' => [],
            'data-max' => [],
            'data-min' => [],
            'data-target' => [],
            'data-target-copy' => [],
			'data-parent-id' => [],
			'data-target-id' => [],
			'data-index' => [],
			'data-layout' => [],
			'data-id' => [],
			'style' => [],
			'class' => [],
			'id' => [],
			'draggable' => [],
		],
		'dl' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'dt' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'ellipse' => [
			'cx' => [],
			'cy' => [],
			'rx' => [],
			'ry' => [],
			'stroke' => [],
			'stroke-dasharray' => [],
			'stroke-dashoffset' => [],
			'stroke-linecap' => [],
			'stroke-linejoin' => [],
			'stroke-miterlimit' => [],
			'stroke-opacity' => [],
			'stroke-width' => [],
			'transform' => [],
			'fill' => [],
		],
		'em' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'embed' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'fieldset' => [
			'class' => [],
			'id' => [],
		],
		'figcaption' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'figure' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'font' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'footer' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'form' => [
		    'action' => [],
		    'method' => [],
		    'enctype' => [],
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'frame' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'frameset' => [],
		'g' => [
			'transform' => [],
			'fill' => [],
			'stroke' => [],
			'stroke-dasharray' => [],
			'stroke-dashoffset' => [],
			'stroke-linecap' => [],
			'stroke-linejoin' => [],
			'stroke-miterlimit' => [],
			'stroke-opacity' => [],
			'stroke-width' => [],
			'color' => [],
			'class' => [],
			'id' => [],
			'style' => [],
		],
		'h1' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'h2' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'h3' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'h4' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'h5' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'h6' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'head' => [],
		'header' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'hgroup' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'hr' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'html' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'i' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'iframe' => [
			'title' => [],
			'width' => [],
			'height' => [],
			'src' => [],
			'frameborder' => [],
			'allow' => [],
			'allowfullscreen' => [],
		],
		'img' => [
			'class' => [],
			'id' => [],
			'src' => [],
			'alt' => [],
			'title' => [],
			'data-id' => [],
		],
		'input' => [
			'autocomplete' => [],
			'accept' => [],
			'list' => [],
			'disabled' => [],
			'onchange' => [],
			'onfocus' => [],
			'data-target-id' => [],
			'data-conditional-rules-id' => [],
			'data-conditional-rules-field-forged-by' => [],
			'data-conditional-rules-field-index' => [],
			'data-conditional-rules-block-index' => [],
			'data-conditional-rules-block-name' => [],
			'data-acpt-validate' => [],
			'data-acpt-validate-blank' => [],
			'data-acpt-validate-blank-message' => [],
			'data-acpt-validate-not-blank' => [],
			'data-acpt-validate-not-blank-message' => [],
			'data-acpt-validate-equals' => [],
			'data-acpt-validate-equals-message' => [],
			'data-acpt-validate-not-equals' => [],
			'data-acpt-validate-not-equals-message' => [],
			'data-acpt-validate-gt' => [],
			'data-acpt-validate-gt-message' => [],
			'data-acpt-validate-gte' => [],
			'data-acpt-validate-gte-message' => [],
			'data-acpt-validate-lt' => [],
			'data-acpt-validate-lt-message' => [],
			'data-acpt-validate-lte' => [],
			'data-acpt-validate-lte-message' => [],
			'data-acpt-validate-minlength' => [],
			'data-acpt-validate-minlength-message' => [],
			'data-acpt-validate-min' => [],
			'data-acpt-validate-min-message' => [],
			'data-acpt-validate-maxlength' => [],
			'data-acpt-validate-maxlength-message' => [],
			'data-acpt-validate-max' => [],
			'data-acpt-validate-max-message' => [],
			'data-acpt-validate-required' => [],
			'data-acpt-validate-required-message' => [],
			'data-acpt-validate-regex' => [],
			'data-acpt-validate-regex-message' => [],
			'data-format' => [],
			'data-min-date' => [],
			'data-max-date' => [],
			'data-index' => [],
			'checked' => [],
			'required' => [],
			'novalidate' => [],
			'aria-required' => [],
			'value' => [],
			'readonly' => [],
			'style' => [],
			'type' => [],
			'name' => [],
			'class' => [],
			'id' => [],
			'minlength' => [],
			'maxlength' => [],
			'min' => [],
			'max' => [],
			'step' => [],
			'pattern' => [],
			'placeholder' => [],
		],
		'ins' => [],
		'kbd' => [],
		'label' => [
			'for' => [],
			'title' => [],
			'style' => [],
			'type' => [],
			'name' => [],
			'class' => [],
			'id' => []
		],
		'legend' => [],
		'li' => [
			'aria-grobbed' => [],
			'role' => [],
			'style' => [],
			'class' => [],
			'id' => [],
			'draggable' => [],
			'data-layout' => [],
			'data-value' => [],
			'data-min-blocks' => [],
			'data-max-blocks' => [],
			'data-field-id' => [],
			'data-block-list-id' => [],
			'data-block-index' => [],
			'data-parent-name' => [],
			'data-media-type' => [],
		],
		'line' => [
			'fill' => [],
			'x1' => [],
			'x2' => [],
			'y1' => [],
			'y2' => [],
			'stroke' => [],
			'stroke-dasharray' => [],
			'stroke-dashoffset' => [],
			'stroke-linecap' => [],
			'stroke-linejoin' => [],
			'stroke-miterlimit' => [],
			'stroke-opacity' => [],
			'stroke-width' => [],
			'color' => [],
			'class' => [],
			'id' => [],
			'style' => [],
		],
        'polyline' => [
            'points' => [],
            'fill' => [],
            'stroke' => [],
            'stroke-linecap' => [],
            'stroke-linejoin' => [],
            'stroke-width' => [],
        ],
		'link' => [],
		'main' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'map' => [],
		'mark' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'menu' => [],
		'meta' => [],
		'meter' => [],
		'nav' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'noframes' => [],
		'noscript' => [],
		'object' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'ol' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'optgroup' => [
			'label' => [],
		],
		'option' => [
			'selected' => [],
			'value' => [],
			'label' => [],
			'data-image' => [],
			'data-symbol' => [],
			'data-placeholder' => [],
		],
		'output' => [],
		'p' => [
			'title' => [],
			'style' => [],
			'class' => [],
			'id' => [],
			'data-message-id' => [],
		],
		'param' => [],
		'path' => [
			'd' => [],
			'fill' => [],
            'style' => [],
            'class' => [],
            'id' => [],
			'name' => [],
			'opacity' => [],
			'stroke' => [],
			'stroke-dasharray' => [],
			'stroke-dashoffset' => [],
			'stroke-linecap' => [],
			'stroke-linejoin' => [],
			'stroke-miterlimit' => [],
			'stroke-opacity' => [],
			'stroke-width' => [],
			'fill-rule' => [],
			'clip-rule' => [],
		],
		'picture' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'pre' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'progress' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'q' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'rect' => [
			'x' => [],
			'y' => [],
			'rx' => [],
			'ry' => [],
            'width' => [],
            'height' => [],
			'stroke' => [],
			'stroke-dasharray' => [],
			'stroke-dashoffset' => [],
			'stroke-linecap' => [],
			'stroke-linejoin' => [],
			'stroke-miterlimit' => [],
			'stroke-opacity' => [],
			'stroke-width' => [],
			'fill' => [],
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'rp' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'rt' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'ruby' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		's' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'samp' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'script' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'search' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'section' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'select' => [
			'data-min' => [],
			'data-max' => [],
            'data-field-type' => [],
            'data-default-values' => [],
            'data-layout="' => [],
            'data-to-type' => [],
            'data-to-value' => [],
            'data-post-type' => [],
            'data-post-status' => [],
            'data-post-taxonomy' => [],
            'data-term-taxonomy' => [],
            'data-user-role' => [],
			'data-conditional-rules-id' => [],
			'data-conditional-rules-field-index' => [],
			'data-conditional-rules-block-index' => [],
			'data-conditional-rules-block-name' => [],
			'required' => [],
			'readonly' => [],
			'style' => [],
			'multiple' => [],
			'type' => [],
			'name' => [],
			'class' => [],
			'id' => []
		],
		'small' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'source' => [
			'media' => [],
			'srcset' => [],
			'src' => [],
			'type' => [],
		],
		'span' => [
			'title' => [],
			'style' => [],
			'class' => [],
			'id' => []
		],
		'strike' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'strong' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'style' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'sub' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'summary' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'sup' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'svg' => [
            'id' => [],
			'fill' => [],
			'x' => [],
			'y' => [],
            'style' => [],
			'stroke' => [],
			'stroke-dasharray' => [],
			'stroke-dashoffset' => [],
			'stroke-linecap' => [],
			'stroke-linejoin' => [],
			'stroke-miterlimit' => [],
			'stroke-opacity' => [],
			'stroke-width' => [],
			'xmlns' => [],
			'version' => [],
			'xmlns:svg' => [],
			'xml:space' => [],
			'enable-background' => [],
			'aria-hidden' => [],
			'role' => [],
			'class' => [],
			'width' => [],
			'height' => [],
			'preserveAspectRatio' => [],
			'viewbox' => [],
			'data-width' => [],
			'data-height' => [],
			'data-icon' => [],
			'clip-rule' => [],
		],
		'table' => [
			'data-min-blocks' => [],
			'data-max-blocks' => [],
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'tbody' => [
			'data-min-blocks' => [],
			'data-max-blocks' => [],
			'data-conditional-rules-id' => [],
			'data-conditional-rules-field-index' => [],
			'data-conditional-rules-block-index' => [],
			'data-conditional-rules-block-name' => [],
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'td' => [
			'data-row-id' => [],
			'data-col-id' => [],
			'spellcheck' => [],
			'contenteditable' => [],
			'colspan' => [],
			'width' => [],
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'template' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
        'text' => [
            'x' => [],
            'y' => [],
            'style' => [],
            'class' => [],
            'id' => [],
            'text-anchor' => [],
        ],
		'textarea' => [
            'data-target-id' => [],
            'data-conditional-rules-field-forged-by' => [],
            'data-acpt-validate' => [],
            'data-acpt-validate-blank' => [],
            'data-acpt-validate-blank-message' => [],
            'data-acpt-validate-not-blank' => [],
            'data-acpt-validate-not-blank-message' => [],
            'data-acpt-validate-equals' => [],
            'data-acpt-validate-equals-message' => [],
            'data-acpt-validate-not-equals' => [],
            'data-acpt-validate-not-equals-message' => [],
            'data-acpt-validate-gt' => [],
            'data-acpt-validate-gt-message' => [],
            'data-acpt-validate-gte' => [],
            'data-acpt-validate-gte-message' => [],
            'data-acpt-validate-lt' => [],
            'data-acpt-validate-lt-message' => [],
            'data-acpt-validate-lte' => [],
            'data-acpt-validate-lte-message' => [],
            'data-acpt-validate-minlength' => [],
            'data-acpt-validate-minlength-message' => [],
            'data-acpt-validate-min' => [],
            'data-acpt-validate-min-message' => [],
            'data-acpt-validate-maxlength' => [],
            'data-acpt-validate-maxlength-message' => [],
            'data-acpt-validate-max' => [],
            'data-acpt-validate-max-message' => [],
            'data-acpt-validate-required' => [],
            'data-acpt-validate-required-message' => [],
            'data-acpt-validate-regex' => [],
            'data-acpt-validate-regex-message' => [],
			'data-conditional-rules-id' => [],
			'data-conditional-rules-field-index' => [],
			'data-conditional-rules-block-index' => [],
			'data-conditional-rules-block-name' => [],
			'data-media' => [],
			'data-toolbar' => [],
			'contentEditable' => [],
			'required' => [],
			'minlength' => [],
			'maxlength' => [],
			'rows' => [],
			'cols' => [],
			'readonly' => [],
			'style' => [],
			'multiple' => [],
			'type' => [],
			'name' => [],
			'class' => [],
			'id' => []
		],
		'tfoot' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'th' => [
			'data-row-id' => [],
			'data-col-id' => [],
			'spellcheck' => [],
			'contenteditable' => [],
			'width' => [],
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'thead' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'time' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'title' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'tr' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'track' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'tt' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'u' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
		'ul' => [
			'style' => [],
			'class' => [],
			'id' => [],
			'data-conditional-rules-id' => [],
			'data-min-blocks' => [],
			'data-max-blocks' => [],
		],
		'var' => [],
		'video' => [
			'controls' => [],
			'width' => [],
			'height' => [],
			'muted' => [],
		],
		'wbr' => [
			'style' => [],
			'class' => [],
			'id' => [],
		],
	];
}