<?php

namespace ACPT\Utils\PHP;

class Language
{
	/**
	 * @return array
	 */
	public static function list()
	{
		return [
			"ace_ID"  => "Acehnese",
			"af_ZA"  => "Afrikaans",
			"ak_GH"  => "Akan",
			"sq_AL"  => "Albanian",
			"am_ET"  => "Amharic",
			"aig_AG"  => "Antigua and Barbuda Creole English",
			"ar_SA"  => "Arabic",
			"ar_EG"  => "Arabic Egyptian",
			"an_ES"  => "Aragonese",
			"hy_AM"  => "Armenian",
			"as_IN"  => "Assamese",
			"ast_ES"  => "Asturian",
			"de_AT"  => "Austrian German",
			"awa_IN"  => "Awadhi",
			"quy_PE"  => "Ayacucho Quechua",
			"az_AZ"  => "Azerbaijani",
			"bah_BS"  => "Bahamas Creole English",
			"bjs_BB"  => "Bajan",
			"ban_ID"  => "Balinese",
			"rm_RO"  => "Balkan Gipsy",
			"bm_ML"  => "Bambara",
			"bjn_ID"  => "Banjar",
			"ba_RU"  => "Bashkir",
			"eu_ES"  => "Basque",
			"be_BY"  => "Belarusian",
			"fr_BE"  => "Belgian French",
			"bem_ZM"  => "Bemba",
			"bn_IN"  => "Bengali",
			"bho_IN"  => "Bhojpuri",
			"bh_IN"  => "Bihari",
			"bi_VU"  => "Bislama",
			"gax_KE"  => "Borana",
			"bs_BA"  => "Bosnian",
			"bs_Cyrl_BA" => "Bosnian (Cyrillic)",
			"br_FR"  => "Breton",
			"bug_ID"  => "Buginese",
			"bg_BG"  => "Bulgarian",
			"my_MM"  => "Burmese",
			"ca_ES"  => "Catalan",
			"cav_ES"  => "Catalan Valencian",
			"ceb_PH"  => "Cebuano",
			"tzm_MA"  => "Central Atlas Tamazight",
			"ayr_BO"  => "Central Aymara",
			"knc_NG"  => "Central Kanuri (Latin script)",
			"shu_TD"  => "Chadian Arabic",
			"ch_GU"  => "Chamorro",
			"chr_US"  => "Cherokee",
			"hne_IN"  => "Chhattisgarhi",
			"zh_CN"  => "Chinese Simplified",
			"zh_HK"  => "Chinese Trad. (Hong Kong)",
			"zh_TW"  => "Chinese Traditional",
			"zh_MO"  => "Chinese Traditional Macau",
			"ctg_BD"  => "Chittagonian",
			"cjk_AO"  => "Chokwe",
			"grc_GR"  => "Classical Greek",
			"zdj_KM"  => "Comorian Ngazidja",
			"cop_EG"  => "Coptic",
			"crh_RU"  => "Crimean Tatar",
			"pov_GW"  => "Crioulo Upper Guinea",
			"hr_HR"  => "Croatian",
			"cs_CZ"  => "Czech",
			"da_DK"  => "Danish",
			"prs_AF"  => "Dari",
			"diq_TR"  => "Dimli",
			"nl_NL"  => "Dutch",
			"dyu_CI"  => "Dyula",
			"dz_BT"  => "Dzongkha",
			"ydd_US"  => "Eastern Yiddish",
			"vmw_MZ"  => "Emakhuwa",
			"en_GB"  => "English UK",
			"en_AU"  => "English Australia",
			"en_CA"  => "English Canada",
			"en_IN"  => "English India",
			"en_IE"  => "English Ireland",
			"en_NZ"  => "English New Zealand",
			"en_SG"  => "English Singapore",
			"en_ZA"  => "English South Africa",
			"en_US"  => "English US",
			"eo_EU"  => "Esperanto",
			"et_EE"  => "Estonian",
			"ee_GH"  => "Ewe",
			"fn_FNG"  => "Fanagalo",
			"fo_FO"  => "Faroese",
			"fj_FJ"  => "Fijian",
			"fil_PH"  => "Filipino",
			"fi_FI"  => "Finnish",
			"nl_BE"  => "Flemish",
			"fon_BJ"  => "Fon",
			"fr_FR"  => "French",
			"fr_CA"  => "French Canada",
			"fr_CH"  => "French Swiss",
			"fur_IT"  => "Friulian",
			"ff_FUL"  => "Fula",
			"gl_ES"  => "Galician",
			"mfi_NG"  => "Gamargu",
			"grt_IN"  => "Garo",
			"ka_GE"  => "Georgian",
			"de_DE"  => "German",
			"gil_KI"  => "Gilbertese",
			"glw_NG"  => "Glavda",
			"el_GR"  => "Greek",
			"gcl_GD"  => "Grenadian Creole English",
			"gn_PY"  => "Guarani",
			"gu_IN"  => "Gujarati",
			"gyn_GY"  => "Guyanese Creole English",
			"ht_HT"  => "Haitian Creole French",
			"khk_MN"  => "Halh Mongolian",
			"ha_NE"  => "Hausa",
			"haw_US"  => "Hawaiian",
			"he_IL"  => "Hebrew",
			"hig_NG"  => "Higi",
			"hil_PH"  => "Hiligaynon",
			"mrj_RU"  => "Hill Mari",
			"hi_IN"  => "Hindi",
			"hmn_CN"  => "Hmong",
			"hu_HU"  => "Hungarian",
			"is_IS"  => "Icelandic",
			"ibo_NG"  => "Igbo",
			"ig_NG"  => "Igbo",
			"ilo_PH"  => "Ilocano",
			"id_ID"  => "Indonesian",
			"kl_GL"  => "Inuktitut Greenlandic",
			"ga_IE"  => "Irish Gaelic",
			"it_IT"  => "Italian",
			"it_CH"  => "Italian Swiss",
			"jam_JM"  => "Jamaican Creole English",
			"ja_JP"  => "Japanese",
			"jv_ID"  => "Javanese",
			"kac_MM"  => "Jingpho",
			"quc_GT"  => "K'iche'",
			"kbp_TG"  => "Kabiy\u00e8",
			"kea_CV"  => "Kabuverdianu",
			"kab_DZ"  => "Kabylian",
			"kln_KE"  => "Kalenjin",
			"kam_KE"  => "Kamba",
			"kn_IN"  => "Kannada",
			"kr_KAU"  => "Kanuri",
			"kar_MM"  => "Karen",
			"ks_IN"  => "Kashmiri",
			"kas_IN"  => "Kashmiri (Arabic script)",
			"kk_KZ"  => "Kazakh",
			"kha_IN"  => "Khasi",
			"km_KH"  => "Khmer",
			"kik_KE"  => "Kikuyu",
			"ki_KE"  => "Kikuyu",
			"kmb_AO"  => "Kimbundu",
			"rw_RW"  => "Kinyarwanda",
			"rn_BI"  => "Kirundi",
			"guz_KE"  => "Kisii",
			"kg_CG"  => "Kongo",
			"kok_IN"  => "Konkani",
			"ko_KR"  => "Korean",
			"kmr_TR"  => "Kurdish Kurmanji",
			"ckb_IQ"  => "Kurdish Sorani",
			"ky_KG"  => "Kyrgyz",
			"lo_LA"  => "Lao",
			"ltg_LV"  => "Latgalian",
			"la_XN"  => "Latin",
			"lv_LV"  => "Latvian",
			"lij_IT"  => "Ligurian",
			"li_NL"  => "Limburgish",
			"ln_LIN"  => "Lingala",
			"lt_LT"  => "Lithuanian",
			"lmo_IT"  => "Lombard",
			"lua_CD"  => "Luba_Kasai",
			"lg_UG"  => "Luganda",
			"luy_KE"  => "Luhya",
			"luo_KE"  => "Luo",
			"lb_LU"  => "Luxembourgish",
			"mas_KE"  => "Maa",
			"mk_MK"  => "Macedonian",
			"mag_IN"  => "Magahi",
			"mai_IN"  => "Maithili",
			"mg_MG"  => "Malagasy",
			"ms_MY"  => "Malay",
			"ml_IN"  => "Malayalam",
			"dv_MV"  => "Maldivian",
			"mt_MT"  => "Maltese",
			"mfi_CM"  => "Mandara",
			"mni_IN"  => "Manipuri",
			"gv_IM"  => "Manx Gaelic",
			"mi_NZ"  => "Maori",
			"mr_IN"  => "Marathi",
			"mrt_NG"  => "Margi",
			"mhr_RU"  => "Mari",
			"mh_MH"  => "Marshallese",
			"men_SL"  => "Mende",
			"mer_KE"  => "Meru",
			"nyf_KE"  => "Mijikenda",
			"min_ID"  => "Minangkabau",
			"lus_IN"  => "Mizo",
			"mn_MN"  => "Mongolian",
			"sr_ME"  => "Montenegrin",
			"mfe_MU"  => "Morisyen",
			"ar_MA"  => "Moroccan Arabic",
			"mos_BF"  => "Mossi",
			"ndc_MZ"  => "Ndau",
			"nr_ZA"  => "Ndebele",
			"ne_NP"  => "Nepali",
			"fuv_NG"  => "Nigerian Fulfulde",
			"niu_NU"  => "Niuean",
			"azj_AZ"  => "North Azerbaijani",
			"uzn_UZ"  => "Northern Uzbek",
			"nb_NO"  => "Norwegian Bokm\u00e5l",
			"nn_NO"  => "Norwegian Nynorsk",
			"nus_SS"  => "Nuer",
			"ny_MW"  => "Nyanja",
			"oc_FR"  => "Occitan",
			"oc_ES"  => "Occitan Aran",
			"or_IN"  => "Odia",
			"ory_IN"  => "Oriya",
			"ur_PK"  => "Pakistani",
			"pau_PW"  => "Palauan",
			"pi_IN"  => "Pali",
			"pag_PH"  => "Pangasinan",
			"pap_CW"  => "Papiamentu",
			"ps_PK"  => "Pashto",
			"fa_IR"  => "Persian",
			"pis_SB"  => "Pijin",
			"plt_MG"  => "Plateau Malagasy",
			"pl_PL"  => "Polish",
			"pt_PT"  => "Portuguese",
			"pt_BR"  => "Portuguese Brazil",
			"pot_US"  => "Potawatomi",
			"pa_IN"  => "Punjabi",
			"pnb_PK"  => "Punjabi (Pakistan)",
			"qu_PE"  => "Quechua",
			"rhg_MM"  => "Rohingya",
			"rhl_MM"  => "Rohingyalish",
			"ro_RO"  => "Romanian",
			"roh_CH"  => "Romansh",
			"run_BI"  => "Rundi",
			"ru_RU"  => "Russian",
			"acf_LC"  => "Saint Lucian Creole French",
			"sm_WS"  => "Samoan",
			"sg_CF"  => "Sango",
			"sa_IN"  => "Sanskrit",
			"sat_IN"  => "Santali",
			"sc_IT"  => "Sardinian",
			"gd_GB"  => "Scots Gaelic",
			"seh_ZW"  => "Sena",
			"sr_Cyrl_RS" => "Serbian Cyrillic",
			"sr_Latn_RS" => "Serbian Latin",
			"crs_SC"  => "Seselwa Creole French",
			"nso_ZA"  => "Sesotho",
			"tn_ZA"  => "Setswana (South Africa)",
			"shn_MM"  => "Shan",
			"sn_ZW"  => "Shona",
			"scn_IT"  => "Sicilian",
			"szl_PL"  => "Silesian",
			"snd_PK"  => "Sindhi",
			"sd_PK"  => "Sindhi",
			"si_LK"  => "Sinhala",
			"sk_SK"  => "Slovak",
			"sl_SI"  => "Slovenian",
			"so_SO"  => "Somali",
			"st_LS"  => "Sotho Southern",
			"azb_AZ"  => "South Azerbaijani",
			"pbt_PK"  => "Southern Pashto",
			"dik_SS"  => "Southwestern Dinka",
			"es_ES"  => "Spanish",
			"es_AR"  => "Spanish Argentina",
			"es_CO"  => "Spanish Colombia",
			"es_419"  => "Spanish Latin America",
			"es_MX"  => "Spanish Mexico",
			"es_US"  => "Spanish United States",
			"srn_SR"  => "Sranan Tongo",
			"lvs_LV"  => "Standard Latvian",
			"zsm_MY"  => "Standard Malay",
			"su_ID"  => "Sundanese",
			"sw_KE"  => "Swahili",
			"ss_SZ"  => "Swati",
			"sv_SE"  => "Swedish",
			"de_CH"  => "Swiss German",
			"syc_TR"  => "Syriac (Aramaic)",
			"tl_PH"  => "Tagalog",
			"ty_PF"  => "Tahitian",
			"tg_TJ"  => "Tajik",
			"tmh_DZ"  => "Tamashek (Tuareg)",
			"taq_ML"  => "Tamasheq",
			"ta_IN"  => "Tamil India",
			"ta_LK"  => "Tamil Sri Lanka",
			"trv_TW"  => "Taroko",
			"tt_RU"  => "Tatar",
			"te_IN"  => "Telugu",
			"tet_TL"  => "Tetum",
			"th_TH"  => "Thai",
			"bo_CN"  => "Tibetan",
			"ti_ET"  => "Tigrinya",
			"tpi_PG"  => "Tok Pisin",
			"tkl_TK"  => "Tokelauan",
			"to_TO"  => "Tongan",
			"als_AL"  => "Tosk Albanian",
			"ts_ZA"  => "Tsonga",
			"tsc_MZ"  => "Tswa",
			"tn_BW"  => "Tswana",
			"tum_MW"  => "Tumbuka",
			"tr_TR"  => "Turkish",
			"tk_TM"  => "Turkmen",
			"tvl_TV"  => "Tuvaluan",
			"tw_GH"  => "Twi",
			"udm_RU"  => "Udmurt",
			"uk_UA"  => "Ukrainian",
			"ppk_ID"  => "Uma",
			"umb_AO"  => "Umbundu",
			"uig_CN"  => "Uyghur",
			"ug_CN"  => "Uyghur",
			"uz_UZ"  => "Uzbek",
			"vec_IT"  => "Venetian",
			"vi_VN"  => "Vietnamese",
			"svc_VC"  => "Vincentian Creole English",
			"vic_US"  => "Virgin Islands Creole English",
			"wls_WF"  => "Wallisian",
			"war_PH"  => "Waray (Philippines)",
			"cy_GB"  => "Welsh",
			"gaz_ET"  => "West Central Oromo",
			"pes_IR"  => "Western Persian",
			"wo_SN"  => "Wolof",
			"xh_ZA"  => "Xhosa",
			"yi_YD"  => "Yiddish",
			"yo_NG"  => "Yoruba",
			"zu_ZA"  => "Zulu",
		];
	}

	/**
	 * @param $label
	 *
	 * @return string
	 */
	public static function getCode($label)
	{
		$values = array_flip(self::list());

		if(isset($values[$label])){
			return $values[$label];
		}

		return null;
	}

	/**
	 * @param $code
	 *
	 * @return string
	 */
	public static function getLabel($code)
	{
		if(isset(self::list()[$code])){
			return self::list()[$code];
		}

		return null;
	}
}