<?php
if( !defined( 'ABSPATH' ) ) exit;

class arprice_global_pro_settings{

    var $setact;
    public static function arprice_fetch_pro_default_options(){
        return array(
            'arp_custom_css' => '',
            'arp_enable_ab_testing' => 0,
            'google_map_api_key' => '',
            'arp_track_analytics' => '',
            'arp_enable_loader' => '',
            'enable_material_design_icon' => '',
            'enable_ionicons' => '',
            'enable_typicons' => '',
        );
    }

    function initialize(){
        
        $setact = 0;
        global $arp_chk_version, $arprice_class, $arprice_global_pro_settings;
        $setact = $arprice_class->$arp_chk_version();

        $arprice_global_pro_settings->setact = $setact;
    }

    public static function support_help_icon_block(){
        ?>
            <svg width="52" height="52" viewBox="0 0 70 70" fill="none" id="arprice_template_shortcode" xmlns="http://www.w3.org/2000/svg" class="arp_help_icon_data arprice_help_link" data-copy-title="<?php echo  esc_attr__('Technical Support', 'ARPrice') ?>">
                <a href="https://support.arpluginshop.com" target="_blank" class="arprice_help_link">
                    <path d="M21.5695 48.433C22.0847 48.9482 22.6132 49.4235 23.1727 49.865C23.2915 49.9587 23.464 49.9471 23.5711 49.8401L29.9485 43.4628C30.0822 43.329 30.055 43.1129 29.8955 43.011C29.3236 42.6458 28.7838 42.2143 28.286 41.7166C27.8042 41.2348 27.3881 40.711 27.0278 40.1657C26.9244 40.0093 26.7098 39.985 26.5772 40.1176L20.2078 46.4869C20.0993 46.5954 20.0884 46.771 20.1845 46.8906C20.6146 47.4255 21.0724 47.9359 21.5695 48.433Z" fill="white"/>
                    <path d="M44.2455 51.6012C44.4185 51.5046 44.4503 51.2635 44.3102 51.1235L37.4926 44.3059C37.4216 44.2349 37.3198 44.2075 37.2221 44.2307C35.7445 44.582 34.2126 44.5819 32.7423 44.2234C32.6442 44.1995 32.5418 44.2268 32.4704 44.2982L25.6613 51.1072C25.5214 51.2471 25.5529 51.4879 25.7256 51.5847C31.4611 54.7972 38.5022 54.8052 44.2455 51.6012Z" fill="white"/>
                    <path d="M46.8072 49.8891C47.3752 49.4396 47.912 48.9561 48.4355 48.4325C48.9243 47.9437 49.3739 47.4418 49.7959 46.9153C49.8917 46.7957 49.8806 46.6203 49.7723 46.5119L43.4052 40.1449C43.2718 40.0115 43.0566 40.0382 42.954 40.1965C42.6049 40.7353 42.1916 41.2434 41.7189 41.7162C41.2133 42.2218 40.6652 42.661 40.0801 43.0286C39.9191 43.1298 39.8904 43.3466 40.0248 43.481L46.4084 49.8645C46.5156 49.9717 46.6883 49.9831 46.8072 49.8891Z" fill="white"/>
                    <path d="M18.4499 44.3442C18.5469 44.5162 18.7872 44.5474 18.9269 44.4077L25.7274 37.6072C25.7994 37.5353 25.8265 37.4321 25.8017 37.3334C25.4272 35.8453 25.4122 34.2815 25.7706 32.7788C25.7939 32.6812 25.7665 32.5795 25.6956 32.5085L18.8777 25.6907C18.7377 25.5507 18.4966 25.5823 18.4 25.7552C15.1798 31.5164 15.2038 38.591 18.4499 44.3442Z" fill="white"/>
                    <path d="M32.6257 25.8058C34.1714 25.4088 35.7995 25.4085 37.3379 25.7982C37.4365 25.8232 37.5396 25.7961 37.6115 25.7242L44.412 18.9238C44.5517 18.7841 44.5206 18.5437 44.3485 18.4466C38.5519 15.1763 31.4104 15.1845 25.6295 18.4713C25.4581 18.5688 25.4274 18.8086 25.5669 18.948L32.3511 25.7321C32.4232 25.8043 32.5269 25.8312 32.6257 25.8058Z" fill="white"/>
                    <path d="M43.0136 29.8927C43.1155 30.0523 43.3317 30.0795 43.4654 29.9457L49.8428 23.5684C49.9499 23.4614 49.9615 23.2888 49.8677 23.17C49.0454 22.1277 48.0074 21.0775 46.8933 20.1818C46.7737 20.0857 46.5981 20.0967 46.4896 20.2051L40.1202 26.5745C39.9876 26.7071 40.0119 26.9217 40.1684 27.0251C41.316 27.7833 42.2704 28.7288 43.0136 29.8927Z" fill="white"/>
                    <path d="M51.5885 25.7226C51.4918 25.5499 51.2509 25.5183 51.111 25.6583L44.302 32.4672C44.2306 32.5386 44.2035 32.6409 44.2275 32.7389C44.6011 34.2594 44.586 35.8555 44.1961 37.3761C44.1707 37.4751 44.1977 37.5789 44.2699 37.6512L51.0538 44.435C51.1933 44.5744 51.4332 44.5437 51.5306 44.3721C54.8011 38.6091 54.8255 31.5013 51.5885 25.7226Z" fill="white"/>
                    <path d="M23.0869 20.207C21.9807 21.0935 20.9396 22.1512 20.1131 23.1956C20.0191 23.3145 20.0304 23.4873 20.1376 23.5944L26.5212 29.978C26.6557 30.1124 26.8725 30.0837 26.9736 29.9228C27.6884 28.7852 28.6936 27.7695 29.8057 27.0488C29.9641 26.9461 29.9908 26.7311 29.8574 26.5976L23.4903 20.2306C23.382 20.1223 23.2065 20.1111 23.0869 20.207Z" fill="white"/>
                </a>
            </svg>
        <?php
    }

    public static function arprice_render_pro_settings_ui( $setting_tab ){

        global $arprice_global_pro_settings;
        $arprice_global_pro_settings->initialize();

        $render_func = $setting_tab.'_block';
 
        if( method_exists( $arprice_global_pro_settings, $render_func ) ){
            call_user_func( array( $arprice_global_pro_settings, $render_func ) );
        }
    }

     function arprice_get_licval(){

        if( !isset( $this->setact ) ){
            $this->initialize();
        }

        return $this->setact;
     }

     function arprice_pro_render_license_notice_block(){
         if( !$this->arprice_get_licval() ){
             $admin_css_url = admin_url('admin.php?page=arp_global_settings');
             ?>
                 <div style="margin-top:-35px;margin-bottom:20px;border-left: 4px solid #ffba00;box-shadow: 0 1px 1px 0 rgba(0, 0, 0, 0.1);height:20px;width:99%;padding:10px 25px 10px 0px;background-color:#FFFFFF;color:#000000;font-size:17px;display:block;visibility:visible;text-align:left; padding-left:20px;" >ARPrice license is not activated. Please activate license from <a href="<?php echo $admin_css_url; ?>">here</a></div>
             <?php
        }
    }

    function arprice_pro_external_html_block(){
        ?>
        <div class="arp_admin_modal_overlay arp_no_close">
            <div id="arfresetlicenseform">
                <div class="arfnewmodalclose" onclick="javascript:return false;"><img src="<?php echo PRICINGTABLE_IMAGES_URL . '/close-button.png'; ?>" align="absmiddle" /></div>
                <div class="newform_modal_title_container">
                    <div class="newform_modal_title">&nbsp;RESET LICENSE</div>
                </div>
                <div class="newmodal_field_title"><?php esc_html_e('Please submit this form if you have trouble activating license.', 'ARPrice'); ?></div>
                <iframe style="display:block; height:100%; width:100%; margin-top:0px;" frameborder="0" name="test" id="resetlicframe" src="" hspace="0"></iframe>
            </div> 
        </div>
        <?php
        global $arfsettings;
        $setact = $this->arprice_get_licval();
        
        do_action( 'arprice_pro_external_settings_block' );
    }

    function arprice_custom_css_block(){

        global $arpricemain, $arpricesettings;
        ?>
        <tr>
            <td colspan="3">
                <div class="arp_global_settings_custom_css_wrapper">
                    <textarea class='arp_custom_css arp_global_setting_custom_css_textarea' name='arp_custom_css' id='arp_custom_css' ><?php echo isset($arpricesettings->arp_custom_css) ? esc_attr($arpricesettings->arp_custom_css) : esc_attr(get_option('arp_global_custom_css')); ?></textarea>
                </div>
            </td>
        </tr>
        <tr>
            <td colspan="3">
                <span class="arp_global_setting_custom_css_eg" style="color: #4f61e1;">(e.g.)&nbsp;&nbsp; .btn{color:#000000;}</span>
            </td>
        </tr>
        <?php 
    }

    function arp_enable_ab_testing_block(){

        global $arpricesettings, $arpricemain; 

        $arp_ab_testing = isset($arpricesettings->arp_enable_ab_testing) ? $arpricesettings->arp_enable_ab_testing : 0;
        ?>

        <tr class="arfmainformfield" valign="top">
            <td class="lbltitle" colspan="3">
                <div class="arp_global_setting_frm_main_title"><?php esc_html_e( 'A/B Testing', 'ARPrice' ); ?></div>
            </td>
        </tr>
        <tr class="arpmainformfield arp_global_setting_google_map_main" valign="top">
            
            <td class="tdclass arp_global_setting_resonsive_title_section" colspan="1">
                <div class="arp_reset_template_wrapper arp_global_setting_google_fonts">
                    <span>
                        <p>
                            <span class='arp_switch_wrapper arp_switch_on'>
                                <input type="checkbox" id="arp_enable_ab_testing" name="arp_enable_ab_testing" value="1" <?php checked( $arp_ab_testing, '1'); ?> style="margin-top:0px;"/>
                                <span></span>
                            </span>
                            <label data-for="arp_track_analytics"><?php esc_html_e( 'Enable A/B Testing', 'ARPrice' ); ?></label>                                            
                        </p>
                    </span>
                </div>
            </td>
        </tr>
        <?php
    }

    function arp_font_icons_block(){ 
        global $arpricemain, $arpricesettings;
        ?>
        <tr>
            <td class="arp_global_setting_font_lable" style="width: 25%;">
                <label for="arp_enable_fontawesome_icon"><?php esc_html_e( 'Font-awesome', 'ARPrice' ); ?></label>
            </td>
            <td class="arp_global_setting_font_lable">
                <label for="arp_enable_material_design_icon"><?php esc_html_e( 'Material design', 'ARPrice' ); ?></label>
            </td>
            <td class="arp_global_setting_font_lable">
                <label for="arp_enable_ionicons"><?php esc_html_e( 'Ionicons', 'ARPrice' ); ?></label>
            </td>
            <td class="arp_global_setting_font_lable">
                <label for="arp_enable_typicons"><?php esc_html_e( 'Typicons', 'ARPrice' ); ?></label>
            </td>

        </tr>
        <?php

            $arprice_enable_forntawesome_icon = !empty( $arpricesettings->enable_fontawesome_icon ) ? $arpricesettings->enable_fontawesome_icon : '';
            $arprice_enable_material_design_icon = !empty( $arpricesettings->enable_material_design_icon ) ? $arpricesettings->enable_material_design_icon : '';
            $arprice_enable_ionicons = !empty( $arpricesettings->enable_ionicons ) ? $arpricesettings->enable_ionicons : '';
            $arprice_enable_typicons = !empty( $arpricesettings->enable_typicons ) ? $arpricesettings->enable_typicons : '';

        ?>
        <tr>
            <td class="arp_global_setting_font_switch">
                <span class="arp_switch_wrapper" id="">
                    <input type="checkbox" id="enable_fontawesome_icon" value="enable_fontawesome_icon" class="arp_switch" name="enable_fontawesome_icon" <?php echo !empty( $arprice_enable_forntawesome_icon ) ? 'checked="checked"' : ""; ?> />
                    <span></span>
                    <input type="hidden" name="enable_fontawesome_icon" id="enable_fontawesome_icon_input" value="<?php echo !empty( $arprice_enable_forntawesome_icon ) ? $arprice_enable_forntawesome_icon : 0; ?>" />
                </span>

            </td>
            <td class="arp_global_setting_font_switch">
                <span class="arp_switch_wrapper arp_switch_off" id="">
                    <input type="checkbox" id="enable_material_design_icon" value="enable_material_design_icon" class="arp_switch" name="enable_material_design_icon" <?php echo !empty( $arprice_enable_material_design_icon ) ? 'checked="checked"' : ""; ?> >
                    <span></span>
                </span>                                             
            </td>

            <td class="arp_global_setting_font_switch">
                <span class="arp_switch_wrapper arp_switch_off" id="">
                    <input type="checkbox" id="enable_ionicons" value="enable_ionicons" class="arp_switch" name="enable_ionicons" <?php echo !empty( $arprice_enable_ionicons ) ? 'checked="checked"' : ""; ?>>
                    <span></span>
                </span>  
            </td>

            <td class="arp_global_setting_font_switch">
                <span class="arp_switch_wrapper arp_switch_off" id="">
                    <input type="checkbox" id="enable_typicons" value="enable_typicons" class="arp_switch" name="enable_typicons" <?php echo !empty( $arprice_enable_typicons ) ? 'checked="checked"' : ""; ?>>
                    <span></span>
                </span>  
                
            </td>
        </tr>
    <?php
    }

    function arp_enable_analytics_block(){
        global $arpricemain, $arpricesettings;

        $arprice_track_analytics = isset( $arpricesettings->arp_track_analytics) ? $arpricesettings->arp_track_analytics : '';
        ?>

        <tr class="arfmainformfield" valign="top">
            <td class="lbltitle" colspan="3"><div class="arp_global_setting_frm_main_title"><?php esc_html_e( 'Track button click of pricing table', 'ARPrice' ); ?></div>
            </td>
        </tr>
        <tr>
            <td colspan="3">
                <span class="arp_global_setting_custom_css_eg"><?php esc_html_e( ' ( If you do not want to get analytics of clicked column than uncheck below checkbox. )', 'ARPrice' ); ?> </span>
            </td>
        </tr>
        <tr class="arpmainformfield" valign="top">
            <td class="arp_fix_padding" colspan="3">
                <div class="arp_reset_template_wrapper arp_global_setting_google_fonts">
                    <span>
                        <p>
                            <span class='arp_switch_wrapper'> 
                                <input type="checkbox" class="arp_checkbox light_bg arp_reset_templates" id="arp_track_analytics" name="arp_track_analytics" value="arp_enable_analytics" style="margin-top:0px;" <?php checked( $arprice_track_analytics, 'arp_enable_analytics'); ?>/>
                                <span></span>
                            </span>
                            <label data-for="arp_track_analytics"><?php esc_html_e( 'Enable Analytics', 'ARPrice' ); ?></label>
                        </p>
                    </span>
                </div>
            </td>
        </tr>

        <?php
    }

    function arp_display_loader_block(){
       global $arpricemain, $arpricesettings;

        $arprice_loader = isset( $arpricesettings->arp_enable_loader ) ? $arpricesettings->arp_enable_loader : '';
        ?>
        <tr class="arfmainformfield" valign="top">
            <td class="lbltitle" colspan="3">
                <div class="arp_global_setting_frm_main_title"><?php esc_html_e( 'Display loader upon submission', 'ARPrice' ); ?></div>
            </td>
        </tr>                     
        <tr class="arpmainformfield" valign="top">
            <td class="arp_fix_padding" colspan="3">
                <div class="arp_reset_template_wrapper arp_global_setting_google_fonts">
                    <span>
                        <p>
                            <span class='arp_switch_wrapper'>
                                <input type="checkbox" class="arp_checkbox light_bg arp_reset_templates" id="arp_enable_loader" name="arp_enable_loader"  value="arp_enable_loader" style="margin-top:0px;" <?php checked( $arprice_loader, 'arp_enable_loader'); ?>/>
                            <span></span>
                            </span>
                            <label data-for="arp_enable_loader"><?php esc_html_e( 'Enable Loader', 'ARPrice' ); ?></label>
                        </p>
                    </span>
                </div>
            </td>
        </tr>
        <?php
    }

    function arprice_google_api_key_block(){
            global $arpricemain, $arpricesettings;
        ?>
        <tr class="arfmainformfield" valign="top">
            <td class="lbltitle" colspan="3">
                <div class="arp_global_setting_frm_main_title"><?php esc_html_e( 'Google Map Setting', 'ARPrice' ); ?></div>
            </td>
        </tr>
        <tr class="arpmainformfield arp_global_setting_google_map_main" valign="top">
            <td class="tdclass arp_global_setting_resonsive_title_section" colspan="2"><label class="lblsubtitle arp_global_setting_resonsive_main_title"><?php esc_html_e( 'Enter Google Map API key', 'ARPrice' ); ?></label></td>
        </tr>
        <tr class="arpmainformfield arp_global_setting_google_map_main" valign="top">
            <td class="arp_global_setting_resonsive_title_section" colspan="2">
                <input type="text" name="google_map_api_key" class="txtstandardnew" style="width:400px !important;" id="google_map_api_key" value="<?php echo isset($arpricesettings->google_map_api_key) ? esc_attr($arpricesettings->google_map_api_key) : ""; ?>" >
            </td>
        </tr>
        <?php
    }
    function arprice_licence_purchase_info_block(){
        ?>
        <style>
    #wpcontent, #wpfooter{
        background: #fff;
    }
    .purchased_info{
        color:#7cba6c;
        font-weight:bold;
        font-size: 15px;
    }
    #license_success{
        color:#8ccf7a !important;
    }
    #arfresetlicenseform {
        border-radius:0px;
        text-align:center;
        width:700px;
        height:500px;
        left:35%;
        border:none;
        background:#ffffff !important;
        padding-top:15px;
		margin-top:8% !important;
		margin:0 auto;
    }
    .arfnewmodalclose
    {
        font-size: 15px;
        font-weight: bold;
        height: 19px;
        position: absolute;
        right: 3px;
        top:5px;
        width: 19px;
        cursor:pointer;
        color:#D1D6E5;
    }
    .newform_modal_title { font-size:25px; line-height:25px; margin-bottom: 10px; }
    .newmodal_field_title { font-size: 16px;
    line-height: 16px;
    margin-bottom: 10px; }
</style>
        <?php
        $hostname = isset($_SERVER['HTTP_HOST']) ? sanitize_text_field($_SERVER["HTTP_HOST"]) : '';
        
        global $arprice_class;
        $setact = 0;
        global $arp_chk_version;
        $setact = $arprice_class->$arp_chk_version();
        
        $is_debug_enable = 0;

        if ($setact == 1 && $is_debug_enable == 0) {
            $get_purchased_info = get_option('arpSortInfo');

            $sortorderval = base64_decode($get_purchased_info);
            $ordering = array();

            $pcodeinfo = "";
            $pcodedate = "";
            $pcodedateexp = "";
            $pcodelastverified = "";
            $pcodecustemail = "";

            if (is_array($ordering)) {
                $ordering = explode("^", $sortorderval);
                
                if(is_array($ordering)) {
                if(isset($ordering[0]) && $ordering[0]!= "" ) { $pcodeinfo = $ordering[0]; } else { $pcodeinfo = "";}
                 if(isset($ordering[1]) && $ordering[1]!= "" ) { $pcodedate = $ordering[1]; } else { $pcodedate = "";}
                  if(isset($ordering[2]) && $ordering[2]!= "" ) { $pcodedateexp = $ordering[2]; } else { $pcodedateexp = "";}
                   if(isset($ordering[3]) && $ordering[3]!= "" ) { $pcodelastverified = $ordering[3]; } else { $pcodelastverified = "";}
                   if(isset($ordering[4]) && $ordering[4]!= "" ) { $pcodecustemail = $ordering[4]; } else { $pcodecustemail = "";}

                }
            }
            ?>


            <tr class="arfmainformfield" valign="top"><td class="lbltitle" colspan="3" ><div class="arp_global_setting_frm_main_title"><?php esc_html_e('Product License', 'ARPrice'); ?>&nbsp;</div></td></tr>

            <tr class="arfmainformfield" valign="top">

                <td class="tdclass" style="padding-left:30px; padding-top:22px; font-size:16px; padding-left: 22%;" width="18%">

                    <label class="lblsubtitle"><?php esc_html_e('License Status', 'ARPrice') ?></label>

                </td>

                <td>    
                    <div id="licenseactivatedmessage" class="updated" style="width:300px; vertical-align:top;"><?php echo "Your license is currently Active."; ?></div>


                    <span id="license_link"><button type="button" id="remove-license-purchase-code" name="remove_license" style="width:150px; border:0px; color:#FFFFFF; height:40px; border-radius:3px; -webkit-border-radius:3px; -moz-border-radius:3px; -o-border-radius:3px;" onclick="deactivate_license();" class="red_remove_license_btn"><?php esc_html_e('Remove License', 'ARPrice'); ?></button></span>

                    <span id="deactivate_loader" style="display:none;"><img src="<?php echo esc_url(PRICINGTABLE_IMAGES_URL) . '/loading_activation.gif'; ?>" height="15" /></span>          
                    <span id="deactivate_error" class="arp_not_verify_li" style="display:none;"><?php esc_html_e('Invalid Request', 'ARPrice'); ?></span>
                    <span id="deactivate_success" class="arp_verify_li"  style="display:none;"><?php esc_html_e('License Deactivated Successfully.', 'ARPrice'); ?></span>
                </td>
                <td></td>
            </tr>

            <?php if ($get_purchased_info != "") { ?>

                <tr class="arfmainformfield" valign="top">

                    <td class="tdclass" style="padding-left:30px; padding-top:22px; font-size:16px; padding-left: 22%;" width="18%" >

                    </td>

                    <td>    

                        <label class="lblsubtitle" style="font-weight:bold;font-size:16px;margin-left:-135px;"><?php esc_html_e('Activation Information:', 'ARPrice') ?>&nbsp;&nbsp;</label>

                    </td>

                </tr>

                <tr class="arfmainformfield" valign="top">

                    <td class="tdclass" style="padding-left:30px; padding-top:22px; padding-left: 22%;" width="18%">

                        <label class="lblsubtitle"><?php esc_html_e('Purchase Code:', 'ARPrice') ?>&nbsp;&nbsp;</label>

                    </td>

                    <td style="padding-top:22px;">  

                        <label class="purchased_info"><?php echo esc_attr($pcodeinfo); ?></label>

                    </td>
                </tr>

                <tr class="arfmainformfield" valign="top">

                    <td class="tdclass" style="padding-left:30px; padding-top:22px;  padding-left: 22%;" width="18%">

                        <label class="lblsubtitle"><?php esc_html_e('Purchased On:', 'ARPrice') ?>&nbsp;&nbsp;</label>

                    </td>

                    <td style="padding-top:22px;">  

                        <label class="purchased_info"><?php echo esc_attr($pcodedate); ?></label>

                    </td>
                </tr>

                <tr class="arfmainformfield" valign="top">

                    <td class="tdclass" style="padding-left:30px; padding-top:22px; padding-left: 22%;" width="18%">                    

                        <label class="lblsubtitle"><?php esc_html_e('Support Expires On:', 'ARPrice') ?>&nbsp;&nbsp;</label>

                    </td>

                    <td style="padding-top:22px;">  

                        <label class="purchased_info"><?php echo esc_attr($pcodedateexp); ?></label>
                        
                        <?php if($pcodedateexp != "")
                        { 
                            $exp_date=strtotime($pcodedateexp);
                            $today = strtotime("today"); 

                            if($exp_date < $today)
                            {
                            ?>
                                <br><br>

                                <p>It seems <span style="color:#FF0000;">Your ARPrice support period is expired.</span> To continue receiving our prompt support you need to renew your support. Please  <a href='https://codecanyon.net/item/arprice-pricing-table-plugin-for-wordpress/10049883?ref=utsavinfotech' target='_blank'>click here</a> to extend support. <br/>If you already bought support extension then kindly click button below to refresh support expiry date.</p>
                                <br>
                                <span id="license_link"><button type="button" id="renew-license-purchase-code" name="renew_license" style="width:160px; border:0px; color:#FFFFFF; height:40px; border-radius:3px; box-shadow:0 4px 0 0 #459765;" class="greensavebtn"><?php esc_html_e('Renew License', 'ARPrice'); ?></button></span>

                                <span id="renew_loader" style="display:none;"><img src="<?php echo esc_url(PRICINGTABLE_IMAGES_URL) . '/loading_activation.gif'; ?>" height="15" /></span>        
                                <span id="renew_error" style="display:none;"><?php esc_html_e('Invalid Request', 'ARPrice'); ?></span>
                                <span id="renew_error_renew" style="display:none;color:#FF0000;"><?php echo "It seems that support period is still not extended. Please <a href='https://codecanyon.net/item/arprice-pricing-table-plugin-for-wordpress/10049883?ref=utsavinfotech' target='_blank'>click  here</a> to buy support extension."; ?></span>
                                <span id="renew_success" style="display:none;color:#7cba6c;"><?php esc_html_e('Support Extension Renewed Successfully.', 'ARPrice'); ?></span>
                                <input type="hidden" name="arp_licence_nonce" id="arp_licence_nonce" value="<?php echo esc_attr(wp_create_nonce('arp_licence_nonce')); ?>" />
                                <input type="hidden" name="li_purchase_info" id="li_purchase_info" value="<?php echo esc_attr($get_purchased_info); ?>" autocomplete="off" />
                            <?php 
                            }
                        } ?>
                        

                    </td>


                </tr>
                <tr class="arfmainformfield" valign="top">

                    <td class="tdclass" style="padding-left:30px; padding-top:22px; padding-left: 22%;" width="18%">



                        <label class="lblsubtitle"><?php esc_html_e('Customer Email:', 'ARPrice') ?>&nbsp;&nbsp;&nbsp;</label>

                    </td>

                    <td style="padding-top:22px;">  

                        <label class="purchased_info"><?php echo esc_attr($pcodecustemail); ?></label>

                    </td>
                </tr> 

            <?php } ?>

            <tr class="arfmainformfield" valign="top"><td class="lbltitle" colspan="3"  style="width:100%"><div class="arp_dotted_line"></div></td></tr>
            <?php
        }

        if ($setact != 1 && $is_debug_enable == 0) {
            ?>
            <tr class="arfmainformfield" valign="top"><td class="lbltitle" colspan="3" ><div class="arp_global_setting_frm_main_title"><?php esc_html_e('Product License', 'ARPrice'); ?>&nbsp;</div></td></tr>

            <tr>
                <td colspan="3" style="padding-left:10px;">
                    <label class="lblsubtitle"><div class="arp_global_setting_frm_title" style="width:94%;" ><?php esc_html_e('A valid license key entitles you to support and enables automatic updates. Also you can get Analytics, Custom colors for templates and Toggle Pricing facility after activate your license. A license key only be used for one installation of WordPress at a time.', 'ARPrice') ?></div></label><br />
                </td>
            </tr>

            <tr class="arpmainformfield" valign="top">
                <td class="tdclass" style="padding-left:20%;" width="18%">
                    <label class="lblsubtitle"><?php esc_html_e('Customer Name', 'ARPrice') ?>&nbsp;&nbsp;<span style="vertical-align:middle" class="arfglobalrequiredfield">*</span></label>
                </td>
                <td>    
                    <input type="text" name="li_customer_name" id="li_customer_name" class="txtstandardnew" size="200" value="" autocomplete="off" />
                    <div class="arperrmessage" id="li_customer_name_error" style="display:none;"><?php esc_html_e('This field cannot be blank.', 'ARPrice'); ?></div>
                </td>
                <td></td>
            </tr>

            <tr class="arpmainformfield" valign="top">
                <td class="tdclass" style="padding-left:20%;" width="18%">
                    <label class="lblsubtitle"><?php esc_html_e('Customer Email', 'ARPrice') ?>&nbsp;&nbsp;&nbsp;</label>
                </td>
                <td>    
                    <input type="text" name="li_customer_email" id="li_customer_email" class="txtstandardnew" size="42" value="" autocomplete="off" />
                </td>
                <td></td>
            </tr>   

            <tr class="arpmainformfield" valign="top">
                <td class="tdclass" style="padding-left:20%;" width="18%">
                    <label class="lblsubtitle"><?php esc_html_e('Purchase Code', 'ARPrice') ?>&nbsp;&nbsp;<span style="vertical-align:middle" class="arfglobalrequiredfield">*</span></label>
                </td>

                <td>
                    <input type="text" name="li_license_key" id="li_license_key" class="txtstandardnew" size="42" value="" autocomplete="off" />
                    <div class="arperrmessage" id="li_license_key_error" style="display:none;"><?php esc_html_e('This field cannot be blank.', 'ARPrice'); ?></div>
                </td>
                <td></td>
            </tr>

            <tr class="arpmainformfield" valign="top">
                <td class="tdclass" style="padding-left:20%;" width="18%"> 
                    <label class="lblsubtitle"><?php esc_html_e('Domain Name', 'ARPrice') ?>&nbsp;&nbsp;&nbsp;</label>
                </td>
                <td>    
                    <label class="lblsubtitle"><?php echo esc_attr($hostname); ?></label>
                    <input type="hidden" name="li_domain_name" id="li_domain_name" class="txtstandardnew" size="42" value="<?php echo esc_attr($hostname); ?>" autocomplete="off" />
                </td>
                <td></td>
            </tr>

            <tr class="arpmainformfield" valign="top">
                <td class="tdclass"> </td>

                <td style="padding-top:20px;">                  
                    <span id="license_link"><button type="button" id="verify-purchase-code" name="continue" style="width:150px; border:0px; color:#FFFFFF; height:40px; border-radius:3px; -webkit-border-radius:3px; -moz-border-radius:3px; -o-border-radius:3px;" class="greensavebtn"><?php esc_html_e('Activate', 'ARPrice'); ?></button></span>
                    <span id="license_loader" style="display:none;"><img src="<?php echo esc_url(PRICINGTABLE_IMAGES_URL) . '/loading_activation.gif'; ?>" height="15" /></span>         
                    <span id="license_error" class="arp_not_verify_li" style="display:none;">&nbsp;</span>
                    <span id="license_reset" class="arp_not_verify_li" style="display:none;">&nbsp;&nbsp;<a onclick="javascript:return false;" href="#">Click here to submit RESET request</a></span>
                    <span id="license_success" class="arp_verify_li"  style="display:none;"><?php esc_html_e('License Activated Successfully.', 'ARPrice'); ?></span>
                    <input type="hidden" name="ajaxurl" id="ajaxurl" value="<?php echo esc_url(admin_url('admin-ajax.php')); ?>"  />
                    <input type="hidden" name="arp_licence_nonce" id="arp_licence_nonce" value="<?php echo esc_attr(wp_create_nonce('arp_licence_nonce')); ?>" />
                </td>
                <td></td>   
            </tr>
            <tr class="arfmainformfield" valign="top"><td class="lbltitle" colspan="3" style="width:100%;"><div class="arp_dotted_line"></div></td></tr>
            <?php 
        }        
    }
}

global $arprice_global_pro_settings;
$arprice_global_pro_settings = new arprice_global_pro_settings();

?>