<?php

if ( ! defined( 'ABSPATH' ) ) { exit; }

class arprice_pro_listing_page {


    function initialize(){
        /* global $current_user, $arformcontroller, $maincontroller, $arforms_pro_settings;

        if( !empty( $arforms_pro_settings->setvaltolic) ) {
            return $arforms_pro_settings->setvaltolic;
        }

        global $arformcontroller,$arformsplugin;
        $setvaltolic = 0;
        $setvaltolic = $arformcontroller->$arformsplugin();

        $arforms_pro_settings->setvaltolic = $setvaltolic; */
    }

    public static function arprice_pro_listing_settings_ui( $setting_tab ){

        global $arprice_pro_listing_page;
        $arprice_pro_listing_page->initialize();

        $render_func = $setting_tab.'_block';
 
        if( method_exists( $arprice_pro_listing_page, $render_func ) ){
            call_user_func( array( $arprice_pro_listing_page, $render_func ) );
        }
    }

    function arprice_hidden_input_block(){ 

        global $arprice_analytics, $arprice_form, $arprice_images_css_version,$arprice_version,$wpdb, $arprice_class, $arp_chk_version,$arp_pricingtable;

        /** confirm with azharsir */
        $setact = 0;
        $setact = $arprice_class->$arp_chk_version();

        ?>
        <div id="arp_loader_div" class="arp_loader" style="display: none;">
	        <div class="arp_loader_img"></div>
        </div>
        <link rel="stylesheet" type="text/css" href="https://fonts.googleapis.com/css?family=Ubuntu:400,500,700" />
        <input type="hidden" name="arp_version" id="arp_version" value="<?php echo esc_attr($arprice_version); ?>" />
        <input type="hidden" name="arp_request_version" id="arp_request_version" value="<?php echo esc_attr(get_bloginfo('version')); ?>" />
        <input type="hidden" name="arp_restrict_dashboard" id="arp_restrict_dashboard" value="<?php echo esc_attr(get_option('arp_is_dashboard_visited')); ?>" />
        <input type="hidden" name="arp_tour_guide_value" id="arp_tour_guide_value" value="<?php echo esc_attr(get_option('arprice_tour_guide_value')); ?>" />
        <input type="hidden" id="is_display_analytics" value="<?php echo esc_attr($setact); ?>" name="is_display_analytics" />
        <input type="hidden" name="ajaxurl" id="ajaxurl" value="<?php echo esc_url(admin_url('admin-ajax.php')); ?>" />
        <input type="hidden" name="arp_admin_url" id="arp_admin_url" value="<?php echo esc_url(admin_url('admin.php?page=arprice')); ?>">

        <?php
    }

    function arprice_template_listing_tab_block(){ 

        global $wpdb;

        $editable_templates = "SELECT t.* FROM `" . $wpdb->prefix."arp_arprice` t WHERE t.is_template = %d GROUP BY t.ID ORDER BY t.ID DESC";
        $arp_my_templates = $wpdb->get_results($wpdb->prepare($editable_templates, 0));//phpcs:ignore
        
        ?>

        <ul class="arprice_template_listing_tab_wrapper">
            <?php
                $active_tab_class = 'arp_active';
                $active_template_tab = '';
                if( isset($arp_my_templates) && is_array($arp_my_templates) && count($arp_my_templates) > 0 ){
                    $active_tab_class = '';
                    $active_template_tab = 'arp_active'; ?>
                <li class="arprice_template_listing_tab arp_active" id="arprice_templates"><?php esc_html_e('MY PRICING TABLES','ARPrice'); ?></li>
            <?php } ?>
            <li class="arprice_template_listing_tab <?php echo esc_attr($active_tab_class); ?>" id="arp_create_new_template"><?php esc_html_e('CREATE NEW','ARPrice') ?></li>
        </ul>
        <?php if( isset($arp_my_templates) && is_array($arp_my_templates) && count($arp_my_templates) > 0 ){ ?>
        <button type="button" name="create_new_table" class="arp_create_new_pricing_table_btn arp_active" id="create_new_table"><?php esc_html_e('Add New','ARPrice'); ?></button>
        <?php } ?>
        <button type="button" name="arp_go_create_new_table" class="arp_go_create_new_pricing_table_arrow" id="arp_go_create_new_table"></button>

    <?php 
    }

    function arprice_template_listing_div_block(){

        global $arprice_analytics, $arprice_form, $arprice_images_css_version,$arprice_version,$wpdb, $arprice_class, $arp_chk_version,$arp_pricingtable;

        $setact = 0;
        $setact = $arprice_class->$arp_chk_version();

        $editable_templates = "SELECT t.* FROM `" . $wpdb->prefix."arp_arprice` t WHERE t.is_template = %d GROUP BY t.ID ORDER BY t.ID DESC";
        $arp_my_templates = $wpdb->get_results($wpdb->prepare($editable_templates, 0));//phpcs:ignore?>

        <?php

            if ($setact != 1) {
                $admin_css_url = admin_url('admin.php?page=arprice_settings'); ?>
                    <div style="border-left: 4px solid #ffba00;box-shadow: 0 1px 1px 0 rgba(0, 0, 0, 0.1);-webkit-box-shadow: 0 1px 1px 0 rgba(0, 0, 0, 0.1);-moz-box-shadow: 0 1px 1px 0 rgba(0, 0, 0, 0.1);-o-box-shadow: 0 1px 1px 0 rgba(0, 0, 0, 0.1);height:20px;position:absolute;width:97%;padding:10px 25px 10px 0px;background-color:#FFFFFF;text-align:right;color:#000000;font-size:17px;display:block;visibility:visible;margin-top:-58px;z-index: 1; text-align:left; padding-left:20px;" >ARPrice license is not activated. Please activate license from <a href="<?php echo esc_url($admin_css_url); ?>">here</a></div>

            <?php } 
             
            foreach( $arp_my_templates as $key => $template ){

                $template_view = 0;

                $template_opt = maybe_unserialize($template->general_options);
                $template_name = $template_opt['template_setting']['template'];
                $reference_template = $template_opt['general_settings']['reference_template'];
                $table_name = $template->table_name;
                $arp_template_id = $template->ID;
                $total_visit = 0;// $template->views;
                $total_visit = $arprice_analytics->arp_get_unique_view_counter($arp_template_id);
                $last_update_date = $template->arp_last_updated_date;
                $thumb_img_dir = PRICINGTABLE_UPLOAD_DIR . '/template_images/arptemplate_' . $arp_template_id . '_large.png';
                $thumb_img_path = PRICINGTABLE_UPLOAD_URL . '/template_images/arptemplate_' . $arp_template_id . '_large.png';
                $img_thumb_content = '<div class="arprice_template_thumb_box" style="background: #ffffff url('.$thumb_img_path.') no-repeat center;">
                        </div>';

                if(!file_exists($thumb_img_dir)){
                    $img_thumb_content = '<div class="no_image_div"><span class="no_image_text">No Image</span></div>';    
                }

                if($total_visit>0){
                    $template_view = 1;
                }

                $date_format = get_option('date_format');
                if ($last_update_date == "0000-00-00 00:00:00"){
                    $last_update_date = $template->create_date;
                }
                $date_to_display = date($date_format, strtotime($last_update_date)); ?>
                <div class="arprice_editable_template_container" id="arp_template_<?php echo esc_attr($arp_template_id); ?>">
                    <div class="arprice_editable_template_div"> <?php echo $img_thumb_content;//phpcs:ignore ?>
                        <div class="arprice_template_options_container">
                            <div class="arprice_template_options arprice_template_preview template_action_btn" onClick='arp_pro_price_preview_home("<?php echo esc_attr($arprice_form->get_direct_link($template->ID, true)) ?>");' title="<?php esc_html_e('Preview', 'ARPrice'); ?>" ></div>
                            <div class="arprice_template_options arprice_template_edit template_action_btn" title="<?php esc_html_e('Select Table', 'ARPrice'); ?>" onclick="window.location.href = '<?php echo esc_url(admin_url('admin.php?page=arprice&arp_action=edit&eid=' . $template->ID)) ?>'"></div>
                            <div class="arprice_template_options arprice_template_clone template_action_btn" onclick="window.location.href = '<?php echo esc_url(admin_url('admin.php?page=arprice&arp_action=new&eid=' . $template->ID)); ?>'" title="<?php esc_html_e('Clone Table', 'ARPrice'); ?>"></div>
                            <div id="delete_template" class="arprice_template_options arprice_template_delete template_action_btn" data-template-id="<?php echo esc_attr($template->ID); ?>" title="<?php esc_html_e('Delete Table', 'ARPrice'); ?>"></div>
                        </div>
                        <hr class="arprice_template_seperator">
                        <div class="arprice_template_description_container">
                            <div class="arprice_template_description_row">
                                <div class="arprice_template_description_content arp_font_medium"><?php esc_html_e('Title', 'ARPrice'); ?></div>
                                <div class="arprice_template_description_content arprice_template_listing_table_name" title="<?php echo esc_attr($table_name); ?>" style="line-height: normal;padding:10px 0;"><?php echo esc_attr($table_name); ?></div>
                            </div>
                            <div class="arprice_template_description_row">
                                <div class="arprice_template_description_content arp_font_medium"><?php esc_html_e('Last Modified', 'ARPrice'); ?></div>
                                <div class="arprice_template_description_content"><?php echo esc_attr($date_to_display); ?></div>
                            </div>
                            <div class="arprice_template_description_row">
                                <div class="arprice_template_description_content arp_font_medium"><?php esc_html_e('Statistics', 'ARPrice'); ?></div>
                                <div class="arprice_template_description_content">
                                    <span class="float_left"><?php echo esc_attr($total_visit); ?> <?php esc_html_e('(Visits)', 'ARPrice'); ?></span>
                                    <span class="float_right arprice_statistics_ico" id="arprice_get_analytics" data-template-id="<?php echo esc_attr($arp_template_id); ?>" data-template-views="<?php echo esc_attr($template_view); ?>" title="<?php esc_html_e('Analytics', 'ARPrice'); ?>"></span>
                                    <input type="hidden" name="arp_analytics_nonce" id="arp_analytics_nonce" value="<?php echo esc_attr(wp_create_nonce('arp_analytics_nonce')); ?>" />
                                </div>
                            </div>
                            <div class="arprice_template_description_row">
                                <div class="arprice_template_description_content arp_font_medium"><?php esc_html_e('Shortcode','ARPrice'); ?></div>
                                <div class="arprice_template_description_content" id="arprice_template_shortcode" data-copy-title="<?php esc_html_e('Click to Copy','ARPrice') ?>" data-copied-title="<?php esc_html_e('Copied to Clipboard','ARPrice'); ?>"><?php echo "[ARPrice id=".esc_attr($arp_template_id)."]" ?></div>
                            </div>
                        </div>
                    </div>
                </div>
        <?php } ?>
    <?php }

    function arprice_select_template_container_block() {

        global $arprice_analytics, $arprice_form, $arprice_images_css_version,$arprice_version,$wpdb, $arprice_class, $arp_chk_version,$arp_pricingtable;

        $setact = 0;
        $setact = $arprice_class->$arp_chk_version();

        ?>
        <div class="arprice_select_template_container" style="<?php echo ( $setact != 1 ) ? 'margin-top:30px;' : ''; ?>">
        <h2 class="arprice_select_template_title"><?php esc_html_e('Select Template','ARPrice'); ?></h2>
        <?php
        $default_templates = "SELECT * FROM " . $wpdb->prefix . "arp_arprice WHERE is_template = %d AND status = %s ORDER BY is_template DESC, is_animated ASC, ID ASC";
        $default_templates = $wpdb->get_results($wpdb->prepare($default_templates, 1, 'published'));//phpcs:ignore
        $template_orders = $arp_pricingtable->arp_template_order();
        $template_new_orders = array();
        $x = 0;
        foreach ($template_orders as $key => $value) {
            foreach ($default_templates as $key1 => $template) {
                $template_opt = maybe_unserialize($template->general_options);
                $reference_template = $template_opt['general_settings']['reference_template'];
                if ($key == $reference_template) {
                    $template_new_orders[$x] = $default_templates[$key1];
                }
            }
            $x++;
        }
        ?>
        <div class="arprice_select_template_list_container arp_default_template_list">
            <?php
                foreach( $template_new_orders as $k => $template ){
                    $template_img = 'arp_template_'.$template->template_name.'.png';
                    $template_img_url = PRICINGTABLE_IMAGES_URL.'/template_images/'.$template_img;
                    $template_img_hover = 'arp_template_'.$template->template_name.'_hover.png';
                    $template_img_url_hover = PRICINGTABLE_IMAGES_URL.'/template_images/'.$template_img_hover;
                    $tour_guide_tpl_id='';
                    $tpl_id = "arp_template_".$template->template_name;
                    if($tpl_id=='arp_template_2'){
                        $tour_guide_tpl_id = 'id="arp_template_2"';
                    }

            ?>
            <div class="arprice_select_template_container_item" <?php echo $tour_guide_tpl_id; //phpcs:ignore?>>
                <div class="arprice_select_template_inner_container">
                    <div class="arprice_select_template_bg_img" style="background:url(<?php echo esc_attr($template_img_url); ?>) no-repeat top left;" arp_template="<?php echo esc_attr($template_img_url); ?>" arp_template_hover="<?php echo esc_attr($template_img_url_hover); ?>"></div>
                    <div class="arprice_select_template_action_div">
                        <div class="arprice_select_template_action_btn arprice_preview_template" id="arprice_preview_template" title="<?php esc_html_e('Preview', 'ARPrice'); ?>" onClick='arp_pro_price_preview_home("<?php echo esc_attr($arprice_form->get_direct_link($template->ID, true)) ?>");'></div>
                        <div class="arprice_select_template_action_btn arpice_clone_template" id="clone_template" title="<?php esc_html_e('Select', 'ARPrice'); ?>" onclick="window.location.href = '<?php echo esc_url(admin_url('admin.php?page=arprice&arp_action=new&eid=' . $template->ID)); ?>'"></div>
                    </div>
                </div>
            </div>
            <?php
                }
            ?>
        </div>
    </div>
    <?php
    }

    function arprice_get_analytics_data_block(){ 
        ?>
        <div class="arp_admin_modal_overlay">
            <div class="arp_modal_box" id="arprice_analytic_model_window">
            <div class="modal_top_belt">
                <span class="modal_title"><?php esc_html_e('Analytics', 'ARPrice'); ?></span>
                <span class="arp_modal_close_btn b-close"></span>
            </div>
            <input type="hidden" id="arp_analytic_template_id" value="" />
            <div class="arp_analytic_content_main" style="display:none;">
            <div class="arp_daily_weekly_box">
            <input type="hidden" name="arp_template_listing_daily_nonce" id="arp_template_listing_daily_nonce" value="<?php echo esc_attr(wp_create_nonce('arp_template_listing_daily_nonce')); ?>" />
            <input type="hidden" name="arp_template_listing_nonce" id="arp_template_listing_nonce" value="<?php echo esc_attr(wp_create_nonce('arp_template_listing_nonce')); ?>" />
                <button id='daily_button' class="arp_daily_weekly_button"><?php esc_html_e('Daily', 'ARPrice'); ?></button>
                <button id='weekly_button' class="arp_daily_weekly_button_hover"><?php esc_html_e('Weekly', 'ARPrice'); ?></button>
            </div>
            <div class="arp_analysis">
                <div class="arp_view">
                    <div class="arp_no_views"><span class="arp_view_icon"></span><span class="arp_views_count"></span></div>
                    <div class="clear"></div>
                    <div class="arp_view_label"><?php esc_html_e('total views', 'ARPrice'); ?></div>
                </div>
                <div class="arp_click">
                    <div class="arp_no_clicks"><span class="arp_click_icon"></span><span class="arp_click_count"></span></div>
                    <div class="clear"></div>
                    <div class="arp_view_label"><?php esc_html_e('total clicks', 'ARPrice'); ?></div>
                </div>
                <div class="arp_conversion">
                    <div class="arp_no_conversion"><span class="arp_conversation_icon"></span><span class="arp_conversion_count"></span></div>
                    <div class="clear"></div>
                    <div class="arp_view_label"><?php esc_html_e('conversation', 'ARPrice'); ?></div>
                </div>                    
            </div>
            <div class="arp_date_picker">
                <input id="analytic_start_date" name="analytic_start_date" type="hidden" value="<?php echo esc_attr(date('d-')) . esc_attr(date("m", strtotime("-1 month"))) . '-' . esc_attr(date("Y", strtotime("-1 month"))); ?>" />
                <input id="analytic_end_date"  name="analytic_end_date" type="hidden"  value="<?php echo esc_attr(date('d-m-Y')); ?>"/>

                <div id="arp_range_datepicker" class="pull-right" style="background: #fff; cursor: pointer; padding: 13px 10px;  width: 100%;z-index:999999;box-sizing: border-box;">
                <div class="arp_analytics_date_icon"></div>&nbsp;
                    <span><?php
                        $last_month = date("M", strtotime("-1 month"));
                        echo esc_attr($last_month) . ',' . esc_attr(date('d'))
                        ?> - <?php echo esc_attr(date('M,d')); ?></span> <b class="caret"></b>
                <div class="fas fa-angle-down fa-lg" style="margin-left: 4px;"></div>
                </div>
            </div>

            <div class="arprice_analytic_content">
                <?php $arpchart_style = ''; if(is_rtl()){ $arpchart_style = 'style="direction: ltr;"'; } ?>
                <div class="arprice_basic_area" id="arprice_basic_area" <?php echo esc_attr($arpchart_style); ?> >
                </div>
                <div class="arp_chart_devider">
                </div>
                <div class="arprice_donut_chart" id="arprice_donut_chart" <?php echo esc_attr($arpchart_style); ?> >
                </div>  
            </div>
            <div class="clear"></div>
            <div class="arp_chart_title">
                <div class='arp_chart_title_1'><?php esc_html_e('Visits & Clicks', 'ARPrice'); ?></div>
                <div class='arp_chart_title_2'><?php esc_html_e('Country Wise Visit', 'ARPrice'); ?></div>
            </div>
            <div class="arp_analytic_devider"></div>
            <div class="arp_analytic_table_box">
                <div class="arp_analytic_table_title"><?php esc_html_e('Visitor Listing', 'ARPrice'); ?></div>
                <div class="arprice_analytic_table" id="arprice_analytic_table">
                </div>
                
            </div>
        </div>

        <div class="arprice_restrict_analytic" id="arprice_restrict_analytic" style="display:none;">
            <?php $admin_css_url = admin_url('admin.php?page=arp_global_settings'); ?>
            <span id="arp_nodata_msg"><?php esc_html_e('You are using Unlicensed Copy. To enable this feature, Please activate license from', 'ARPrice'); ?><a href="<?php echo esc_url($admin_css_url); ?>"><?php esc_html_e('here', 'ARPrice'); ?></a></span>
        </div>

        <div class="arprice_blank_analytic" id="arprice_blank_analytic" style="display:none;">
            <span id="arp_nodata_msg"><?php esc_html_e('There is no visits for this template', 'ARPrice'); ?></span>
        </div>
        <div class="arprice_analytic_loader" id="arprice_analytic_loader" style="display:none;">
        </div> 

        <script type="text/javascript" language="javascript">
            jQuery(document).ready(function () {
                var arpopens = "left";
                if(jQuery('body').hasClass('rtl')){
                    arpopens = "right";
                }
                startdate = jQuery('#analytic_start_date').val();
                enddate = jQuery('#analytic_end_date').val();
                jQuery('#arp_range_datepicker').daterangepicker({
                    locale: {
                        format: 'DD-MM-YYYY'
                    },
                    startDate: startdate,
                    endDate: enddate,
                    opens: arpopens
                }, function (start, end, label) {

                    jQuery('#analytic_start_date').val(start.format('DD-MM-YYYY'));
                    jQuery('#analytic_end_date').val(end.format('DD-MM-YYYY'));
                    if (jQuery('.arp_daily_weekly_box button#daily_button').hasClass('arp_daily_weekly_button_hover') == 1)
                    {
                        arp_action = 'arp_get_basic_area_daily';
                        var arp_analytic_nonce = jQuery("#arp_template_listing_daily_nonce").val();
                    }
                    else
                    {
                        arp_action = 'arp_get_basic_area_weekly';
                        var arp_analytic_nonce = jQuery("#arp_template_listing_nonce").val();
                    }
                    jQuery('#arp_range_datepicker span').html(start.format('MMM, D ') + ' - ' + end.format('MMM, D '));
                    var template_id = jQuery('#arp_analytic_template_id').val();
                    var start_date = jQuery('#analytic_start_date').val();
                    var end_date = jQuery('#analytic_end_date').val();
                    var ajaxurl = jQuery("#ajaxurl").val();
                   
                    jQuery.ajax({
                        url: ajaxurl,
                        method: 'POST',
                        data: {
                            action: arp_action,
                            template_id: template_id,
                            start_date: start_date,
                            end_date: end_date,
                            arp_analytic_nonce: arp_analytic_nonce,
                        },
                        dataType: 'json',
                        success: function (result) {
                            jQuery('#arprice_basic_area').html('');
                            jQuery('#arprice_basic_area').highcharts(result.browser);
                            jQuery('.arp_views_count').html('');
                            jQuery('.arp_click_count').html('');
                            jQuery('.arp_conversion_count').html('');
                            jQuery('.arp_views_count').html(result.browser.no_of_views);
                            jQuery('.arp_click_count').html(result.browser.no_of_clicks);
                            jQuery('.arp_conversion_count').html(result.browser.conversion + ' %');
                        }
                    });

                });
                jQuery('.daterangepicker').attr('style', '');
                jQuery('.daterangepicker').css('z-index', '11111111');
            });
        </script>
    </div>
</div>
<?php
    }
}

global $arprice_pro_listing_page;
$arprice_pro_listing_page = new arprice_pro_listing_page();