<?php

if ( ! defined( 'ABSPATH' ) ) { exit; }

function arp_my_function_admin_bar() {
    return false;
}

add_filter('show_admin_bar', 'arp_my_function_admin_bar');
?>
<!DOCTYPE html>

<html <?php language_attributes(); ?>>

    <head>

        <meta charset="<?php bloginfo('charset'); ?>" />

        <title><?php bloginfo('name'); ?></title>

        <?php
        global $arp_pricingtable, $arprice_version,$arpricemain;

        $arp_pricingtable->set_front_css();
        $arp_pricingtable->set_front_js();

        $upload_main_url = PRICINGTABLE_UPLOAD_URL . '/css';

        wp_print_scripts();
        $arp_disabled_fonts = (get_option('disable_font_loading_icon')) ? get_option('disable_font_loading_icon') : array();

        /** material design icon */
        $is_enable_material_design_icon = $arpricemain->arprice_get_settings('enable_material_design_icon','general_settings');

        if( empty( $is_enable_material_design_icon )){

            $is_enable_material_design_icon = !in_array('enable_material_design_icon', $arp_disabled_fonts);

            if( $is_enable_material_design_icon ){
                $is_enable_material_design_icon = 'enable_material_design_icon';
            }
        }

        /** fontawesome design icon */
        $is_enable_fontawesome_icon = $arpricemain->arprice_get_settings('enable_fontawesome_icon','general_settings');
 
 

        /** enable_ionicons design icon */
        $is_enable_ionicons = $arpricemain->arprice_get_settings('enable_ionicons','general_settings');

        if( empty( $is_enable_ionicons )){

            $is_enable_ionicons = !in_array('enable_ionicons', $arp_disabled_fonts);

            if( $is_enable_ionicons ){
                $is_enable_ionicons = 'enable_ionicons';
            }
        }

        /** enable_typicons design icon */
        $is_enable_typicons = $arpricemain->arprice_get_settings('enable_typicons','general_settings');

        if( empty( $is_enable_typicons )){

            $is_enable_typicons = !in_array('enable_typicons', $arp_disabled_fonts);

            if( $is_enable_typicons ){
                $is_enable_typicons = 'enable_typicons';
            }
        }

        ?>
        <?php 
            if($is_enable_fontawesome_icon == '1'){
                echo '<link rel="stylesheet" href="'.esc_url(PRICINGTABLE_URL) . '/css/font-awesome.css?ver=' . esc_attr($arprice_version).'" type="text/css" > ';
            }

            if( $is_enable_material_design_icon == 'enable_material_design_icon'){
                echo '<link rel="stylesheet" href="'.esc_url(PRICINGTABLE_URL) . '/css/material-design-iconic-font.css?ver='. esc_attr($arprice_version).'" type="text/css" />';
            }
            if( $is_enable_ionicons == 'enable_ionicons'){
                echo '<link rel="stylesheet" href="'.esc_url(PRICINGTABLE_URL) . '/css/ionicons.min.css?ver='. esc_attr($arprice_version).'" type="text/css" />';
            }
            if( $is_enable_typicons == 'enable_typicons' ){
                echo '<link rel="stylesheet" href="'.esc_url(PRICINGTABLE_URL) . '/css/typicons.min.css?ver=' . esc_attr($arprice_version).'" type="text/css" />';
            }


         ?>
              
         <link rel="stylesheet" href="<?php echo esc_url(PRICINGTABLE_URL) . '/css/arprice_front.css?ver=' . esc_attr($arprice_version); ?>" type="text/css"> 
        <link rel="stylesheet" href="<?php echo esc_url(PRICINGTABLE_URL) . '/fonts/arp_fonts.css?ver=' . esc_attr($arprice_version); ?>" type="text/css">
        
        <link rel="stylesheet" href="<?php echo esc_url(PRICINGTABLE_URL) . '/css/arprice_effects.css?ver=' . esc_attr($arprice_version); ?>" type="text/css" />

        <style type="text/css">
            input, select, textarea { outline:none; }
            body{ padding:20px; }
            .bestPlanButton{
                cursor:pointer;
            }
            .bestPlanRowButton{
                cursor:pointer;
            }
            html{
                float:left;
                width:100%;
                height:auto;
                padding-top:0px;
            }
            
            .arp_body_content
            {
                background:none; 
                background-color:#FFFFFF; 
                padding:20px 30px 20px 30px; 
                margin:5px 0 25px 0; 
                width:100%;
                -webkit-box-sizing: border-box;
                -moz-box-sizing: border-box;
                -o-box-sizing:border-box;
                box-sizing: border-box;
                float:left;
                height:auto;

            }
            <?php
            global $arpricemain;
            $mobile_size = !empty( $arpricemain->arprice_get_settings('arp_mobile_responsive_size','general_settings')) ? $arpricemain->arprice_get_settings('arp_mobile_responsive_size','general_settings') : get_option('arp_mobile_responsive_size');
            $tablet_size = !empty( $arpricemain->arprice_get_settings('arp_tablet_responsive_size','general_settings')) ? $arpricemain->arprice_get_settings('arp_tablet_responsive_size', 'general_settings') : get_option('arp_tablet_responsive_size');
            echo "@media screen and (min-width:" . (esc_attr($mobile_size) + 1) . "px) and (max-width:" . esc_attr($tablet_size) . "px){
	            .arp_body_content{ padding: 20px 15px 20px 15px; 	}
            }";
            ?>
            
        </style>
    </head>

    <body class="arp_body_content">
        
        <?php
        
        require_once PRICINGTABLE_DIR . '/core/views/arprice_front.php';
        $pricetable_name = isset( $pricetable_name ) ? $pricetable_name : '';
        if (isset($_REQUEST['home_view']) && $_REQUEST['home_view'] == '1') {
            $contents = arp_get_pricing_table_string($table_id, $pricetable_name, 2);
        } else {
            $contents = arp_get_pricing_table_string($table_id, $pricetable_name, 1);
        }

        $contents = apply_filters('arp_predisplay_pricingtable', $contents, $table_id);

        echo $contents;//phpcs:ignore

        wp_print_scripts('arp_tooltip_front');

        wp_print_scripts('arp_animate_numbers');
        ?>
        <link rel="stylesheet" type="text/css" href="<?php echo esc_url(PRICINGTABLE_URL) . '/css/tipso.min.css?ver=' . esc_attr($arprice_version); ?>" />
        <link rel="stylesheet"  href="<?php echo esc_url(PRICINGTABLE_URL) . '/css/arprice_effects.css?ver=' . esc_attr($arprice_version); ?>" type="text/css" />
        <?php
        if (isset($opts)) {
            $googlemap = 0;
            if ($opts['columns']) {
                foreach ($opts['columns'] as $columns) {
                    $html_content_shortcode = $columns['arp_header_shortcode'];
                    $html_content_sceond_shortcode = $columns['arp_header_shortcode_sceond'];
                    $html_content_third_shortcode = $columns['arp_header_shortcode_third '];
                    if (preg_match('/arp_googlemap/', $html_content_shortcode))
                        $googlemap = 1;
                    if (preg_match('/arp_googlemap/', $html_content_sceond_shortcode))
                        $googlemap = 1;
                    if (preg_match('/arp_googlemap/', $html_content_third_shortcode))
                        $googlemap = 1;
                }
            }

            if ($googlemap) {
                if(is_ssl()){
                ?>
                    <script type="text/javascript" language="javascript" src="https://maps.google.com/maps/api/js?sensor=false"></script>
                <?php } else { ?>
                    <script type="text/javascript" language="javascript" src="http://maps.google.com/maps/api/js?sensor=false"></script>
                <?php } ?>
                <script type="text/javascript" language="javascript" src="<?php echo esc_url(PRICINGTABLE_URL) . '/js/jquery.gomap-1.3.2.min.js?ver=' . esc_attr($arprice_version); ?>"></script> 
                <?php
            }
        }
        ?>
    </body>

</html>