<?php

class arp_fusion_builder_elements{
    function __construct(){

        add_action('fusion_builder_enqueue_live_scripts' ,array($this, 'arp_load_style'), 10);
        add_action('fusion_builder_admin_scripts_hook',array($this, 'arp_load_style'), 10);
        
        add_action( 'fusion_builder_before_init', array( $this, 'fusion_builder_elements_map') );
    }

    function arp_load_style()
    {
        global $arprice_version;
        wp_register_style( 'arprice_fusion_css', '/wp-content/plugins/arprice/integrations/fusion/css/fusion_builder.css'  , array() ,$arprice_version);
        wp_enqueue_style('arprice_fusion_css');
    }

    function fusion_builder_elements_map(){
        global $arprice_version, $wpdb;
        $table_name = $wpdb->prefix. 'arp_arprice';
		$arprice_data = $wpdb->get_results( 'SELECT * FROM `' . $table_name . "` WHERE is_template=0 ORDER BY id DESC" );//phpcs:ignore
        $arprice_list = array();
		$n                       = 0;

		foreach ( $arprice_data as $k => $value ) {
            $arprice_list['']            = esc_html__("Please Select Pricing Table",'ARPrice');
			$arprice_list[$value->ID]    =  $value->table_name  . ' (id: ' . $value->ID . ')';
			
		}

        fusion_builder_map(
            fusion_builder_frontend_data(

                'arprice_fusion_elements',
                [
                    'name'                     => esc_html__( 'ARPrice', 'ARPrice' ),
                    'shortcode'                => 'ARPrice',
                    'icon'                     => 'arprice-logo',
                    'tab'                 => 'ARPrice',
                    'params'                   => [
                        [
                            'type'        => 'select',
                            'heading'     => esc_html__( 'Table', 'ARPrice' ),
                            'param_name'  => 'id',
                            'value'       => $arprice_list,
                        ],
                        [
                            'type'        => 'hidden',
                            'param_name'  => 'is_fusionbuilder',
                            'value'       => true,
                        ],
                    ],
                ]
            )
        );
    }
}
global $arp_fusion_builder_elements;
$arp_fusion_builder_elements = new arp_fusion_builder_elements();

?>