function arprice_get_form_list() {
	for (var e = [{ label: wp.i18n.__("Please select a table", "arprice"), value: "" }], t = 0; t < arprice_gutenberg_script_objects.arprice_table_list.length; t++) {
		var r = arprice_gutenberg_script_objects.arprice_table_list[t];
		e.push({ label: r.label, value: r.id });
	}
	return e;
}

jQuery(document).on('click', '.button_switch_box', function() {
    
    var template_id = jQuery(this).parents('.arp_template_main_container').attr('data-arp-template');
    var template_uniq_id = jQuery(this).parents('.arp_template_main_container').attr('data-arp-uniq-id');
    template_id = template_id+"_"+template_uniq_id;
    jQuery('.' + template_id).find('.button_switch_box').removeClass('selected');
    jQuery(this).addClass('selected');
    var value = jQuery(this).attr('data-value');
    var current_val = jQuery('.' + template_id).find('input.switch_front_radio_btn').val();
    var switch_width = JSON.parse(jQuery(this).parents('.arp_inner_wrapper_all_columns').find('#toggle_switch_width').val());
    var enable_switch = jQuery(this).attr('data-total');
    var left_pos = switch_width[enable_switch][jQuery(this).attr('data-count')];
    jQuery(this).parents('.toggle_content_switches').find('.button_switch_box').removeClass('selected');
    jQuery(this).parents('.toggle_content_switches').find('.button_switch_box[data-count="' + jQuery(this).attr('data-count') + '"]').addClass('selected');
    jQuery(this).parents('.toggle_content_switches').find('.button_switch_box.button_switch_box_selected').css('left', left_pos);
    
    if (current_val != value) {
        jQuery('.' + template_id).find('input.switch_front_radio_btn').val(value);
        arprice_toggle_content('.' + template_id + ' input.switch_front_radio_btn', current_val);
    }
    var text = jQuery(this).html();
    var id = jQuery(this).attr('id');
    arp_toggle_mobile_view_dropdown(text, id, template_id);
});

function arp_button_height_responsive() {
    var arp_button_array = ["arptemplate_5","arptemplate_20","arptemplate_21","arptemplate_26"];

    var template_container = document.getElementsByClassName('arp_template_main_container');
    var total_templates = template_container.length;

    for( var t = 0; t < total_templates; t++ ){
        
        var current_template = template_container[t];
        var reference_template = current_template.getAttribute('data-reference-template');

        if( arp_button_array.indexOf(reference_template) > -1 ){
            var arp_columns = current_template.querySelectorAll('.ArpPricingTableColumnWrapper:not(.column_highlight)');
            var total_cols = arp_columns.length;

            for( var c = 0; c < total_cols; c++ ){
                var current_col = arp_columns[c];
                var col_button = current_col.querySelector('.arpplan.arp_col_toggle_selected .bestPlanButton:not(.bestPlanRowButton)');
                col_button.style.height = 'auto';
            }

            var max_height = 0;

            for( var c = 0; c < total_cols; c++ ){
                var current_col = arp_columns[c];
                var col_button = current_col.querySelector('.arpplan.arp_col_toggle_selected .bestPlanButton:not(.bestPlanRowButton)');

                var new_height = jQuery(col_button).height();
                if( new_height && max_height < new_height ){
                    max_height = new_height;
                }
            }

            for( var c = 0; c < total_cols; c++ ){
                var current_col = arp_columns[c];
                var col_button = current_col.querySelector('.arpplan.arp_col_toggle_selected .bestPlanButton:not(.bestPlanRowButton)');
                col_button.style.height = max_height + 'px';
                var col_btn_wrap = current_col.querySelector('.arpplan.arp_col_toggle_selected .arpcolumnfooter');
                col_btn_wrap.style.height = max_height + 'px';
            }

        }
    }

    setTimeout(function(){
        arp_column_wrapper_height();
		arp_load_js_onready();
    },1200);
    
}

function arp_redirect(unique_id, re_url, is_new_tab, is_new_window, is_script, object, template_id, column_id) {
    var template_obj = jQuery('.arp_template_main_container[data-arp-uniq-id="'+unique_id+'"]');
    var plan_id = jQuery('#' + column_id).attr('data-order');
    var column_id_new = column_id.replace('main_', '');
    var is_preview = jQuery(object).parents('.arp_template_main_container').attr('data-table-preview');
    var is_enable_alytics = jQuery(object).parents('.arp_template_main_container').attr('data-enable-analytics');
    var ajaxurl_value = jQuery('#arp_ajaxurl').val();
    if (jQuery('#main_column_0').hasClass('maincaptioncolumn')) {
        var caption_column = 1;
    } else {
        var caption_column = 0;
    }

    if (is_preview == 0) {

        var patt1 = /^#*/g; 
        var result = re_url.match(patt1);
        if(result!=''){
            if(re_url!="#"){
                if(jQuery(re_url).length != 0){
                    jQuery('html,body').animate(
                        {scrollTop: jQuery(re_url).offset().top},'slow'
                    );    
                }
                return false;
            }
        }

        if (is_enable_alytics == 0) {
            arprice_redirection_handler(is_script, object, re_url, is_new_tab, is_new_window);
            return false;
        }

        var is_new_tab_window = false;
        if( is_new_tab == 1 || is_new_window == 1 ){
            is_new_tab_window = true;
            arprice_redirection_handler(is_script, object, re_url, is_new_tab, is_new_window);
        }


        if(jQuery(template_obj).attr('data-enable-loader') == 'arp_enable_loader'){
            jQuery(template_obj).find('.arp_template_loader_continer').addClass('arp_loader_activate');
            jQuery('html').addClass('arp_no_scroll');
        }

        if( jQuery('.arp_template_main_container[data-arp-uniq-id="'+unique_id+'"] #'+column_id).hasClass('arp_clicked_column') ){
            jQuery(template_obj).find('.arp_template_loader_continer').removeClass('arp_loader_activate');
            jQuery('html').removeClass('arp_no_scroll');
            return false;
        } else {
            jQuery('.arp_template_main_container[data-arp-uniq-id="'+unique_id+'"] #'+column_id).addClass('arp_clicked_column');
        }

        jQuery.ajax({
            url: ajaxurl_value,
            type: 'POST',
            data: 'action=arp_insert_plan_id&arp_template_id=' + template_id + '&arp_plan_id=' + plan_id + '&caption_column=' + caption_column,
            statusCode: {
                401: function() {
                    if(jQuery('.arp_template_loader_continer').hasClass('arp_loader_activate')){
                        jQuery('.arp_template_loader_continer').removeClass('arp_loader_activate');
                        jQuery('html').removeClass('arp_no_scroll');
                    }
                    if( !is_new_tab_window ){
                        arprice_redirection_handler(is_script, object, re_url, is_new_tab, is_new_window);
                        jQuery('.arp_template_main_container[data-arp-uniq-id="'+unique_id+'"] #'+column_id).removeClass('arp_clicked_column');
                    }
                },
                403: function() {
                    if(jQuery('.arp_template_loader_continer').hasClass('arp_loader_activate')){
                        jQuery('.arp_template_loader_continer').removeClass('arp_loader_activate');
                        jQuery('html').removeClass('arp_no_scroll');
                    }
                    if( !is_new_tab_window ){
                        arprice_redirection_handler(is_script, object, re_url, is_new_tab, is_new_window);
                        jQuery('.arp_template_main_container[data-arp-uniq-id="'+unique_id+'"] #'+column_id).removeClass('arp_clicked_column');
                    }
                },
                400: function() {
                    if(jQuery('.arp_template_loader_continer').hasClass('arp_loader_activate')){
                        jQuery('.arp_template_loader_continer').removeClass('arp_loader_activate');
                        jQuery('html').removeClass('arp_no_scroll');
                    }
                    if( !is_new_tab_window ){
                        arprice_redirection_handler(is_script, object, re_url, is_new_tab, is_new_window);
                        jQuery('.arp_template_main_container[data-arp-uniq-id="'+unique_id+'"] #'+column_id).removeClass('arp_clicked_column');
                    }
                },
                404: function() {
                    if(jQuery('.arp_template_loader_continer').hasClass('arp_loader_activate')){
                        jQuery('.arp_template_loader_continer').removeClass('arp_loader_activate');
                        jQuery('html').removeClass('arp_no_scroll');
                    }
                    if( !is_new_tab_window ){
                        arprice_redirection_handler(is_script, object, re_url, is_new_tab, is_new_window);
                        jQuery('.arp_template_main_container[data-arp-uniq-id="'+unique_id+'"] #'+column_id).removeClass('arp_clicked_column');
                    }
                },
                500: function() {
                    if(jQuery('.arp_template_loader_continer').hasClass('arp_loader_activate')){
                        jQuery('.arp_template_loader_continer').removeClass('arp_loader_activate');
                        jQuery('html').removeClass('arp_no_scroll');
                    }
                    if( !is_new_tab_window ){
                        arprice_redirection_handler(is_script, object, re_url, is_new_tab, is_new_window);
                        jQuery('.arp_template_main_container[data-arp-uniq-id="'+unique_id+'"] #'+column_id).removeClass('arp_clicked_column');
                    }
                }
            },
            success: function() {
                if(jQuery('.arp_template_loader_continer').hasClass('arp_loader_activate')){
                    jQuery('.arp_template_loader_continer').removeClass('arp_loader_activate');
                    jQuery('html').removeClass('arp_no_scroll');
                }
                if( !is_new_tab_window ){
                    arprice_redirection_handler(is_script, object, re_url, is_new_tab, is_new_window);
                    jQuery('.arp_template_main_container[data-arp-uniq-id="'+unique_id+'"] #'+column_id).removeClass('arp_clicked_column');
                }
            },
            error: function() {
                if(jQuery('.arp_template_loader_continer').hasClass('arp_loader_activate')){
                    jQuery('.arp_template_loader_continer').removeClass('arp_loader_activate');
                    jQuery('html').removeClass('arp_no_scroll');
                }
                if( !is_new_tab_window ){
                    arprice_redirection_handler(is_script, object, re_url, is_new_tab, is_new_window);
                    jQuery('.arp_template_main_container[data-arp-uniq-id="'+unique_id+'"] #'+column_id).removeClass('arp_clicked_column');
                }
            },
        });
    } else {
        if (is_script == 1) {
            jQuery(object).parent().find('.arp_paypal_form').find('form').submit();
            jQuery(object).parent().find('.arp_paypal_form').find('button').trigger('click');
            jQuery(object).parent().find('.arp_paypal_form').find('input[type="button"]').trigger('click');
            jQuery(object).parent().find('.arp_paypal_form').find('input[type="submit"]').trigger('click');
            if (jQuery(object).parent().find('.arp_paypal_form').find('a').attr('href') != '#' && jQuery(object).parent().find('.arp_paypal_form').find('a').attr('href') != 'javascript:void(0)' && typeof(jQuery(object).parent().find('.arp_paypal_form').find('a').attr('href')) != 'undefined') {
                var a_href = jQuery(object).parent().find('.arp_paypal_form').find('a').attr('href');
                if (a_href.charAt(0) != '#') {
                    location.href = a_href;
                } else {
                    jQuery(object).parent().find('.arp_paypal_form').find('a').trigger('click');
                }
            } else {
                jQuery(object).parent().find('.arp_paypal_form').find('a').trigger('click');
            }
        } else {
            var is_extra_post = jQuery(object).attr('data-is-post-variables');
            var post_variables = jQuery(object).attr('data-post-variables');
            if(post_variables!=undefined || post_variables!=null)
            {
                post_variables = post_variables.replace(/:/g, '=');
                post_variables = post_variables.replace(/;/g, '&');
                post_variables = post_variables.replace(/&+$/, '');
            }
            var hash_pattern = /(#)/g;
        
            if (re_url.indexOf(post_variables) < 0) {
                if (re_url != "#" && re_url != "" && !hash_pattern.test(re_url)) {
                    if (re_url.indexOf('?') > -1) {
                        if (post_variables != '') re_url = re_url + '&' + post_variables;
                        else re_url = re_url;
                    } else {
                        if (post_variables != '') re_url = re_url + '?' + post_variables;
                        else re_url = re_url;
                    }
                } else if( hash_pattern.test(re_url) || re_url.indexOf('#') > -1 ){
                    var new_re_url = re_url.split('#');
                    var n_re_url = new_re_url[0];
                    var n_hs_url = new_re_url[1];
                    if (re_url.indexOf('?') > -1) {
                        if (post_variables != ''){
                            re_url = n_re_url + '&' + post_variables + '#' + n_hs_url;
                        } else {
                            re_url = n_re_url + '#' + n_hs_url;
                        } 
                    } else {
                        if (post_variables != '' && re_url!='#'){
                            re_url = n_re_url + '?' + post_variables + '#' + n_hs_url;
                        } else {
                            re_url = n_re_url + '#' + n_hs_url;
                        }
                    }
                }
            }

            var hash_link = false;
            var qry_str_pattern = /^\?/;

            if (!/^https?:\/\//i.test(re_url) && re_url != "#" && re_url != "") {
                if(qry_str_pattern.test(re_url.trim())){
                    hash_link = true;
                    re_url = "#";    
                } else{
                    re_url = "http://" + re_url;    
                }
            }
            
            if (is_new_tab == '1' || (is_new_window == '1' && is_new_tab == '1')) {} else if (is_new_window == '1' && is_new_tab != '1') {} else {
                location.href = re_url;
            }
        }
    }
}

function arprice_redirection_handler(is_script, object, re_url, is_new_tab, is_new_window) {

    if (is_script == 1) {     
        var indexButton = jQuery(object).parent().find('.arp_paypal_form').find('button').first().index();
        var indexForm = jQuery(object).parent().find('.arp_paypal_form').find('form').index();
        var indexa = jQuery(object).parent().find('.arp_paypal_form').find('a').first().index();
        var indexInput = jQuery(object).parent().find('.arp_paypal_form').find('input[type="button"]').first().index();
        var link_pattern = /javascript:void\(0\)(|;)/gi;

        if (indexa == -1) {
            if (indexButton < indexForm && indexButton > -1) {
                jQuery(object).parent().find('.arp_paypal_form').find('button').first().trigger('click');
            } else if (indexForm > -1 && indexForm < indexButton) {
                jQuery(object).parent().find('.arp_paypal_form').find('form').submit();
            } else if (indexButton == -1 && indexForm > -1) {
                jQuery(object).parent().find('.arp_paypal_form').find('form').submit();
            } else if (indexButton > -1 && indexForm == -1) {
                jQuery(object).parent().find('.arp_paypal_form').find('button').first().trigger('click');
            } else if( indexForm == -1 && indexInput > -1 ){
                jQuery(object).parent().find('.arp_paypal_form').find('input[type="button"]').first().trigger('click');
            } else {
                let elm = jQuery(object).parent().find('.arp_paypal_form').find('*[onclick]').first();
                if( elm.length > 0 ){
                    elm.trigger('click');
                }
            }
        } else if (typeof(jQuery(object).parent().find('.arp_paypal_form').find('a').attr('href')) != 'undefined' && jQuery(object).parent().find('.arp_paypal_form').find('a').attr('href') != '#' && !link_pattern.test(jQuery(object).parent().find('.arp_paypal_form').find('a').attr('href'))) {
            var a_href = jQuery(object).parent().find('.arp_paypal_form').find('a').attr('href');
            var is_wc_button = /(add\-to\-cart\=(\d+))/gi.test(a_href);
            var isAjaxProduct = false;
            if( jQuery(object).parent().find('.arp_paypal_form').find('a').hasClass('ajax_add_to_cart') ){
                isAjaxProduct = true;
            }
            if (is_wc_button) {

                if( isAjaxProduct ){
                    jQuery(object).parent().find('.arp_paypal_form').find('a').trigger('click');
                } else {
                    location.href = a_href;
                }
            } else {
                if (a_href.charAt(0) != '#') {
                    location.href = a_href;
                } else {
                    jQuery(object).parent().find('.arp_paypal_form').find('a').trigger('click');
                }
            }
        } else {
            jQuery(object).parent().find('.arp_paypal_form').find('a').trigger('click');
        }
    } else {
        var is_extra_post = jQuery(object).attr('data-is-post-variables');
        var post_variables = jQuery(object).attr('data-post-variables');
        if(post_variables!=undefined || post_variables!=null){
            post_variables = post_variables.replace(/:/g, '=');
            post_variables = post_variables.replace(/;/g, '&');
            post_variables = post_variables.replace(/&+$/, '');
        }

        var hash_pattern = /(#)/g;

        if (re_url.indexOf(post_variables) < 0) {
            
            if (re_url != "#" && re_url != "" && !hash_pattern.test(re_url)) {
                if (re_url.indexOf('?') > -1) {
                    if (post_variables != '') re_url = re_url + '&' + post_variables;
                    else re_url = re_url;
                } else {
                    if (post_variables != '') re_url = re_url + '?' + post_variables;
                    else re_url = re_url;
                }
            } else if( hash_pattern.test(re_url) || re_url.indexOf('#') > -1 ){
                
                var new_re_url = re_url.split('#');
                var n_re_url = new_re_url[0];
                var n_hs_url = new_re_url[1];
                if (re_url.indexOf('?') > -1) {
                    if (post_variables != ''){
                        re_url = n_re_url + '&' + post_variables + '#' + n_hs_url;
                        
                    } else {
                        re_url = n_re_url + '#' + n_hs_url;
                        
                    } 
                } else {
                    var btn_link = re_url;
                    
                    if (post_variables != ''){
                        if(btn_link=='#'){
                            re_url = btn_link;
                        }else{
                            re_url = n_re_url + '?' + post_variables + '#' + n_hs_url;        
                        }
                    } 
                    else {
                        re_url = n_re_url + '#' + n_hs_url;
                    }
                }
            }
        }
        if (!/^https?:\/\//i.test(re_url) && re_url != "#" && re_url != "") {
            re_url = "http://" + re_url;
        }
        if (is_new_tab == '1' || (is_new_window == '1' && is_new_tab == '1')) {
            var win = window.open(re_url, '_blank');
            win.focus();
        } else if (is_new_window == '1' && is_new_tab != '1') {
            var win = window.open(re_url, '', 'width = ' + jQuery(window).width() + ', height = ' + jQuery(window).height() + ', scrollbars = yes');
            win.focus();
        } else {
            location.href = re_url;
        }
    }
}

function responsive_json() {
    return {
        "header_level_types": {
            "type_1": ["arptemplate_9", "arptemplate_12"],
            "type_2": ["arptemplate_4"],
            "type_3": ["arptemplate_16", "arptemplate_10"],
            "type_4": ["arptemplate_6"],
            "type_5": ["arptemplate_1", "arptemplate_2", "arptemplate_3", "arptemplate_5", "arptemplate_8", "arptemplate_11", "arptemplate_13", "arptemplate_14", "arptemplate_15", "arptemplate_20", "arptemplate_21", "arptemplate_22", "arptemplate_23", "arptemplate_24", "arptemplate_25", "arptemplate_26"],
            "type_6": ["arptemplate_7", "arptemplate_5"],
            "type_7": [],
            "type_8": []
        },
        "header_title_types": {
            "type_1": ["arptemplate_1"],
            "type_2": ["arptemplate_2", "arptemplate_3", "arptemplate_4", "arptemplate_5", "arptemplate_6", "arptemplate_7", "arptemplate_8", "arptemplate_9", "arptemplate_10", "arptemplate_11", "arptemplate_12", "arptemplate_13", "arptemplate_14", "arptemplate_15", "arptemplate_16", "arptemplate_20", "arptemplate_21", "arptemplate_22", "arptemplate_23", "arptemplate_24", "arptemplate_25", "arptemplate_26"],
            "type_3": [],
            "type_4": [],
            "type_5": [],
            "type_6": [],
            "type_7": [],
            "type_8": []
        },
        "header_level_types_front_array_1": {
            "type_1": ["arptemplate_1"],
            "type_2": ["arptemplate_2", "arptemplate_3", "arptemplate_4", "arptemplate_5", "arptemplate_7", "arptemplate_8", "arptemplate_9", "arptemplate_10", "arptemplate_11", "arptemplate_12", "arptemplate_13", "arptemplate_14", "arptemplate_15", "arptemplate_16", "arptemplate_20", "arptemplate_21", "arptemplate_22", "arptemplate_24", "arptemplate_25"],
            "type_3": ["arptemplate_6", "arptemplate_23"],
            "type_4": ["arptemplate_7", "arptemplate_5"],
            "type_5": [],
            "type_6": [],
            "type_7": [],
            "type_8": []
        },
        "header_level_types_front_array_2": {
            "type_1": ["arptemplate_9",],
            "type_2": ["arptemplate_12"],
            "type_3": ["arptemplate_2", "arptemplate_3", "arptemplate_4", "arptemplate_5", "arptemplate_7", "arptemplate_8", "arptemplate_10", "arptemplate_11", "arptemplate_13", "arptemplate_14", "arptemplate_15", "arptemplate_16", "arptemplate_20", "arptemplate_21", "arptemplate_22", "arptemplate_24", "arptemplate_25"],
            "type_4": ["arptemplate_1"],
            "type_5": ["arptemplate_6", "arptemplate_23"],
            "type_6": ["arptemplate_7", "arptemplate_5"],
            "type_7": [],
            "type_8": []
        },
        "column_wrapper_height": {
            "type_1": ["arptemplate_6"],
            "type_2": ["arptemplate_1", "arptemplate_2", "arptemplate_3", "arptemplate_4", "arptemplate_5", "arptemplate_7", "arptemplate_8", "arptemplate_9", "arptemplate_10", "arptemplate_11", "arptemplate_12", "arptemplate_13", "arptemplate_14", "arptemplate_15", "arptemplate_16", "arptemplate_20", "arptemplate_21", "arptemplate_22", "arptemplate_23", "arptemplate_24", "arptemplate_25"],
            "type_3": [],
            "type_4": [],
            "type_5": [],
            "type_6": [],
            "type_7": [],
            "type_8": []
        },
        "price_wrapper_types": {
            "type_1": ["arptemplate_2", "arptemplate_11", "arptemplate_3", "arptemplate_8", "arptemplate_10", "arptemplate_13", "arptemplate_14", "arptemplate_16", "arptemplate_23", "arptemplate_21", "arptemplate_22", "arptemplate_5"],
            "type_2": ["arptemplate_7"],
            "type_3": ["arptemplate_9", "arptemplate_15", "arptemplate_20" ,"arptemplate_6"],
            "type_4": [],
            "type_5": ["arptemplate_1"],
            "type_6": [],
            "type_7": [],
            "type_8": []
        },
        "price_level_types": {
            "type_1": ["arptemplate_1", "arptemplate_4", "arptemplate_12", "arptemplate_5", "arptemplate_7", "arptemplate_11", "arptemplate_9", "arptemplate_22", "arptemplate_24"],
            "type_2": ["arptemplate_2", "arptemplate_3", "arptemplate_8", "arptemplate_10", "arptemplate_13", "arptemplate_14", "arptemplate_15", "arptemplate_16", "arptemplate_20", "arptemplate_21", "arptemplate_23", "arptemplate_25"],
            "type_3": ["arptemplate_11", "arptemplate_6"],
            "type_4": ["arptemplate_22", "arptemplate_24"],
            "type_5": [],
            "type_6": [],
            "type_7": [],
            "type_8": []
        },
        "price_label_level_types": {
            "type_1": ["arptemplate_4", "arptemplate_12", "arptemplate_5", "arptemplate_7", "arptemplate_11", "arptemplate_6", "arptemplate_9", "arptemplate_22", "arptemplate_24"],
            "type_2": ["arptemplate_1", "arptemplate_2", "arptemplate_3", "arptemplate_8", "arptemplate_10", "arptemplate_13", "arptemplate_14", "arptemplate_15", "arptemplate_16", "arptemplate_20", "arptemplate_21", "arptemplate_23", "arptemplate_25"],
            "type_3": [],
            "type_4": ["arptemplate_22", "arptemplate_24"],
            "type_5": [],
            "type_6": [],
            "type_7": [],
            "type_8": []
        },
        "body_li_level_types": {
            "type_1": ["arptemplate_8", "arptemplate_10"],
            "type_2": [],
            "type_3": [],
            "type_4": [],
            "type_5": [],
            "type_6": [],
            "type_7": [],
            "type_8": []
        },
        "column_description_types": {
            "type_1": ["arptemplate_1", "arptemplate_4", "arptemplate_12", "arptemplate_5", "arptemplate_8", "arptemplate_6", "arptemplate_2", "arptemplate_9", "arptemplate_14", "arptemplate_15", "arptemplate_20", "arptemplate_21", "arptemplate_22", "arptemplate_24"],
            "type_2": ["arptemplate_3", "arptemplate_7", "arptemplate_10", "arptemplate_11", "arptemplate_13", "arptemplate_16", "arptemplate_23", "arptemplate_25"],
            "type_3": [],
            "type_4": [],
            "type_5": [],
            "type_6": [],
            "type_7": [],
            "type_8": []
        },
        "button_level_types": {
            "type_1": ["arptemplate_8", "arptemplate_13", "arptemplate_11"],
            "type_2": ["arptemplate_1", "arptemplate_2", "arptemplate_3", "arptemplate_4", "arptemplate_5", "arptemplate_6", "arptemplate_7", "arptemplate_9", "arptemplate_10", "arptemplate_11", "arptemplate_12", "arptemplate_14", "arptemplate_15", "arptemplate_16", "arptemplate_20", "arptemplate_21", "arptemplate_22", "arptemplate_23", "arptemplate_24", "arptemplate_25"],
            "type_3": [],
            "type_4": [],
            "type_5": [],
            "type_6": [],
            "type_7": [],
            "type_8": []
        },
        "slider_types": {
            "type_1": ["arptemplate_8"],
            "type_2": ["arptemplate_10"],
            "type_3": ["arptemplate_13", "arptemplate_14", "arptemplate_15"],
            "type_4": ["arptemplate_16"],
            "type_5": ["arptemplate_1", "arptemplate_2", "arptemplate_3", "arptemplate_4", "arptemplate_5", "arptemplate_6", "arptemplate_7", "arptemplate_9", "arptemplate_11", "arptemplate_12", "arptemplate_20", "arptemplate_21", "arptemplate_22", "arptemplate_23", "arptemplate_24", "arptemplate_25"],
            "type_6": [],
            "type_7": [],
            "type_8": []
        }
    }
}

function slider(template_type, items_visible, scroll_items, is_mobile) {
    var items = '';
    var scroll = '';
    items = items_visible;
    scroll = scroll_items;
    var mobile_view = (is_mobile) ? is_mobile : 0;
    jQuery(document).find('.arp_template_main_container').each(function(e) {
        if(jQuery(this).parents('.widget_arp_widget').length){
            items = items_visible = 1;
            scroll = scroll_items = 1;
            mobile_view = 1;
        }
        if (items_visible === undefined || items_visible == '') items = '';
        if (scroll_items === undefined || scroll_items == '') scroll = '';
        var table_id = jQuery(this).find('.ArpPriceTable').attr('data-id');
        var is_animation = jQuery(this).find('.ArpPriceTable').attr('data-animate');
        var unique_id = jQuery(this).attr('data-arp-uniq-id');
        if (is_animation === 'true') {
            var duration = jQuery(this).find('.ArpPriceTable').attr('data-speed');
            var effect = jQuery(this).find('.ArpPriceTable').attr('data-effect');
            if (typeof(scroll) === 'undefined' || scroll == '') scroll = jQuery(this).find('.ArpPriceTable').attr('data-scroll');
            if (typeof(items) === 'undefined' || items == '') items = jQuery(this).find('.ArpPriceTable').attr('data-items');
            var autoplay = jQuery(this).find('.ArpPriceTable').attr('data-autoplay');
            var hide_cap = jQuery(this).find('.ArpPriceTable').attr('data-caption');
            var infinite = jQuery(this).find('.ArpPriceTable').attr('data-infinite');
            var easing = jQuery(this).find('.ArpPriceTable').attr('data-easing');
            var sticky = jQuery(this).find('.ArpPriceTable').attr('data-sticky-caption');
            if (mobile_view == 1) {
                hide_cap = 1;
                sticky = false;
            }
            if (hide_cap == 1) {
                if (jQuery(this).find('.maincaptioncolumn').length) {
                    arpmaincolumn_div = jQuery(this).find('.maincaptioncolumn').clone().wrap("<p/>").parent().html();
                    arphiddendiv = jQuery('<div class=\'arp_responsive_hidden_section\' style=\'display: none !important;\'>' + arpmaincolumn_div + '</div>');
                    jQuery('body').append(arphiddendiv);
                }
                jQuery(this).find('.maincaptioncolumn').remove();
            } else {
                if (jQuery('.arp_responsive_hidden_section').length && jQuery(this).find('.maincaptioncolumn').length <= 0) {
                    arp_getcaptioncolumn = jQuery('.arp_responsive_hidden_section').html();
                    if ((!sticky || sticky == "false")) {
                        jQuery(this).find('.arp_allcolumnsdiv').trigger('insertItem', [arp_getcaptioncolumn, 0]);
                    } else {
                        jQuery(this).find('.arp_allcolumnsdiv').prepend(arp_getcaptioncolumn);
                    }
                    jQuery('.arp_responsive_hidden_section').remove();
                }
            }
            var carouselOptions = {
                circular: (parseInt(autoplay) || sticky) ? true : false,
                items: parseInt(items),
                responsive: true,
                width: '100%',
                prev: {
                    items: parseInt(scroll),
                    button: jQuery('#arp_prev_btn_' + table_id + '_' + unique_id),
                    fx: effect,
                    easing: easing,
                    duration: parseInt(duration)
                },
                next: {
                    items: parseInt(scroll),
                    button: jQuery('#arp_next_btn_' + table_id + '_' + unique_id),
                    fx: effect,
                    easing: easing,
                    duration: parseInt(duration)
                },
                auto: {
                    items: parseInt(scroll),
                    play: (parseInt(autoplay) ? true : false),
                    fx: effect,
                    easing: easing,
                    duration: parseInt(duration)
                },
            };
            if (jQuery(this).find('.ArpPriceTable').hasClass('arp_slider_pagination')) {
                carouselOptions.pagination = {
                    items: parseInt(scroll),
                    container: jQuery('#arp_slider_' + table_id + '_paginatio_top_' + unique_id),
                    fx: effect,
                    easing: easing,
                    duration: parseInt(duration),
                }
            }

            jQuery('.arp_column_slider_width_'+table_id).remove();
            if (sticky === 'true' && mobile_view == 0) {
                if (jQuery(this).find('.arp_allcolumnsdiv_sticky').length > 0) {
                    jQuery(this).find('.arp_allcolumnsdiv_sticky').carouFredSel(carouselOptions);
                } else {
                    jQuery(this).find('.ArpPricingTableColumnWrapper:not(.maincaptioncolumn)').wrapAll('<div class=\'arp_allcolumnsdiv_sticky\' />');
                    jQuery(this).find('.arp_allcolumnsdiv_sticky').carouFredSel(carouselOptions);
                }
            } else {
                if (mobile_view == 1) {
                    if (jQuery(this).find('.arp_allcolumnsdiv_sticky').length > 0) {
                        jQuery(this).find('.arp_allcolumnsdiv_sticky').carouFredSel(carouselOptions);
                    } else {
                        jQuery(this).find('.arp_allcolumnsdiv').carouFredSel(carouselOptions);
                    }
                } else {
                    if (jQuery(this).find('.arp_allcolumnsdiv_sticky').length > 0) {
                        jQuery(this).find('.arp_allcolumnsdiv_sticky').contents().unwrap();
                    }
                    jQuery(this).find('.arp_allcolumnsdiv').carouFredSel(carouselOptions);
                }
            }
            arp_set_slider_width_new(table_id, parseInt(items), parseInt(scroll), sticky);
        }
    });
}

function arp_get_google_map_front() {
    if (jQuery('.arp_googlemap').length > 0) {
        jQuery('.arp_googlemap').each(function() {
            var map_data = jQuery(this).data('map');
            if (typeof(map_data) === 'string') map_data = JSON.parse(map_data);
            var address = map_data.markers[0].address;
            var icon = map_data.markers[0].icon;
            var title = map_data.markers[0].title;
            var zoom = map_data.zoom;
            var $this = this;
            var content = map_data.markers[0].html.content;
            var popup = map_data.markers[0].html.popup;
            var maptype = map_data.maptype;
            var google_map_api_key = map_data.api_key;
            if (icon != null) {
                icon = map_data.markers[0].icon.image;
            } else {
                icon = null;
            }
            if (zoom == null) {
                zoom = 14;
            } else {
                zoom = zoom;
            }
            jQuery.ajax({
                url: 'https://maps.googleapis.com/maps/api/geocode/json',
                type: 'GET',
                data: 'address=' + address + '&key=' + google_map_api_key,
                success: function(res) {
                    if(res.results.length > 0){
                        var lat = res.results[0].geometry.location.lat;
                        var lng = res.results[0].geometry.location.lng;
                        get_google_map_content(lat, lng, icon, $this, zoom, title, content, popup, maptype);
                    }
                }
            });
        });
    }
}

function responsive_template_width_calculation() {
    jQuery('.arp_template_main_container').each(function() {
        $this = jQuery(this);
        var container_width = $this.width();
        var columns = $this.find('.ArpPricingTableColumnWrapper:visible').length;
        var toal_columns = $this.find('.ArpPricingTableColumnWrapper').length;
        var total_hidden_column = (toal_columns - columns);
        var display_col_mobile = $this.attr('data-column-mobile');
        var display_col_tablet = $this.attr('data-column-tablet');
        var display_col_desktop = $this.attr('data-column-desktop');
        var caption = $this.find('.ArpPricingTableColumnWrapper.maincaptioncolumn:visible').length;
        var mobile_width = $this.attr('data-mobile-width');
        var tablet_width = $this.attr('data-tablet-width');
        var current_width = jQuery(window).width();
        var is_responsive = $this.attr('data-is-responsive');
        var all_column_width = $this.attr('data-all-column-width');
        var caption_custom_width = $this.find('.maincaptioncolumn').attr('data-has_custom_column_width');
        var column_space = $this.attr('data-space-columns');
        var responsive_width = $this.attr('data-responsive-width-arr');
        responsive_width = JSON.parse(responsive_width);
        var desktop_width_include_space = responsive_width.with_space;
        var desktop_width_exclude_space = responsive_width.no_space;
        var width_inc_space = desktop_width_include_space[0];
        var width_exc_space = desktop_width_exclude_space[0];
        if (total_hidden_column > 0) {
            var width_exc_space_without_par = width_exc_space.replace('%', '');
            width_exc_space_without_par = parseInt(width_exc_space_without_par);
            var tot_wid = (width_exc_space_without_par * toal_columns);
            width_exc_space = tot_wid / columns + '%';
            var width_inc_space_without_par = width_inc_space.replace('%', '');
            width_inc_space_without_par = parseInt(width_inc_space_without_par);
            var tot_space_wid = (width_inc_space_without_par * toal_columns);
            width_inc_space = (tot_space_wid / columns) + '%';
        }
        if (current_width <= mobile_width) {
            jQuery('.arp_hidden_div').remove();
            if (is_responsive == 1) {
                if (display_col_mobile == 'All' || (display_col_mobile > columns)) {
                    display_col_mobile = columns;
                } else {
                    var container_width = $this.css('width').replace('px', '');
                    container_width = parseInt(container_width);
                    var display_cols = display_col_mobile;
                    display_cols = parseInt(display_cols);
                    if (column_space > 0) {
                        var column_width = $this.find('.ArpPricingTableColumnWrapper:visible').css('width').replace('px', '');
                        column_width = parseInt(column_width);
                        var actual_width = ((container_width / display_cols));
                        actual_width = actual_width - column_space;
                        var final_width = ((actual_width * 100) / container_width);
                        final_width = Math.floor(final_width);
                        if (display_cols == 1) {
                            final_width = 100;
                        }
                        if (caption_custom_width == 'true') {
                            $this.find('.ArpPricingTableColumnWrapper:not(.maincaptioncolumn)').css('width', final_width + '%');
                        } else {
                            $this.find('.ArpPricingTableColumnWrapper:visible').css('width', final_width + '%');
                        }
                    } else {
                        var column_width = 100 / parseInt(display_cols);
                        if (caption_custom_width == 'true') {
                            $this.find('.ArpPricingTableColumnWrapper:not(.maincaptioncolumn)').css('width', column_width + '%');
                        } else {
                            $this.find('.ArpPricingTableColumnWrapper:visible').css('width', column_width + '%');
                        }
                    }
                }
            } else {
                if (caption > 0 && caption_custom_width == 'true') {
                    $this.find('.ArpPricingTableColumnWrapper:not(.maincaptioncolumn):visible').css('width', all_column_width + 'px');
                } else {
                    $this.find('.ArpPricingTableColumnWrapper:visible').css('width', all_column_width + 'px');
                }
                $this.find('.ArpPricingTableColumnWrapper:visible').each(function(e) {
                    if ((e + 1) % display_col_mobile == 0) {
                        jQuery(this).after('<div class="arp_hidden_div" style="float:left;width:100%;clear:both;"></div>');
                    }
                });
            }
        } else if (current_width <= tablet_width && current_width > mobile_width) {
            jQuery('.arp_hidden_div').remove();
            if (is_responsive == 1) {

                if (display_col_tablet == 'All' || (display_col_tablet > columns)) {
                    display_col_tablet = columns;
                } 
                    var container_width = $this.css('width').replace('px', '');
                    container_width = parseInt(container_width);
                    var display_cols = display_col_tablet;
                    display_cols = parseInt(display_cols);
                    if (column_space > 0) {
                        var column_width = $this.find('.ArpPricingTableColumnWrapper:visible').css('width').replace('px', '');
                        column_width = parseInt(column_width);
                        var actual_width = ((container_width / display_cols));
                        actual_width = actual_width - column_space;
                        var final_width = ((actual_width * 100) / container_width);
                        final_width = Math.floor(final_width);
                        var col_space_in_perc = ((column_space * 100) / container_width);
                        var cap_col_final_width = Math.floor(final_width - col_space_in_perc);
                        if (caption_custom_width == 'true') {
                            $this.find('.ArpPricingTableColumnWrapper:not(.maincaptioncolumn)').css('width', final_width + '%');
                            $this.find('.ArpPricingTableColumnWrapper.maincaptioncolumn').css('width', cap_col_final_width + '%');
                        } else {
                            $this.find('.ArpPricingTableColumnWrapper:visible').css('width', final_width + '%');
                        }
                    } else {
                        var column_width = 100 / parseInt(display_cols);
                        if (caption_custom_width == 'true') {
                            $this.find('.ArpPricingTableColumnWrapper').css('width', column_width + '%');
                        } else {
                            $this.find('.ArpPricingTableColumnWrapper:visible').css('width', column_width + '%');
                        }
                    }
            } else {
                
                if (caption > 0 && caption_custom_width == 'true') {
                    $this.find('.ArpPricingTableColumnWrapper:not(.maincaptioncolumn):visible').css('width', all_column_width + 'px');
                } else {
                    $this.find('.ArpPricingTableColumnWrapper:visible').css('width', all_column_width + 'px');
                }
                $this.find('.ArpPricingTableColumnWrapper:visible').each(function(e) {
                    if ((e + 1) % display_col_tablet == 0) {
                        jQuery(this).after('<div class="arp_hidden_div" style="float:left;width:100%;clear:both;"></div>');
                    }
                });
            }
        } else {
            jQuery('.arp_hidden_div').remove();
            if (caption_custom_width == 'true') {
                var  default_val = $this.find('.maincaptioncolumn').attr('data-width');
                if(default_val > '0px'){
                    $this.find('.ArpPricingTableColumnWrapper').css('width',default_val);
                }else{
                    $this.find('.ArpPricingTableColumnWrapper').css('width','');
                }
                $this.find('.ArpPricingTableColumnWrapper:not(.maincaptioncolumn)').css('width', '');
            } else {
                $this.find('.ArpPricingTableColumnWrapper').css('width', '');
            }
        }
    });
}

function adjust_template_footer_height() {
    jQuery('.arp_template_main_container').each(function() {
        var is_footer_content = 0;
        jQuery(this).find('.ArpPricingTableColumnWrapper').each(function() {
            if (jQuery(this).find('.arp_btn_before_content').is(':visible') === true) {
                is_footer_content++;
            } else if (jQuery(this).find('.arp_btn_after_content').is(':visible') === true) {
                is_footer_content++;
            }
        });
        jQuery(this).find('.ArpPricingTableColumnWrapper').each(function() {
            if (is_footer_content > 0 && !jQuery(this).find('.arp_btn_before_content').is(':visible')) {
                var footer_content_position = jQuery(this).attr('data-column-footer-position');
                if (footer_content_position == 0) {
                    jQuery(this).find('.arpcolumnfooter').addClass('has_footer_content').addClass('footer_below_content');
                    jQuery(this).find('.arpcolumnfooter').find('.arp_btn_after_content').css('display', 'block');
                } else if (footer_content_position == 1) {
                    jQuery(this).find('.arpcolumnfooter').addClass('has_footer_content').addClass('footer_above_content');
                    jQuery(this).find('.arpcolumnfooter').find('.arp_btn_before_content').css('display', 'block');
                }
            }
        });
        if (is_footer_content > 0) {
            jQuery(this).find('.ArpPricingTableColumnWrapper.maincaptioncolumn').find('.arpcolumnfooter').addClass('has_footer_content');
        }
    });
}

function remove_column_height() {

    var template_main = document.getElementsByClassName('arp_template_main_container');
    var total_main_temp = template_main.length;

    for( var i = 0; i < total_main_temp; i++ ){

        var current_temp = template_main[i];

        var priceWrappers = current_temp.querySelectorAll('.ArpPricingTableColumnWrapper');

        var total_wrappers = priceWrappers.length;

        for( var p = 0; p < total_wrappers; p++ ){

            var current_col = priceWrappers[p];

            if( current_col.offsetHeight > 0 && current_col.offsetWidth > 0 ){

                var listItems = current_col.querySelectorAll('li');
                var total_lis = listItems.length;

                for( var l = 0; l < total_lis; l++ ){
                    var current_list_item = listItems[l];
                    current_list_item.style.height = '';
                    current_list_item.style.minHeight = '';
                    current_list_item.style.lineHeight = '';
                    current_list_item.style.paddingTop = '';
                    current_list_item.style.paddingBottom = '';
                }

            }

        }

    }

}

function arp_hide_blank_rows() {
    
    var template_container = document.getElementsByClassName('arp_template_main_container');
    var total_container = template_container.length;

    for( var t = 0; t < total_container; t++ ){

        var current_container = template_container[t];

        var template_id = current_container.getAttribute('data-reference-template');

        var hide_blank_rows = current_container.getAttribute('data-hide-blank-rows');

        if( hide_blank_rows == 'yes' ){

            var arpColumns = current_container.querySelectorAll('.ArpPricingTableColumnWrapper .arppricingtablebodycontent');
            var total_columns = arpColumns.length;

            for( var c = 0; c < total_columns; c++ ){
                var arpColumn = arpColumns[c];
                var bodyContent = arpColumn.querySelectorAll('li:not(.arp_last_list_item)');
                var total_list = bodyContent.length;
                var j = 0;
                for( var l = (parseInt(total_list) - 1); l >= 0; l-- ){
                    var current_li = bodyContent[l];
                    arp_removeClass(current_li,'arp_hide_bottom_blank_row');
                    current_li.style.display = '';
                    if( ArpisBlank(jQuery(current_li).find('.arp_row_description_text:visible'))){
                        current_li.style.display = 'none';
                    } else {
                        current_li.style.display = '';
                        j = l;
                        break;
                    }
                }

                for( var i = 0; i < j; i++ ){
                    var current_li = bodyContent[i];
                    if( current_li.style.display == 'none' ){
                        arp_removeClass(current_li,'arp_hide_bottom_blank_row');
                        current_li.style.display = '';                        
                    }
                }
            }
        }
    }
}

function arp_load_js_onready() {
    if (jQuery('#arp_carturl').length > 0) {
        var arp_location = window.location.href;
        setTimeout(function(){
            if (arp_location.match(/add-to-cart/i) && jQuery('#arp_carturl').length) {
                location.href = jQuery('#arp_carturl').val();
                return false;
            }
        },10);
    }
    jQuery('.arp_template_main_container').each(function() {
		
        var $this = jQuery(this);
        var is_disp_tooltip = jQuery(this).attr('data-is-display-tooltip');
        if (is_disp_tooltip != 1 && is_disp_tooltip !== undefined) {
            jQuery('.ArpPricingTableColumnWrapper').tipso({
                speed: 400,
                background: '#55b555',
                titleBackground: '#333333',
                color: '#ffffff',
                titleColor: '#ffffff',
                showArrow: true,
                position: 'top',
                width: 200,
                height: 30,
                delay: 50,
                tooltipHover: true,
                content: 'Unlicensed Copy. Get your activation / Purchase code from <a href="http://codecanyon.net/item/arprice-ultimate-compare-pricing-table-plugin/10049883?ref=reputeinfosystems" target="_blank">here</a>'
            });
        }
    });

    if( jQuery('.arp_tooltip_settings').length > 0 && (navigator.userAgent.match(/iPhone/i)) || (navigator.userAgent.match(/iPod/i)) || (navigator.userAgent.match(/iPad/i)) ){
        jQuery('body').addClass('arp_tooltip_initialized');
    }
    jQuery('.arp_tooltip_settings').each(function() {
		
        var $this = jQuery(this);
        var template_id = $this.attr('data-template-id');
        var tooltip_bg_color = $this.attr('data-tooltip-bgcolor');
        var tooltip_width = $this.attr('data-tooltip-width');
        var tooltip_trigger_type = $this.attr('data-tooltip-trigger-type');
        var tooltip_color = $this.attr('data-tooltip-color');
        var tooltip_position = $this.attr('data-tooltip-position');
        var tooltip_animation_in = $this.attr('data-animation-in');
        var tooltip_animation_out = $this.attr('data-animation-out');
        var tooltip_display_style = $this.attr('data-tooltip-display-style');
        tooltip_width = (tooltip_width == 0) ? 'auto' : tooltip_width;
        if (tooltip_trigger_type === 'hover') {
			
            if (tooltip_display_style === 'default') {
                jQuery('.arp_price_table_' + template_id + '  .arp_tooltip').tipso({
                    width: parseInt(tooltip_width),
                    background: tooltip_bg_color,
                    color: tooltip_color,
                    position: tooltip_position,
                    tooltipHover: true,
                    useTitle: false,
                    onBeforeShow: function(object, tooltip, obj) {
                        jQuery(obj.tipso_bubble).addClass('arp_tooltip_' + template_id);
                        jQuery(object[0].tipso_bubble).addClass('arp_tooltip_' + template_id);
                    },
                    animationIn: tooltip_animation_in,
                    animationOut: tooltip_animation_out
                });
            } else if (tooltip_display_style === 'informative') {
                jQuery('.arp_price_table_' + template_id + ' label.arp_informative_tooltip:not(.tooltip)').tipso({
                    width: parseInt(tooltip_width),
                    background: tooltip_bg_color,
                    color: tooltip_color,
                    position: tooltip_position,
                    tooltipHover: true,
                    useTitle: false,
                    onBeforeShow: function(object, tooltip, obj) {
                        jQuery(obj.tipso_bubble).addClass('arp_tooltip_' + template_id);
                        jQuery(object[0].tipso_bubble).addClass('arp_tooltip_' + template_id);
                    },
                    animationIn: tooltip_animation_in,
                    animationOut: tooltip_animation_out
                });
            }
            jQuery(document).on('mouseout', '.arp_tooltip.on_click,.arp_tooltip_li.on_click', function(e) {
                jQuery(this).tipso('destroy');
            });
        } else if (tooltip_trigger_type === 'click') {
            if (tooltip_display_style === 'default') {
                jQuery(document).on('click', '.arp_price_table_' + template_id + ' .arp_tooltip.on_click', function(e) {
                    jQuery(this).tipso({
                        width: parseInt(tooltip_width),
                        background: tooltip_bg_color,
                        color: tooltip_color,
                        position: tooltip_position,
                        tooltipHover: true,
                        useTitle: false,
                        onBeforeShow: function(object, tooltip, obj) {
                            jQuery(obj.tipso_bubble).addClass('arp_tooltip_' + template_id);
                            jQuery(object[0].tipso_bubble).addClass('arp_tooltip_' + template_id);
                        },
                        animationIn: tooltip_animation_in,
                        animationOut: tooltip_animation_out
                    });
                    jQuery(this).tipso('show');
                });
            } else if (tooltip_display_style === 'informative') {
                jQuery(document).on('click', '.arp_price_table_' + template_id + ' label.arp_informative_tooltip.on_click', function(e) {
                    jQuery(this).tipso({
                        width: parseInt(tooltip_width),
                        background: tooltip_bg_color,
                        color: tooltip_color,
                        position: tooltip_position,
                        tooltipHover: true,
                        useTitle: false,
                        onBeforeShow: function(object, tooltip, obj) {
                            jQuery(obj.tipso_bubble).addClass('arp_tooltip_' + template_id);
                            jQuery(object[0].tipso_bubble).addClass('arp_tooltip_' + template_id);
                        },
                        animationIn: tooltip_animation_in,
                        animationOut: tooltip_animation_out
                    });
                    jQuery(this).tipso('show');
                });
            }
            jQuery(document).on('mouseout', 'label.arp_informative_tooltip.on_click,.arp_tooltip_li.on_click', function(e) {
                jQuery(this).tipso('destroy');
            });
        }
    });
    if ((navigator.userAgent.match(/iPhone/i)) || (navigator.userAgent.match(/iPod/i)) || (navigator.userAgent.match(/iPad/i))) {
        jQuery(".ArpPricingTableColumnWrapper").bind('touchstart', function() {});
    }
    var mobile_view_width = jQuery('#arp_template_main_container').attr('data-mobile-width');
    var tablet_view_width = jQuery('#arp_template_main_container').attr('data-tablet-width');
    var tablet_items = jQuery('.arp_front_main_container').find('.ArpPriceTable').attr('data-tablet-items');

    if (mobile_view_width == '') var device_width = 480;
    else var device_width = mobile_view_width;

    if (tablet_view_width == '') {
        var tablet_width = 770;
    } else {
        var tablet_width = tablet_view_width;
    }

    width = jQuery(window).width();
    var template_type = '';
    if (width < device_width) {
        jQuery('.caroufredsel_wrapper').removeAttr('style');
        slider(template_type, 1, 1, 1);
    } else if( width < tablet_width && device_width < tablet_width ){
        slider(template_type, tablet_items, 1, 0);
    }else {
        slider();
    }
    var preview = jQuery("#is_tbl_preview").val();
    if (preview == 1) {
        jQuery("span.ribbontext_1").addClass('ribbontext_preview');
        jQuery("span.ribbontext_2").addClass('ribbontext_preview');
    }
    array = new Array();
    var template = '';
    jQuery('.arp_template_main_container').each(function() {
        template = jQuery(this).attr('data-arp-template');
        jQuery('.' + template).find(".arp_allcolumnsdiv").find('.ArpPricingTableColumnWrapper').each(function(i) {
            if (jQuery(this).find('.arpplan.arp_col_toggle_selected .arpcolumnheader').hasClass('has_arp_shortcode')) array[i] = 'has_header_scode';
            else array[i] = 0;
        });
    });
    default_scode_position = new Array('arptemplate_1', 'arptemplate_12', 'arptemplate_5', 'arptemplate_11');
    position_scode_1 = new Array('arptemplate_4');
    position_scode_2 = new Array('arptemplate_3', 'arptemplate_7', 'arptemplate_8');
    if (jQuery.inArray(template, default_scode_position) > -1) {
        if (jQuery.inArray('has_header_scode', array) > -1) {
            jQuery('.' + template).find(".arp_allcolumnsdiv").find('.ArpPricingTableColumnWrapper').each(function(i) {
                jQuery(this).find('.arpplan.arp_col_toggle_selected .arpcolumnheader').addClass('has_arp_shortcode');
                div = jQuery('<div class=\'arp_header_shortcode\'></div>');
                if (!jQuery(this).find('.arpplan.arp_col_toggle_selected .arpcolumnheader').find('div').hasClass('arp_header_shortcode')) {
                    div.insertAfter(jQuery(this).find('.arpplan.arp_col_toggle_selected .arpcolumnheader').find('.arppricetablecolumntitle'));
                }
            });
        }
    } else if (jQuery.inArray(template, position_scode_1) > -1) {
        if (jQuery.inArray('has_header_scode', array) > -1) {
            jQuery('.' + template).find(".arp_allcolumnsdiv").find('.ArpPricingTableColumnWrapper').each(function(i) {
                jQuery(this).find('.arpplan.arp_col_toggle_selected .arpcolumnheader').addClass('has_arp_shortcode');
                div = jQuery('<div class=\'arp_header_shortcode\'></div>');
                if (!jQuery(this).find('.arpplan.arp_col_toggle_selected .arpcolumnheader').find('div').hasClass('arp_header_shortcode')) {
                    jQuery(this).find('.arpplan.arp_col_toggle_selected .arpcolumnheader').append(div);
                }
            });
        }
    } else if (jQuery.inArray(template, position_scode_2) > -1) {
        if (jQuery.inArray('has_header_scode', array) > -1) {
            jQuery('.' + template).find(".arp_allcolumnsdiv").find('.ArpPricingTableColumnWrapper').each(function(i) {
                jQuery(this).find('.arpcolumnheader').addClass('has_arp_shortcode');
                div = jQuery('<div class=\'arp_header_shortcode\'></div>');
                if (!jQuery(this).find('.arpplan.arp_col_toggle_selected .arpcolumnheader').find('div').hasClass('arp_header_shortcode')) {
                    jQuery(this).find('.arpplan.arp_col_toggle_selected .arpcolumnheader').prepend(div);
                }
            });
        }
    }
    if (template == 'arptemplate_8') {
        jQuery('.ArpPricingTableColumnWrapper').each(function() {
            jQuery(this).find('.arpplan.arp_col_toggle_selected div.arp_header_shortcode').css('min-height', '100px');
        });
    }
    arp_get_google_map_front();
    
    setTimeout(function() {
        remove_column_height();
        arp_hide_blank_rows();
        arp_header_title_responsive();
        arp_short_code_responsive();
        arp_price_wrapper_responsive();
        arp_column_desc_responsive();
        set_best_plan_button_height();
        arp_button_height_responsive();
        adjust_column_height();
    }, 1000);
    responsive_template_width_calculation();
    jQuery('.ArpPricingTableColumnWrapper').each(function() {
        if (jQuery(this).hasClass('column_highlight')) {
            jQuery(this).attr('has_column_highlighted', 'true');
        } else {
            jQuery(this).attr('has_column_highlighted', 'false');
        }
    });
    
    adjust_template_footer_height();
    if (width < 420) {
        jQuery('.ArpPricingTableColumnWrapper').each(function(x) {
            if ((jQuery(this).find('.arp_ribbon_container').hasClass('arp_ribbon_4') || jQuery(this).find('.arp_ribbon_container').hasClass('arp_ribbon_2')) && x > 0) {
                jQuery(this).css('margin-top', '25px');
            }
            x++;
        });
    }
}

function set_best_plan_button_height() {
    var responsive_templates = responsive_json();
    var btn_temp_obj = responsive_templates.button_level_types;

    var containers = document.getElementsByClassName('arp_template_main_container');
    var total_cons = containers.length;
    for( var t = 0; t < total_cons; t++ ){
        var container = containers[t];
        var template = container.getAttribute('data-reference-template');
        if( btn_temp_obj.type_1.indexOf(template) > -1 ){
            var btns = container.querySelectorAll('.arppricetablebutton');
            var tbtns = btns.length;
            for( var b = 0; b < tbtns; b++ ){
                var btn = btns[b];
                btn.style.height = 'auto';
            }

            var max_height = 0;
            for( var b = 0; b < tbtns; b++ ){
                var btn = btns[b];
                if( max_height < btn.offsetHeight ){
                    max_height = btn.offsetHeight;
                }
            }

            for( var b = 0; b < tbtns; b++ ){
                var btn = btns[b];
                btn.style.height = max_height + 'px';
            }

        }
    }
}

function adjust_column_height() {
    jQuery('.arp_template_main_container').each(function() {
        var $this = jQuery(this);
        var base_height = [];
        var first_id = $this.find('.ArpPricingTableColumnWrapper:visible').first().attr('id');
        var new_height = [];
        $this.find('.ArpPricingTableColumnWrapper:visible').each(function() {
            jQuery(this).find('ul.arppricingtablebodyoptions li').each(function() {
                jQuery(this).css('height', '');
            });
        });
        $this.find('.ArpPricingTableColumnWrapper:visible').first().find('ul.arppricingtablebodyoptions li:not(.arp_last_list_item)').each(function(x) {
            base_height[x] = jQuery(this).outerHeight();
        });

        $this.find('.ArpPricingTableColumnWrapper:visible:not(#' + first_id + ')').each(function(c) {
            var col_id = jQuery(this).attr('id').replace('main_column_', '');
            jQuery(this).find('ul.arppricingtablebodyoptions li:not(.arp_last_list_item)').each(function(e) {
                if (base_height[e] > jQuery(this).height()) {
                    new_height[e] = base_height[e];
                } else {
                    base_height[e] = new_height[e] = jQuery(this).height();
                }
            });
        });
        $this.find('.ArpPricingTableColumnWrapper:visible').each(function(x) {
            jQuery(this).find('ul.arppricingtablebodyoptions li:not(.arp_last_list_item)').each(function(n) {
                jQuery(this).height(new_height[n] + 'px');
            });
        });
    });
    set_slider_height();
}

function set_slider_height() {
    var responsive_templates = responsive_json();
    var slider_temp_obj = responsive_templates.slider_types;
    if (jQuery('.caroufredsel_wrapper').length > 0) {
        setTimeout(function() {
            jQuery('.arp_template_main_container').each(function() {
                var $this = jQuery(this);
                var is_slide = $this.find('.ArpPriceTable').attr('data-animate');
                if (is_slide && is_slide == 'true') {
                    var template = jQuery(this).attr('data-reference-template');
                    var slider_height = 0;
                    $this.find('.ArpPricingTableColumnWrapper:not(.maincaptioncolumn)').each(function() {
                        if (jQuery(this).is(':visible') && jQuery(this).height() && jQuery(this).height() > 0 && slider_height == 0) {
                            if (parseInt(jQuery(this).outerHeight()) > slider_height) {
                                slider_height = parseInt(jQuery(this).outerHeight()) + 50;
                            } else {
                                slider_height = jQuery('.arp_allcolumnsdiv').outerHeight() + 30;
                            }
                        }
                    });
                    if (slider_temp_obj.type_1.indexOf(template) > -1) {
                        slider_height = slider_height + 2;
                    } else if (slider_temp_obj.type_2.indexOf(template) > -1) {
                        slider_height = slider_height + 16;
                    } else if (slider_temp_obj.type_3.indexOf(template) > -1) {
                        slider_height = slider_height + 24;
                    } else if (slider_temp_obj.type_4.indexOf(template) > -1) {
                        slider_height = slider_height + 36;
                    } else if (slider_temp_obj.type_5.indexOf(template) > -1) {
                        slider_height = slider_height + 20;
                    }
                    if (slider_height > 0) {
                        jQuery('.caroufredsel_wrapper', this).height(slider_height);
                    }
                }
            });
        }, 10);
    }
}

function arp_price_wrapper_responsive() {
    var responsive_templates = responsive_json();
    var price_wrapper_temp_obj = responsive_templates.price_wrapper_types;

    var template_container = document.querySelectorAll('.arp_template_main_container:not([data-reference-template="arptemplate_4"])');
    var total_container = template_container.length;
    for( var con = 0; con < total_container; con++ ){
        var container = template_container[con];
        var template = container.getAttribute('data-reference-template');

        var cols = container.querySelectorAll('.ArpPricingTableColumnWrapper');
        var tcol = cols.length;

        for( var s = 0; s < tcol; s++ ){
            var col = cols[s];
            if( col.querySelector('.arpplan.arp_col_toggle_selected .arp_price_wrapper') != null ){
                col.querySelector('.arpplan.arp_col_toggle_selected .arp_price_wrapper').style.height = 'auto';
            }
        }

        var max_height = 0;
        for( var c = 0; c < tcol; c++ ){
            var col = cols[c];
            if( col.querySelector('.arpplan.arp_col_toggle_selected .arp_price_wrapper') != null ){
                new_height = col.querySelector('.arpplan.arp_col_toggle_selected .arp_price_wrapper').offsetHeight;
                if( new_height && max_height < new_height ){
                    max_height = new_height;
                }
            }
        }

        for( var c = 0; c < tcol; c++ ){
            var col = cols[c];
            if( col.querySelector('.arpplan.arp_col_toggle_selected .arp_price_wrapper') != null ){
                col.querySelector('.arpplan.arp_col_toggle_selected .arp_price_wrapper').style.height = max_height + 'px';
            }
        }


        if( template && price_wrapper_temp_obj.type_3.indexOf(template) > -1 ){
            for( var c = 0; c < tcol; c++ ){
                var col = cols[c];
                if( col.querySelector('.arpplan.arp_col_toggle_selected .arppricetablecolumnprice') != null ){
                    col.querySelector('.arpplan.arp_col_toggle_selected .arppricetablecolumnprice').style.height = 'auto';
                }
                if( col.querySelector('.arpplan.arp_col_toggle_selected .arpcaptiontitle') != null ){
                    col.querySelector('.arpplan.arp_col_toggle_selected .arpcaptiontitle').style.height = 'auto';
                }
            }

            var max_height = 0;
            var new_height = 0;

            for( var c = 0; c < tcol; c++ ){
                var col = cols[c];
                var classes = col.getAttribute('class');
                if( classes.indexOf('maincaptioncolumn') > -1 ){
                    new_height = col.querySelector('.arpplan.arp_col_toggle_selected .arpcaptiontitle').offsetHeight;
                } else {
                    new_height = col.querySelector('.arpplan.arp_col_toggle_selected .arppricetablecolumnprice').offsetHeight;
                }

                if( new_height && max_height < new_height ){
                    max_height = new_height;
                }

            }
            for( var c = 0; c < tcol; c++ ){
                var col = cols[c];

                if( col.querySelector('.arpplan.arp_col_toggle_selected .arppricetablecolumnprice') != null ){
                    col.querySelector('.arpplan.arp_col_toggle_selected .arppricetablecolumnprice').style.height = max_height + 'px';
                }

                if( col.querySelector('.arpplan.arp_col_toggle_selected .arpcaptiontitle') != null ){
                    col.querySelector('.arpplan.arp_col_toggle_selected .arpcaptiontitle').style.height = max_height + 'px';
                }

                if(jQuery(col).hasClass('maincaptioncolumn') && jQuery(col).find('.arpplan.arp_col_toggle_selected .arppricetablecolumnprice').is(':visible')){
                    col.querySelector('.arpplan.arp_col_toggle_selected .arppricingtablebodycontent').style.marginTop = max_height + 'px';
                }

            }
        } else if( template && price_wrapper_temp_obj.type_4.indexOf(template) > -1 ){
            var max_height = 0;
            var new_height = 0;
            var price_header = 0;
            var new_price_header = 0;
            for( var c = 0; c < tcol; c++ ){
                var col = cols[c];
                if( col.querySelector('.arpplan.arp_col_toggle_selected .arppricetablecolumntitle .bestPlanTitle') != null ){
                    new_height = col.querySelector('.arpplan.arp_col_toggle_selected .arppricetablecolumntitle .bestPlanTitle').offsetHeight;
                    if( new_height = max_height < new_height ){
                        max_height = new_height;
                    }
                }
            }
            for( var c = 0; c < tcol; c++ ){
                var col = cols[c];
                if (col.querySelector('.arpplan.arp_col_toggle_selected .arp_price_wrapper') != null ){
                    var price_header = col.querySelector('.arpplan.arp_col_toggle_selected .arp_price_wrapper').offsetHeight;
                    if( price_header && new_price_header < price_header ){
                        new_price_header = price_header;
                    }
                }
            }
            var arpcolumnheader_height = max_height + new_price_header;
            for( var c = 0; c < tcol; c++ ){
                var col = cols[c];
                if( col.querySelector('.arpplan.arp_col_toggle_selected .arpcolumnheader') != null ){
                    col.querySelector('.arpplan.arp_col_toggle_selected .arpcolumnheader').style.height = arpcolumnheader_height + 'px';
                }
            }
        } else if( template && price_wrapper_temp_obj.type_5.indexOf(template) > -1 ){

            var arpcolumnheader_height;
            var max_title_height=0;
            var max_price_height=0;
            var current_title_max_height = 0;
            for( var c = 0; c < tcol; c++ ){
                var col = cols[c];
                var arp_title_height = jQuery(col).find('.arpplan.arp_col_toggle_selected .arppricetablecolumntitle').outerHeight();
                var arp_price_height = jQuery(col).find('.arpplan.arp_col_toggle_selected .arppricetablecolumnprice').outerHeight();
                if(arp_title_height > max_title_height){
                    max_title_height = arp_title_height;
                }
                if(arp_price_height > max_price_height){
                    max_price_height = arp_price_height;
                }
                
                if( current_title_max_height < arp_title_height ){
                    current_title_max_height = arp_title_height;
                }
            }

            arpcolumnheader_height = max_title_height + arp_price_height;
            
            for( var c = 0; c < tcol; c++ ){
                var col = cols[c];
                if(col.querySelector('.arpplan.arp_col_toggle_selected .arpcaptiontitle') != null){
                    col.querySelector('.arpplan.arp_col_toggle_selected .arpcaptiontitle').style.height = max_price_height + 'px';
                }
                if( col.querySelector('.arpplan.arp_col_toggle_selected .arpcolumnheader') != null ){
                    col.querySelector('.arpplan.arp_col_toggle_selected .arpcolumnheader').style.height = arpcolumnheader_height + 'px';
                }

                if( col.querySelector('.arpplan.arp_col_toggle_selected .bestPlanTitle') != null ){
                    col.querySelector('.arpplan.arp_col_toggle_selected .bestPlanTitle').style.height = current_title_max_height + 'px';
                }
            }   
        }   
    }
}

function arp_column_desc_responsive() {
    var responsive_templates = responsive_json();
    var col_desc_temp_obj = responsive_templates.column_description_types;

    var template_container = document.getElementsByClassName('arp_template_main_container');
    var total_container = template_container.length;

    for( var t = 0; t < total_container; t++ ){
        var container = template_container[t];
        var step_cls = '.toggle_step_first';
        var is_column_desc = (container.querySelector('.column_description') != null) ? container.querySelectorAll('.column_description').length : 0;
        var template = container.getAttribute('data-reference-template');

        if( container.querySelector('#arprice_toggle_content_value') != null ){
            
            var switch_front_radio_val = container.querySelector('#arprice_toggle_content_value').value;
            

            var switch_steps = JSON.parse( document.getElementById("arp_toggle_swtich_steps").value );

            var step_keys = Object.keys(switch_steps);
            for( var k = 0; k < step_keys.length; k++ ){
                var ck = step_keys[k];
                var cur_step = switch_steps[ck];
                if( cur_step.indexOf(switch_front_radio_val) > -1 ){
                    var cstep = cur_step.split('|');
                    step_cls = '.'+cstep[parseInt(cstep.length) - 1];
                }
            }
        }

        if( template && template != "" && is_column_desc > 0 && col_desc_temp_obj.type_1.indexOf(template) == -1 ){

            var cols = container.querySelectorAll('.ArpPricingTableColumnWrapper');
            var tcols = cols.length;

            for( var c = 0; c < tcols; c++ ){
                var col = cols[c];
                if( col.querySelector('.column_description') != null ){
                    col.querySelector('.column_description').style.height = 'auto';
                }
            }

            var max_height = 0;
            var new_height = 0;
            for( var c = 0; c < tcols; c++ ){
                var col = cols[c];
                if( col.querySelector('.column_description'+step_cls) != null ){
                    new_height = col.querySelector('.column_description'+step_cls).offsetHeight;
                }

                if( new_height && max_height < new_height ){
                    max_height = new_height;
                }
            }

            for( var c = 0; c < tcols; c++ ){
                var col = cols[c];
                if( col.querySelector('.column_description'+step_cls) != null ){
                    col.querySelector('.column_description'+step_cls).style.height = max_height + 'px';
                }
            }
        }
    }
}

function arp_short_code_responsive() {
    var container = document.getElementsByClassName('arp_template_main_container');
    var total_con = container.length;

    for( var cn = 0; cn < total_con; cn++ ){
        var cur_con = container[cn];
        var arp_class = '';
        var max_height = 0;
        var new_height = 0;
        var reduce_height = 0;
        var template = cur_con.getAttribute('data-reference-template');

        if( template == 'arptemplate_8' || template == 'arptemplate_5' || template == 'arptemplate_7' ){
            arp_class = '.arp_header_shortcode.toggle_selected';
            if( template == 'arptemplate_7' ){
                reduce_height = 6;
            }
        } else if(template == 'arptemplate_26' || template == 'arptemplate_2' ){
            arp_class = '.arp_rounded_shortcode_wrapper.toggle_selected';
        } else if( template == 'arptemplate_4' ) {
            arp_class = '.arpcolumnheader';
        } else {
            continue;
        }

        var cols = cur_con.querySelectorAll('.ArpPricingTableColumnWrapper');
        var clen = cols.length;
        for( var c = 0; c < clen; c++ ){
            var col = cols[c];
            if( col.querySelector(arp_class) != null ){
                col.querySelector(arp_class).style.height = 'auto';
            }
        }

        for( var c = 0; c < clen; c++ ){
            var col = cols[c];
            if( col.querySelector(arp_class) != null ){
                new_height = col.querySelector(arp_class).offsetHeight;
                if( new_height && max_height < new_height ){
                    max_height = col.querySelector(arp_class).offsetHeight;
                }
            }
        }

        for( var c = 0; c < clen; c++ ){
            var col = cols[c];
            if( col.querySelector(arp_class) != null ){
                col.querySelector(arp_class).style.height = ( parseInt(max_height) - reduce_height ) + 'px';
            }
        }
    }
}

function arp_header_title_responsive(){

    var responsive_templates = responsive_json();
    var header_temp_obj_1 = responsive_templates.header_level_types_front_array_1;
    var header_temp_obj_2 = responsive_templates.header_level_types_front_array_2;

    var header_min_height = arp_header_min_height();
    
    var template_container = document.getElementsByClassName('arp_template_main_container');
    var total_temp_container = template_container.length;

    for(var t = 0; t < total_temp_container; t++ ){
        var cur_temp_container = template_container[t];
        var step_cls = '.toggle_step_first';
        var template = cur_temp_container.getAttribute('data-reference-template');
    
        var min_height = 0;
        if( typeof header_min_height[template] != 'undefined' ){
            min_height = header_min_height[template];
        }

        if( cur_temp_container.querySelector('#arprice_toggle_content_value') != null ){

            var switch_front_radio_val = cur_temp_container.querySelector('#arprice_toggle_content_value').value;

            var switch_steps = JSON.parse( document.getElementById("arp_toggle_swtich_steps").value );

            var step_keys = Object.keys(switch_steps);
            for( var k = 0; k < step_keys.length; k++ ){
                var ck = step_keys[k];
                var cur_step = switch_steps[ck];
                if( cur_step.indexOf(switch_front_radio_val) > -1 ){
                    var cstep = cur_step.split('|');
                    step_cls = '.'+cstep[parseInt(cstep.length) - 1];
                }
            }
        }

        if( template && template != "" ){
            var cols = cur_temp_container.querySelectorAll('.ArpPricingTableColumnWrapper:not(.arp_hidden_captioncolumn)');
            var total_cols = cols.length;          

            if( header_temp_obj_1.type_4.indexOf(template) > -1 ){
                for(var c = 0; c < total_cols; c++ ){
                    var cur_col = cols[c];
                    if( cur_col.querySelector('.arpplan.arp_col_toggle_selected .arp_header_shortcode'+step_cls) != null ){
                        cur_col.querySelector('.arpplan.arp_col_toggle_selected .arp_header_shortcode'+step_cls).style.height = 'auto';
                    }
                }
            }

            var max_height = 0;
            var max_title_container_height = 0;

            for( var c = 0; c < total_cols; c++ ){
                var cur_col = cols[c];
                if( header_temp_obj_1.type_1.indexOf(template) > -1 ){
                    var offset_height = 0;
                    if( typeof cur_col.querySelector('.arpplan.arp_col_toggle_selected .bestPlanTitle') != 'undefined' && cur_col.querySelector('.arpplan.arp_col_toggle_selected .bestPlanTitle') != null ){
                        offset_height = cur_col.querySelector('.arpplan.arp_col_toggle_selected .bestPlanTitle').offsetHeight;
                    }

                    if( typeof cur_col.querySelector('.arpplan.arp_col_toggle_selected .arpcaptiontitle') != 'undefined' && cur_col.querySelector('.arpplan.arp_col_toggle_selected .arpcaptiontitle') != null ){
                        offset_height = cur_col.querySelector('.arpplan.arp_col_toggle_selected .arpcaptiontitle').offsetHeight;
                    }

                    if( offset_height < min_height ){
                        offset_height = min_height;
                    }

                    if( max_height < offset_height ){
                        max_height = offset_height;
                    }
                } else if( header_temp_obj_1.type_3.indexOf(template) > -1 ){
                    var offset_height = 0;
                    if( typeof cur_col.querySelector('.arpplan.arp_col_toggle_selected .arppricetablecolumntitle') != 'undefined' && cur_col.querySelector('.arpplan.arp_col_toggle_selected .arppricetablecolumntitle') != null ){
                        offset_height = cur_col.querySelector('.arpplan.arp_col_toggle_selected .arppricetablecolumntitle').offsetHeight;
                    }
                    if( offset_height < min_height ){
                        offset_height = min_height;
                    }
                    if( max_height < offset_height ){
                        max_height = offset_height;
                    }
                } else {
                    var col_header = '';
                    var new_height = 0;

                    if(typeof cur_col.querySelector('.arpplan.arp_col_toggle_selected .arpcolumnheader') != 'undefined'){
                        col_header = cur_col.querySelector('.arpplan.arp_col_toggle_selected .arpcolumnheader');
                    }

                    if( col_header.querySelector('.arpplan.arp_col_toggle_selected .bestPlanTitle') != null ){
                        new_height = col_header.querySelector('.arpplan.arp_col_toggle_selected .bestPlanTitle').offsetHeight;
                        if( new_height < min_height ){
                            new_height = min_height;
                        }
                    }

                    if( max_height < new_height ){
                        max_height = new_height;
                        max_title_container_height = new_height;
                    }
                }
            }

            var max_height_shortcode = 0;

            if (header_temp_obj_1.type_4.indexOf(template) > -1) {
                for( var c = 0; c < total_cols; c++ ){
                    var cur_col = cols[c];
                    var shortcode_height = 0;

                    if( cur_col.querySelector('.arpplan.arp_col_toggle_selected .arp_header_shortcode') != null ){
                        shortcode_height = cur_col.querySelector('.arpplan.arp_col_toggle_selected .arp_header_shortcode').offsetHeight;
                    }

                    if( max_height < shortcode_height ){
                        max_height = shortcode_height;
                    }
                }

                for( var c = 0; c < total_cols; c++ ){
                    var cur_col = cols[c];
                    shortcode_height = cur_col.querySelector('.arpplan.arp_col_toggle_selected .arp_header_shortcode').style.height = max_height + 'px';
                }
            }
            
            for(var c = 0; c < total_cols; c++ ){
                var cur_col = cols[c];
                if (header_temp_obj_2.type_4.indexOf(template) > -1){
                    var col_header = '';
                    if( typeof cur_col.querySelector('.arpplan.arp_col_toggle_selected .arpcolumnheader') != 'undefined' ){
                        cur_col.querySelector('.arpplan.arp_col_toggle_selected .arpcolumnheader').style.height = max_height + 'px';
                        col_header = cur_col.querySelector('.arpplan.arp_col_toggle_selected .arpcolumnheader');
                    }

                    if( col_header != '' && typeof col_header.querySelector('.arpplan.arp_col_toggle_selected .arpcaptiontitle') != 'undefined' && col_header.querySelector('.arpplan.arp_col_toggle_selected .arpcaptiontitle') != null ){
                        col_header.querySelector('.arpplan.arp_col_toggle_selected .arpcaptiontitle').style.height = (parseInt(max_height) - 40)+ 'px';
                    }

                    if( col_header != '' && typeof col_header.querySelector('.arpplan.arp_col_toggle_selected .bestPlanTitle') != 'undefined' && col_header.querySelector('.arpplan.arp_col_toggle_selected .bestPlanTitle') != null ){
                        var tmp_max_height = ( parseInt(max_height) - 40 );
                        if( tmp_max_height < min_height ){
                            tmp_max_height = parseInt( min_height );
                        }
                        col_header.querySelector('.arpplan.arp_col_toggle_selected .bestPlanTitle').style.height = tmp_max_height + 'px';
                    }
                } else if (header_temp_obj_2.type_1.indexOf(template) > -1){
                    var col_header = '';
                    if( typeof cur_col.querySelector('.arpplan.arp_col_toggle_selected .arpcolumnheader') != 'undefined' ){
                        col_header = cur_col.querySelector('.arpplan.arp_col_toggle_selected .arpcolumnheader');
                    }
                    if( col_header != '' && col_header.querySelector('.arpplan.arp_col_toggle_selected .bestPlanTitle') != null ){
                        col_header.querySelector('.arpplan.arp_col_toggle_selected .bestPlanTitle').style.height = max_height+ 'px';
                    }

                    if( null != cur_col.querySelector('.arpplan.arp_col_toggle_selected  .arpcaptiontitle') && typeof cur_col.querySelector('.arpplan.arp_col_toggle_selected  .arpcaptiontitle') != 'undefined' ){
                        cur_col.querySelector('.arpplan.arp_col_toggle_selected  .arpcaptiontitle').style.marginTop = max_height + 'px';
                    }
                } else if( header_temp_obj_2.type_5.indexOf(template) > -1 ){
                    var col_header = '';
                    if( typeof cur_col.querySelector('.arpplan.arp_col_toggle_selected .arpcolumnheader') != 'undefined' ){
                        col_header = cur_col.querySelector('.arpplan.arp_col_toggle_selected .arpcolumnheader');
                    }

                    if( col_header != '' && typeof col_header.querySelector('.arpplan.arp_col_toggle_selected .arppricetablecolumntitle') != 'undefined' && col_header.querySelector('.arpplan.arp_col_toggle_selected .arppricetablecolumntitle') != null ){
                        col_header.querySelector('.arpplan.arp_col_toggle_selected .arppricetablecolumntitle').style.height = max_height + 'px';
                    }

                    if( typeof cur_col.querySelector('.arpplan.arp_col_toggle_selected .arpcaptiontitle') != 'undefined' && cur_col.querySelector('.arpplan.arp_col_toggle_selected .arpcaptiontitle') != null ){
                        cur_col.querySelector('.arpplan.arp_col_toggle_selected .arpcaptiontitle').style.marginTop = max_height + 'px';
                    }
                } else if (header_temp_obj_2.type_2.indexOf(template) > -1) {
                    var col_header = '';

                    if( typeof cur_col.querySelector('.arpplan.arp_col_toggle_selected .arpcolumnheader') != 'undefined' ){
                        col_header = cur_col.querySelector('.arpplan.arp_col_toggle_selected .arpcolumnheader');
                    }

                    if( col_header != '' && typeof col_header.querySelector('.arpplan.arp_col_toggle_selected .bestPlanTitle') != 'undefined' ){
                        col_header.querySelector('.arpplan.arp_col_toggle_selected .bestPlanTitle').style.height = max_height + 'px';
                    }

                    if( col_header != '' && typeof col_header.querySelector('.arpplan.arp_col_toggle_selected .arpcaptiontitle') != 'undefined' ){
                        var first_col = cur_temp_container.querySelector('.ArpPricingTableColumnWrapper:not(.maincaptioncolumn) .arpplan.arp_col_toggle_selected .arppricetablecolumntitle');
                        col_header.querySelector('.arpplan.arp_col_toggle_selected .arpcaptiontitle').style.marginTop = (parseInt(first_col.outerHeight) + 1) + 'px';
                    }
                } else {
                    var col_header = '';
                    if( typeof cur_col.querySelector('.arpplan.arp_col_toggle_selected .arpcolumnheader') != 'undefined' ){
                        col_header = cur_col.querySelector('.arpplan.arp_col_toggle_selected .arpcolumnheader');
                    }

                    if( col_header.querySelector('.arpplan.arp_col_toggle_selected .bestPlanTitle') != null ){
                        col_header.querySelector('.arpplan.arp_col_toggle_selected .bestPlanTitle').style.height = max_title_container_height + 'px';
                    }
                }
            }

            if( header_temp_obj_1.type_4.indexOf(template) > -1 ){
                for( var c = 0; c < total_cols; c++ ){
                    var cur_col = cols[c];
                    var col_header = '';
                    if( typeof cur_col.querySelector('.arpplan.arp_col_toggle_selected .arpcolumnheader') != 'undefined' ){
                        col_header = cur_col.querySelector('.arpplan.arp_col_toggle_selected .arpcolumnheader');
                    }

                    if( col_header.querySelector('.arpplan.arp_col_toggle_selected .arp_header_shortcode'+step_cls) != null ){
                        col_header.querySelector('.arpplan.arp_col_toggle_selected .arp_header_shortcode'+step_cls).style.height = max_height + 'px';
                    }

                }
            }

        }
        
    }
}

function arp_header_min_height(){
    return {
        'arptemplate_1':80,
        'arptemplate_2':63,
        'arptemplate_3':70,
        'arptemplate_4':0,
        'arptemplate_5':55,
        'arptemplate_6':95,
        'arptemplate_7':0,
        'arptemplate_8':0,
        'arptemplate_9':0,
        'arptemplate_10':50,
        'arptemplate_11':80,
        'arptemplate_12':0,
        'arptemplate_13':60,
        'arptemplate_14':0,
        'arptemplate_15':60,
        'arptemplate_16':80,
        'arptemplate_17':0,
        'arptemplate_18':0,
        'arptemplate_19':0,
        'arptemplate_20':0,
        'arptemplate_21':0,
        'arptemplate_22':0,
        'arptemplate_23':124,
        'arptemplate_24':100
    };
}

function arp_column_wrapper_height(toggle) {
    // console.log(jQuery('arp_template_main_container').width());
    var containers = document.getElementsByClassName('arp_template_main_container');
    var total_con = containers.length;
    for( var t = 0; t < total_con; t++ ){
        
        var container = containers[t];
        
        var reference_template = container.getAttribute('data-reference-template');
        var mobile_width = container.getAttribute('data-mobile-width');
        var is_animated = container.getAttribute('data-is-animated');
        var hover_effect = container.getAttribute('data-hover-type');

        var window_width = jQuery(window).width();

        var plus_height = container.getAttribute('data-column-wrapper-width-arr');
        var highlighted_plus_height = container.getAttribute('data-column-wrapper-highlighted-height');
        var default_height = container.getAttribute('data-column-wrapper-default-height');

        default_height = parseInt(default_height);
        plus_height = parseInt(plus_height);
        highlighted_plus_height = parseInt(highlighted_plus_height);

        var column_max_height = 0;

        var cols = container.querySelectorAll('.ArpPricingTableColumnWrapper');
        var tcols = cols.length;

        var arpOriginalHeight = false;
        var OriginalHeights = [];

        if( window_width <= mobile_width ){
        	arpOriginalHeight = true;
        }

        for( var c = 0; c < tcols; c++ ){
            var col = cols[c];
            col.style.height = 'auto';
            var col_id = col.getAttribute('id');

            if( window_width > mobile_width ){
                if( is_animated == 0){
                    col.style.marginBottom = '20px';
                } else {
                    col.style.marginBottom = '40px';
                }

                if( jQuery(col).parents('.widget_arp_widget') ){
                    if( is_animated == 0 ){
                        col.style.marginBottom = '10px';
                    } else {
                        col.style.marginBottom = '30px';
                    }
                }
            } else {
                if( is_animated == 0 ){
                    col.style.marginBottom = '10px';
                } else {
                    col.style.marginBottom = '30px';
                }
            }

            var column_height = col.querySelector('.arpplan.arp_col_toggle_selected').offsetHeight;

            if( toggle !== undefined ){
                if( navigator.userAgent.toLowerCase().indexOf('safari/') > -1){
                    if( col.querySelector('.arp_column_content_wrapper') != null ){
                        column_height = col.querySelector('.arp_column_content_wrapper').offsetHeight;
                        
                    }
                }
            }

            if( arpOriginalHeight ){
            	OriginalHeights[col_id] = column_height;
            }

            if( hover_effect == 'hover_effect' && col.getAttribute('class').indexOf('column_height') == -1){

                if( column_height > column_max_height ){
                    column_max_height = column_height + plus_height;
                }
            } else if( hover_effect == 'hover_effect' && col.getAttribute('class').indexOf('column_height') > -1 ){
                if( column_height > column_max_height ){
                    column_max_height = column_height;
                }

                if( plus_height < 0 ){
                    column_max_height = column_height + plus_height;
                }
                column_max_height = column_max_height - highlighted_plus_height;
            } else {
                if( column_height > column_max_height ){
                    column_max_height = col.offsetHeight + default_height;
                }
            }
        }

        if( reference_template == 'arptemplate_25' ){
            column_max_height = column_max_height - highlighted_plus_height;
        }

        if( is_animated == 0 ){
            for( var c = 0; c < tcols; c++ ){
                var col = cols[c];
                var col_id = col.getAttribute('id');
                if( col.offsetHeight > 0 && col.offsetWidth > 0 ){
                    if( reference_template == 'arptemplate_9' && col.getAttribute('class').indexOf('maincaptioncolumn') > -1 && jQuery(window).width() < 420 ){
                        if( col.querySelector('.arpcaptiontitle') ){
                            col.querySelector('.arpcaptiontitle').style.marginTop = '0px';
                        }
                        if( col.querySelector('.arpcolumnheader') != null ){
                            col.querySelector('.arpcolumnheader').style.minHeight = '0px';
                        }
                        if( arpOriginalHeight ){
                        	col.style.height = ( parseInt( OriginalHeights[col_id] ) + 25 ) + 'px';
                        } else {
                        	col.style.height = (col.offsetHeight + 25) + 'px';                        	
                        }
                    } else {
                    	if( arpOriginalHeight ){
                    		col.style.height = ( parseInt( OriginalHeights[col_id] ) + 25 ) + 'px';
                    	} else {
                        	col.style.height = column_max_height + 'px';
                    	}
                    }
                }
            }
        }
    }
}

function arprice_update_renderer(props, id) {
	
	props.attributes.table_id = id;
	props.setAttributes({ updated: Date.now() });
}

(function (blocks, components, i18n, element) {
	var el = wp.element.createElement,
		registerBlockType = wp.blocks.registerBlockType;
	source = wp.blocks.source;
	var __ = wp.i18n.__;
	const arpricelogo = el(
		'svg',
		{ 
            width:20, 
            height:20, 
            viewBox:'-3.5 -1 24 24', 
            style:{fill:'#4f61e1'}},
		el(
			'path',
			{
				d: "m10.005,22.007l0,-1.985l7.008,0l0,1.985l-7.008,0zm5.001,-8.005l1.994,0l0,6.01l-1.993,0l0,-6.01l-0.001,0zm-2.35,5.014l-8.294,0c-0.745,0 -1.349,-0.547 -1.349,-1.222l0,-13.568c0,-0.674 0.604,-1.221 1.349,-1.221l8.293,0c0.745,0 1.35,0.547 1.35,1.221l0,13.568c0,0.675 -0.604,1.222 -1.349,1.222zm-0.647,-14.006l-7,0l0,12l7,0l0,-12zm-1.009,3.999l-4.978,0l0,-2l4.978,0l0,2zm0,3.004l-4.978,0l0,-2.016l4.978,0l0,2.016zm0,2.998l-4.978,0l0,-2.01l4.978,0l0,2.01zm-8.993,-7.006l-2.004,0l0,-5.992l-0.003,0l0,-2.013l7.008,0l0,2.013l-5,0l0,5.992l-0.001,0z"
			}
		)
	);

	let blockRender = (props) => {
		let z = { key: "arprice-block-custom-controls" };

		if (props.attributes.table_id != "") {
			var edit_form_url = arprice_gutenberg_script_objects.arprice_edit_gutenberg_adminurl + "&eid=" + props.attributes.table_id;
			var edit_target = "_blank";
		}

		let disableMulticol;
		if ('undefined' != typeof arprice_gutenberg_script_objects.is_widget_page && true == arprice_gutenberg_script_objects.is_widget_page) {
			props.attributes.is_widget_form = true;
			disableMulticol = wp.element.createElement(
				wp.components.ToggleControl,
				{
					label: wp.i18n.__('Disable Multicolumn', 'arprice'),
					checked: props.attributes.disable_multicolumn,
					onChange: function (e) {
						props.attributes.disable_multicolumn = e;
						props.setAttributes({ updated: Date.now() });
					}
				}
			);
		}

		let arprice_shortcode = [
			wp.element.createElement(
				'DIV',
				{
					className: 'arprice-main-block-div'
				},
				wp.element.createElement(
					wp.blockEditor.InspectorControls,
					z,
					wp.element.createElement(
						wp.components.PanelBody,
						{
							title: wp.i18n.__('ARPice Table Settings', 'arprice'),
							initialOpen: false
						},
						wp.element.createElement(
							wp.components.SelectControl,
							{
								className: "arprice_table_display",
								label: wp.i18n.__("Table", "arprice"),
								value: props.attributes.table_id,
								options: arprice_get_form_list(),
								onChange: function (e) {
									
									arp_button_height_responsive();
									arprice_update_renderer(props, e);
									
								}
							},
						),
						disableMulticol
					)
				),
				wp.element.createElement(
					wp.serverSideRender,
					{
						"block": "arprice/arp-table",
						"attributes": props.attributes,
					}
				)
			),
			wp.element.createElement(
				wp.blockEditor.BlockControls,
				z,
				wp.element.createElement(
					wp.components.ToolbarButton,
					{
						label: "Edit Form",
						icon: 'dashicons-before dashicons-edit-page',
						href: edit_form_url,
						target: edit_target
					}
				)
			)
		];


		return arprice_shortcode;
	};
	registerBlockType(
		'arprice/arp-table',
		{
			title: __('ARPrice'),
			icon: arpricelogo,
			category: 'arprice',
			description: wp.i18n.__("Select and display one of your table.", 'arprice'),
			keywords: [__( 'Pricing' ),__( 'Table' ),__( 'ARPrice' )],
			insert: function () {

			},
			edit: function (f) {
				return blockRender(f);
			},
			save: function (f) {

			}
		}
	);
})(
	window.wp.blocks,
	window.wp.components,
	window.wp.i18n,
	window.wp.element,
	window.wp.editor
);